/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.j9.stackmap;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.j9.AlgorithmVersion;
import com.ibm.j9ddr.vm29.j9.ArgBits;
import com.ibm.j9ddr.vm29.j9.PCStack;
import com.ibm.j9ddr.vm29.j9.ROMHelp;
import com.ibm.j9ddr.vm29.j9.VrfyTbl;
import com.ibm.j9ddr.vm29.j9.stackmap.MapHelpers;
import com.ibm.j9ddr.vm29.pointer.U8Pointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ExceptionHandlerPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ExceptionInfoPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMMethodPointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9UTF8Helper;
import com.ibm.j9ddr.vm29.structure.J9JavaAccessFlags;
import com.ibm.j9ddr.vm29.types.I16;
import com.ibm.j9ddr.vm29.types.I32;
import com.ibm.j9ddr.vm29.types.IDATA;
import com.ibm.j9ddr.vm29.types.UDATA;
import java.util.Arrays;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DebugLocalMap {
    private static Logger logger = Logger.getLogger("j9ddr.stackwalker.localmap");
    private static final int BRANCH_TARGET = 1;
    private static final int BRANCH_EXCEPTION_START = 2;
    private static final int BRANCH_TARGET_IN_USE = 4;
    private static final int BRANCH_TARGET_TO_WALK = 8;
    private static final int[] decodeTable = new int[]{0, -16777214, 17, 33, 65, 129, 6, 0, 8, 9, 10, 11, 12, 13, 14, 15};
    private static DebugLocalMapImpl impl;

    public static int j9localmap_DebugLocalBitsForPC(J9ROMMethodPointer j9ROMMethodPointer, UDATA uDATA, int[] nArray) throws CorruptDataException {
        return DebugLocalMap.getImpl().j9localmap_DebugLocalBitsForPC(j9ROMMethodPointer, uDATA, nArray);
    }

    private static DebugLocalMapImpl getImpl() {
        if (impl == null) {
            impl = DebugLocalMap.getImpl("ALG_DEBUG_LOCAL_MAP_VERSION");
        }
        return impl;
    }

    private static DebugLocalMapImpl getImpl(String string) {
        AlgorithmVersion algorithmVersion = AlgorithmVersion.getVersionOf(string);
        switch (algorithmVersion.getAlgorithmVersion()) {
            default: 
        }
        return new DebugLocalMap_V1();
    }

    private static class DebugLocalMap_V1
    implements DebugLocalMapImpl {
        private DebugLocalMap_V1() {
        }

        @Override
        public int j9localmap_DebugLocalBitsForPC(J9ROMMethodPointer j9ROMMethodPointer, UDATA uDATA, int[] nArray) throws CorruptDataException {
            DebugLocalMapData debugLocalMapData = new DebugLocalMapData();
            logger.logp(Level.FINE, "DebugLocalMap", "j9localmap_DebugLocalBitsForPC", "[][][] entering DEBUG local map in {0}{1} at {2}\n", new Object[]{J9UTF8Helper.stringValue(j9ROMMethodPointer.nameAndSignature().name()), J9UTF8Helper.stringValue(j9ROMMethodPointer.nameAndSignature().signature()), uDATA});
            debugLocalMapData.romMethod = j9ROMMethodPointer;
            debugLocalMapData.targetPC = uDATA.intValue();
            debugLocalMapData.resultsArray = nArray;
            UDATA uDATA2 = ROMHelp.J9_BYTECODE_SIZE_FROM_ROM_METHOD(j9ROMMethodPointer);
            debugLocalMapData.bytecodeMap = new byte[uDATA2.intValue()];
            debugLocalMapData.mapArray = new int[uDATA2.intValue()];
            this.debugBuildBranchMap(debugLocalMapData);
            this.debugMapAllLocals(debugLocalMapData);
            return 0;
        }

        private void debugMapAllLocals(DebugLocalMapData debugLocalMapData) throws CorruptDataException {
            J9ROMMethodPointer j9ROMMethodPointer = debugLocalMapData.romMethod;
            int n = 0;
            int n2 = 0;
            int n3 = ROMHelp.J9_TEMP_COUNT_FROM_ROM_METHOD(j9ROMMethodPointer).add(ROMHelp.J9_ARG_COUNT_FROM_ROM_METHOD(j9ROMMethodPointer)).intValue();
            int[] nArray = debugLocalMapData.resultsArray;
            UDATA uDATA = ROMHelp.J9_BYTECODE_SIZE_FROM_ROM_METHOD(j9ROMMethodPointer);
            ArgBits.argBitsFromSignature(J9UTF8Helper.stringValue(j9ROMMethodPointer.nameAndSignature().signature()), debugLocalMapData.resultsArray, n3 + 31 >> 5, j9ROMMethodPointer.modifiers().anyBitsIn(J9JavaAccessFlags.J9AccStatic));
            while (n3 != 0) {
                n3 = n3 > 32 ? (n3 -= 32) : 0;
                debugLocalMapData.currentLocals = nArray[n2];
                Arrays.fill(debugLocalMapData.mapArray, 0, uDATA.intValue(), 0);
                this.debugMapLocalSet(debugLocalMapData, n);
                if (n3 != 0) {
                    int n4 = 0;
                    while (n4 < uDATA.intValue()) {
                        int n5 = n4++;
                        debugLocalMapData.bytecodeMap[n5] = (byte)(debugLocalMapData.bytecodeMap[n5] & 3);
                    }
                }
                nArray[n2] = debugLocalMapData.mapArray[debugLocalMapData.targetPC];
                ++n2;
                n += 32;
            }
        }

        private int debugMapLocalSet(DebugLocalMapData debugLocalMapData, int n) throws CorruptDataException {
            J9ROMMethodPointer j9ROMMethodPointer = debugLocalMapData.romMethod;
            byte[] byArray = debugLocalMapData.bytecodeMap;
            int n2 = 0;
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = j9ROMMethodPointer.modifiers().anyBitsIn(J9JavaAccessFlags.J9AccMethodHasExceptionInfo);
            J9ExceptionInfoPointer j9ExceptionInfoPointer = ROMHelp.J9_EXCEPTION_DATA_FROM_ROM_METHOD(j9ROMMethodPointer);
            U8Pointer u8Pointer = ROMHelp.J9_BYTECODE_START_FROM_ROM_METHOD(j9ROMMethodPointer);
            int n3 = ROMHelp.J9_BYTECODE_SIZE_FROM_ROM_METHOD(j9ROMMethodPointer).intValue();
            U8Pointer u8Pointer2 = u8Pointer;
            while (n2 < n3) {
                UDATA uDATA;
                J9ExceptionHandlerPointer j9ExceptionHandlerPointer;
                int n4 = n2;
                if ((byArray[n4] & 2) != 0) {
                    j9ExceptionHandlerPointer = ROMHelp.J9EXCEPTIONINFO_HANDLERS(j9ExceptionInfoPointer);
                    uDATA = new UDATA(0L);
                    while (uDATA.lt(j9ExceptionInfoPointer.catchCount())) {
                        if (n4 == j9ExceptionHandlerPointer.startPC().intValue()) {
                            this.debugMergeStacks(debugLocalMapData, j9ExceptionHandlerPointer.handlerPC().intValue());
                        }
                        j9ExceptionHandlerPointer = j9ExceptionHandlerPointer.add(1L);
                        uDATA = uDATA.add(1L);
                    }
                }
                if ((byArray[n4] & 1) != 0 && !bl) {
                    this.debugMergeStacks(debugLocalMapData, n4);
                    if (!debugLocalMapData.rootStack.isEmpty()) {
                        n2 = debugLocalMapData.rootStack.pop();
                        debugLocalMapData.currentLocals = debugLocalMapData.mapArray[n2];
                        int n5 = n2;
                        byArray[n5] = (byte)(byArray[n5] & 0xFFFFFFF7);
                        bl = true;
                    } else {
                        return 0;
                    }
                }
                bl = false;
                u8Pointer2 = u8Pointer.add(n4);
                int n6 = u8Pointer2.at(0L).intValue() & 0xFF;
                if ((PCStack.J9JavaInstructionSizeAndBranchActionTable[n6] & 7) == 0) {
                    throw new CorruptDataException("Invalid byte code");
                }
                n2 += PCStack.J9JavaInstructionSizeAndBranchActionTable[n6] & 7;
                int n7 = VrfyTbl.J9JavaBytecodeVerificationTable[n6];
                int n8 = n7 >>> 8;
                int n9 = n7 >>> 4 & 0xF;
                n7 = decodeTable[n7 & 0xF];
                n9 = decodeTable[n9];
                switch (n8) {
                    case 21: {
                        bl2 = true;
                    }
                    case 6: {
                        int n10 = n9 & 7;
                        if (n9 == 0) {
                            n10 = MapHelpers.PARAM_8(u8Pointer2, 1).intValue();
                            if (bl2) {
                                n10 = MapHelpers.PARAM_16(u8Pointer2, 1).intValue();
                                bl2 = false;
                            }
                        }
                        if ((n10 -= n) < 32) {
                            int n11 = 1 << n10;
                            if (n7 == 0) {
                                debugLocalMapData.currentLocals |= n11;
                            } else {
                                debugLocalMapData.currentLocals &= ~n11;
                                if ((n7 & 0xC0) != 0) {
                                    debugLocalMapData.currentLocals &= ~(n11 <<= 1);
                                }
                            }
                        }
                        if (!bl3) break;
                        j9ExceptionHandlerPointer = ROMHelp.J9EXCEPTIONINFO_HANDLERS(j9ExceptionInfoPointer);
                        uDATA = new UDATA(0L);
                        while (uDATA.lt(j9ExceptionInfoPointer.catchCount())) {
                            if (n4 >= j9ExceptionHandlerPointer.startPC().intValue() && n4 < j9ExceptionHandlerPointer.endPC().intValue()) {
                                this.debugMergeStacks(debugLocalMapData, j9ExceptionHandlerPointer.handlerPC().intValue());
                            }
                            j9ExceptionHandlerPointer = j9ExceptionHandlerPointer.add(1L);
                            uDATA = uDATA.add(1L);
                        }
                        break;
                    }
                    case 14: {
                        int n12;
                        int n13 = n9 & 7;
                        if (n6 == 200) {
                            int n14 = new I32(MapHelpers.PARAM_32(u8Pointer2, 1)).intValue();
                            n12 = n4 + n14;
                        } else {
                            int n15 = new I16(MapHelpers.PARAM_16(u8Pointer2, 1)).intValue();
                            n12 = n4 + n15;
                        }
                        this.debugMergeStacks(debugLocalMapData, n12);
                        if (n13 != 0) break;
                        if (!debugLocalMapData.rootStack.isEmpty()) {
                            n2 = debugLocalMapData.rootStack.pop();
                            debugLocalMapData.currentLocals = debugLocalMapData.mapArray[n2];
                            int n16 = n2;
                            byArray[n16] = (byte)(byArray[n16] & 0xFFFFFFF7);
                            bl = true;
                            break;
                        }
                        return 0;
                    }
                    case 15: {
                        if (!debugLocalMapData.rootStack.isEmpty()) {
                            n2 = debugLocalMapData.rootStack.pop();
                            debugLocalMapData.currentLocals = debugLocalMapData.mapArray[n2];
                            int n17 = n2;
                            byArray[n17] = (byte)(byArray[n17] & 0xFFFFFFF7);
                            bl = true;
                            break;
                        }
                        return 0;
                    }
                    case 19: {
                        int n18;
                        int n19;
                        if (n6 == 191) {
                            if (!debugLocalMapData.rootStack.isEmpty()) {
                                n2 = debugLocalMapData.rootStack.pop();
                                debugLocalMapData.currentLocals = debugLocalMapData.mapArray[n2];
                                int n20 = n2;
                                byArray[n20] = (byte)(byArray[n20] & 0xFFFFFFF7);
                                bl = true;
                                break;
                            }
                            return 0;
                        }
                        if (n6 != 170 && n6 != 171) break;
                        u8Pointer2 = U8Pointer.cast(UDATA.cast(u8Pointer2).add(4L).bitAnd(new UDATA(3L).bitNot()));
                        int n21 = new I32(MapHelpers.PARAM_32(u8Pointer2, 0)).intValue();
                        u8Pointer2 = u8Pointer2.add(4L);
                        int n12 = n4 + n21;
                        this.debugMergeStacks(debugLocalMapData, n12);
                        int n22 = new I32(MapHelpers.PARAM_32(u8Pointer2, 0)).intValue();
                        u8Pointer2 = u8Pointer2.add(4L);
                        if (n6 == 170) {
                            int n23 = new I32(MapHelpers.PARAM_32(u8Pointer2, 0)).intValue();
                            u8Pointer2 = u8Pointer2.add(4L);
                            n19 = n23 - n22 + 1;
                            n18 = 0;
                        } else {
                            n19 = n22;
                            n18 = 4;
                        }
                        while (n19 > 0) {
                            u8Pointer2 = u8Pointer2.add(n18);
                            n21 = new I32(MapHelpers.PARAM_32(u8Pointer2, 0)).intValue();
                            u8Pointer2 = u8Pointer2.add(4L);
                            n12 = n4 + n21;
                            this.debugMergeStacks(debugLocalMapData, n12);
                            --n19;
                        }
                        if (!debugLocalMapData.rootStack.isEmpty()) {
                            n2 = debugLocalMapData.rootStack.pop();
                            debugLocalMapData.currentLocals = debugLocalMapData.mapArray[n2];
                            int n24 = n2;
                            byArray[n24] = (byte)(byArray[n24] & 0xFFFFFFF7);
                            bl = true;
                            break;
                        }
                        return 0;
                    }
                }
            }
            return -1;
        }

        private void debugMergeStacks(DebugLocalMapData debugLocalMapData, int n) {
            if ((debugLocalMapData.bytecodeMap[n] & 4) != 0) {
                int n2 = debugLocalMapData.mapArray[n] & debugLocalMapData.currentLocals;
                if (n2 == debugLocalMapData.mapArray[n]) {
                    return;
                }
                debugLocalMapData.mapArray[n] = n2;
                if ((debugLocalMapData.bytecodeMap[n] & 8) != 0) {
                    return;
                }
            } else {
                debugLocalMapData.mapArray[n] = debugLocalMapData.currentLocals;
                int n3 = n;
                debugLocalMapData.bytecodeMap[n3] = (byte)(debugLocalMapData.bytecodeMap[n3] | 4);
            }
            debugLocalMapData.rootStack.push(n);
            int n4 = n;
            debugLocalMapData.bytecodeMap[n4] = (byte)(debugLocalMapData.bytecodeMap[n4] | 8);
        }

        private int debugBuildBranchMap(DebugLocalMapData debugLocalMapData) throws CorruptDataException {
            J9ExceptionInfoPointer j9ExceptionInfoPointer;
            UDATA uDATA;
            int n;
            int n2;
            U8Pointer u8Pointer;
            J9ROMMethodPointer j9ROMMethodPointer = debugLocalMapData.romMethod;
            byte[] byArray = debugLocalMapData.bytecodeMap;
            int n3 = 0;
            U8Pointer u8Pointer2 = u8Pointer = ROMHelp.J9_BYTECODE_START_FROM_ROM_METHOD(j9ROMMethodPointer);
            U8Pointer u8Pointer3 = u8Pointer.add(ROMHelp.J9_BYTECODE_SIZE_FROM_ROM_METHOD(j9ROMMethodPointer));
            if (u8Pointer2.at(debugLocalMapData.targetPC).eq(185L)) {
                debugLocalMapData.targetPC -= 2;
            }
            byArray[debugLocalMapData.targetPC] = 1;
            ++n3;
            block5: while (u8Pointer2.lt(u8Pointer3)) {
                int n4 = u8Pointer2.at(0L).intValue() & 0xFF;
                int n5 = PCStack.J9JavaInstructionSizeAndBranchActionTable[n4];
                switch (n5 >> 4) {
                    case 5: {
                        UDATA uDATA2;
                        int n6 = IDATA.cast(u8Pointer2.sub(UDATA.cast(u8Pointer))).intValue();
                        n2 = n6 + 4 & 0xFFFFFFFC;
                        u8Pointer2 = u8Pointer.add(n2);
                        int n7 = new I32(MapHelpers.PARAM_32(u8Pointer2, 0)).intValue();
                        u8Pointer2 = u8Pointer2.add(4L);
                        if (byArray[n6 + n7] == 0) {
                            byArray[n6 + n7] = 1;
                            ++n3;
                        }
                        int n8 = new I32(MapHelpers.PARAM_32(u8Pointer2, 0)).intValue();
                        u8Pointer2 = u8Pointer2.add(4L);
                        if (n4 == 170) {
                            int n9 = new I32(MapHelpers.PARAM_32(u8Pointer2, 0)).intValue();
                            u8Pointer2 = u8Pointer2.add(4L);
                            uDATA2 = new UDATA(n9 - n8 + 1);
                            n = 0;
                        } else {
                            uDATA2 = new UDATA(n8);
                            n = 4;
                        }
                        uDATA = new UDATA(0L);
                        while (uDATA.lt(uDATA2)) {
                            u8Pointer2 = u8Pointer2.add(n);
                            n7 = new I32(MapHelpers.PARAM_32(u8Pointer2, 0)).intValue();
                            u8Pointer2 = u8Pointer2.add(4L);
                            if (byArray[n6 + n7] == 0) {
                                byArray[n6 + n7] = 1;
                                ++n3;
                            }
                            uDATA = uDATA.add(1L);
                        }
                        continue block5;
                    }
                    case 2: {
                        int n7;
                        int n6;
                        if (n4 == 200) {
                            n6 = IDATA.cast(u8Pointer2.sub(UDATA.cast(u8Pointer))).intValue();
                            if (byArray[n6 + (n7 = new I32(MapHelpers.PARAM_32(u8Pointer2, 1)).intValue())] != 0) break;
                            byArray[n6 + n7] = 1;
                            ++n3;
                            break;
                        }
                    }
                    case 1: {
                        int n10 = new I16(MapHelpers.PARAM_16(u8Pointer2, 1)).intValue();
                        int n6 = IDATA.cast(u8Pointer2.sub(UDATA.cast(u8Pointer))).intValue();
                        if (byArray[n6 + n10] != 0) break;
                        byArray[n6 + n10] = 1;
                        ++n3;
                    }
                }
                u8Pointer2 = u8Pointer2.add(n5 & 7);
            }
            if (j9ROMMethodPointer.modifiers().anyBitsIn(J9JavaAccessFlags.J9AccMethodHasExceptionInfo) && !(j9ExceptionInfoPointer = ROMHelp.J9_EXCEPTION_DATA_FROM_ROM_METHOD(j9ROMMethodPointer)).catchCount().eq(0L)) {
                J9ExceptionHandlerPointer j9ExceptionHandlerPointer = ROMHelp.J9EXCEPTIONINFO_HANDLERS(j9ExceptionInfoPointer);
                uDATA = new UDATA(0L);
                while (uDATA.lt(j9ExceptionInfoPointer.catchCount())) {
                    n2 = j9ExceptionHandlerPointer.startPC().intValue();
                    if (n2 != (n = j9ExceptionHandlerPointer.handlerPC().intValue())) {
                        int n11 = n2;
                        byArray[n11] = (byte)(byArray[n11] | 2);
                    }
                    if ((byArray[n] & 1) == 0) {
                        int n12 = n;
                        byArray[n12] = (byte)(byArray[n12] | 1);
                        ++n3;
                    }
                    j9ExceptionHandlerPointer = j9ExceptionHandlerPointer.add(1L);
                    uDATA = uDATA.add(1L);
                }
            }
            return n3;
        }
    }

    private static interface DebugLocalMapImpl {
        public int j9localmap_DebugLocalBitsForPC(J9ROMMethodPointer var1, UDATA var2, int[] var3) throws CorruptDataException;
    }

    private static class DebugLocalMapData {
        byte[] bytecodeMap;
        int[] mapArray;
        public final Stack<Integer> rootStack = new Stack();
        public int[] resultsArray;
        public J9ROMMethodPointer romMethod;
        public int targetPC;
        public int currentLocals;

        private DebugLocalMapData() {
        }
    }
}

