/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.j9.walkers;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.events.EventManager;
import com.ibm.j9ddr.vm29.pointer.generated.J9MemorySegmentListPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9MemorySegmentPointer;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class MemorySegmentIterator
implements Iterator {
    public static final int MEMORY_TYPE_RAM_CLASS = 65536;
    public static final int MEMORY_ALL_TYPES = -1;
    protected J9MemorySegmentPointer segment;
    private J9MemorySegmentPointer segmentPtr;
    protected final int flags;
    protected final boolean useClassloaderSegments;
    private boolean hasNextSegment = false;
    private boolean EOS = false;
    private CorruptDataException cde = null;

    public MemorySegmentIterator(J9MemorySegmentPointer j9MemorySegmentPointer, int n, boolean bl) {
        this.segmentPtr = j9MemorySegmentPointer;
        this.flags = n;
        this.useClassloaderSegments = bl;
        this.EOS = this.segmentPtr.isNull();
    }

    public MemorySegmentIterator(J9MemorySegmentListPointer j9MemorySegmentListPointer, int n, boolean bl) {
        this.flags = n;
        this.useClassloaderSegments = bl;
        try {
            this.segmentPtr = j9MemorySegmentListPointer.nextSegment();
            this.EOS = this.segmentPtr.isNull();
        }
        catch (CorruptDataException corruptDataException) {
            this.EOS = true;
            EventManager.raiseCorruptDataEvent("Could not locate the first segment", corruptDataException, true);
        }
    }

    @Override
    public boolean hasNext() {
        if (this.hasNextSegment) {
            return true;
        }
        if (this.EOS) {
            if (this.cde != null) {
                EventManager.raiseCorruptDataEvent("Could not locate the next segment", this.cde, true);
            }
            return false;
        }
        try {
            while (!this.hasNextSegment && !this.EOS) {
                if (this.segmentPtr.type().anyBitsIn(this.flags)) {
                    this.hasNextSegment = true;
                    this.segment = this.segmentPtr;
                }
                this.segmentPtr = this.useClassloaderSegments ? this.segmentPtr.nextSegmentInClassLoader() : this.segmentPtr.nextSegment();
                if (!this.segmentPtr.isNull()) continue;
                this.EOS = true;
            }
            return this.hasNextSegment;
        }
        catch (CorruptDataException corruptDataException) {
            this.EOS = true;
            if (this.hasNextSegment) {
                this.cde = corruptDataException;
            } else {
                EventManager.raiseCorruptDataEvent("Could not locate the next segment", corruptDataException, true);
            }
            return this.hasNextSegment;
        }
    }

    public Object next() {
        if (this.hasNext()) {
            this.hasNextSegment = false;
            return this.segment;
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("This iterator is read only");
    }
}

