/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.pointer;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.AbstractPointer;
import com.ibm.j9ddr.vm29.pointer.Pointer;
import com.ibm.j9ddr.vm29.types.I8;
import com.ibm.j9ddr.vm29.types.Scalar;
import com.ibm.j9ddr.vm29.types.UDATA;

public class I8Pointer
extends Pointer {
    public static final int SIZEOF = 1;
    public static final I8Pointer NULL = new I8Pointer(0L);

    protected I8Pointer(long l) {
        super(l);
    }

    public static I8Pointer cast(AbstractPointer abstractPointer) {
        return I8Pointer.cast(abstractPointer.getAddress());
    }

    public static I8Pointer cast(UDATA uDATA) {
        return I8Pointer.cast(uDATA.longValue());
    }

    public static I8Pointer cast(long l) {
        if (l == 0L) {
            return NULL;
        }
        return new I8Pointer(l);
    }

    @Override
    public I8 at(long l) throws CorruptDataException {
        return new I8(this.getByteAtOffset(l * 1L));
    }

    @Override
    public I8 at(Scalar scalar) throws CorruptDataException {
        return this.at(scalar.longValue());
    }

    @Override
    public I8Pointer untag() {
        return this.untag(0L);
    }

    @Override
    public I8Pointer untag(long l) {
        return new I8Pointer(this.address & (l ^ 0xFFFFFFFFFFFFFFFFL));
    }

    @Override
    public I8Pointer add(long l) {
        return new I8Pointer(this.address + 1L * l);
    }

    @Override
    public I8Pointer add(Scalar scalar) {
        return this.add(scalar.longValue());
    }

    @Override
    public I8Pointer addOffset(long l) {
        return new I8Pointer(this.address + l);
    }

    @Override
    public I8Pointer addOffset(Scalar scalar) {
        return this.addOffset(scalar.longValue());
    }

    @Override
    public I8Pointer sub(long l) {
        return new I8Pointer(this.address - 1L * l);
    }

    @Override
    public I8Pointer sub(Scalar scalar) {
        return this.sub(scalar.longValue());
    }

    @Override
    public I8Pointer subOffset(long l) {
        return new I8Pointer(this.address - l);
    }

    @Override
    public I8Pointer subOffset(Scalar scalar) {
        return this.subOffset(scalar.longValue());
    }

    @Override
    protected long sizeOfBaseType() {
        return 1L;
    }
}

