/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.pointer;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.AbstractPointer;
import com.ibm.j9ddr.vm29.pointer.Pointer;
import com.ibm.j9ddr.vm29.types.IDATA;
import com.ibm.j9ddr.vm29.types.Scalar;
import com.ibm.j9ddr.vm29.types.UDATA;

public class IDATAPointer
extends Pointer {
    public static final int SIZEOF = IDATA.SIZEOF;
    public static final IDATAPointer NULL = new IDATAPointer(0L);

    protected IDATAPointer(long l) {
        super(l);
    }

    public static IDATAPointer cast(AbstractPointer abstractPointer) {
        return IDATAPointer.cast(abstractPointer.getAddress());
    }

    public static IDATAPointer cast(UDATA uDATA) {
        return IDATAPointer.cast(uDATA.longValue());
    }

    public static IDATAPointer cast(long l) {
        if (l == 0L) {
            return NULL;
        }
        return new IDATAPointer(l);
    }

    @Override
    public IDATA at(long l) throws CorruptDataException {
        return new IDATA(this.getIDATAAtOffset(l * (long)SIZEOF));
    }

    @Override
    public IDATA at(Scalar scalar) throws CorruptDataException {
        return this.at(scalar.longValue());
    }

    @Override
    public IDATAPointer untag() {
        return this.untag(SIZEOF - 1);
    }

    @Override
    public IDATAPointer untag(long l) {
        return new IDATAPointer(this.address & (l ^ 0xFFFFFFFFFFFFFFFFL));
    }

    @Override
    public IDATAPointer add(long l) {
        return new IDATAPointer(this.address + (long)SIZEOF * l);
    }

    @Override
    public IDATAPointer add(Scalar scalar) {
        return this.add(scalar.longValue());
    }

    @Override
    public IDATAPointer addOffset(long l) {
        return new IDATAPointer(this.address + l);
    }

    @Override
    public IDATAPointer addOffset(Scalar scalar) {
        return this.addOffset(scalar.longValue());
    }

    @Override
    public IDATAPointer sub(long l) {
        return new IDATAPointer(this.address - (long)SIZEOF * l);
    }

    @Override
    public IDATAPointer sub(Scalar scalar) {
        return this.sub(scalar.longValue());
    }

    public IDATA sub(IDATAPointer iDATAPointer) {
        long l = this.sizeOfBaseType();
        if (l != iDATAPointer.sizeOfBaseType()) {
            throw new UnsupportedOperationException("Cannot subtract pointers to types of different sizes; this type = " + this.getClass() + ", parameter type = " + iDATAPointer.getClass());
        }
        IDATA iDATA = new IDATA(this.address).sub(new IDATA(iDATAPointer.address));
        return new IDATA(iDATA.longValue() / l);
    }

    @Override
    public IDATAPointer subOffset(long l) {
        return new IDATAPointer(this.address - l);
    }

    @Override
    public IDATAPointer subOffset(Scalar scalar) {
        return this.subOffset(scalar.longValue());
    }

    @Override
    protected long sizeOfBaseType() {
        return SIZEOF;
    }
}

