/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.vm29.j9.DataType;
import com.ibm.j9ddr.vm29.j9.J9ObjectFieldOffset;
import com.ibm.j9ddr.vm29.j9.gc.GCBase;
import com.ibm.j9ddr.vm29.pointer.ObjectReferencePointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm29.pointer.generated.MM_ContinuationObjectListPointer;
import com.ibm.j9ddr.vm29.pointer.generated.MM_GCExtensionsPointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9ObjectHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9RASHelper;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.JavaVersionHelper;
import com.ibm.j9ddr.vm29.types.UDATA;
import java.io.PrintStream;

public class VirtualThreadsCommand
extends Command {
    private static J9ObjectFieldOffset vthreadOffset;
    private static J9ObjectFieldOffset vmRefOffset;
    private static J9ObjectFieldOffset nameOffset;

    private static J9ObjectPointer getVirtualThread(J9ObjectPointer j9ObjectPointer) throws CorruptDataException {
        if (vthreadOffset == null) {
            vthreadOffset = J9ObjectHelper.getFieldOffset(j9ObjectPointer, "vthread", "Ljava/lang/Thread;");
        }
        return J9ObjectHelper.getObjectField(j9ObjectPointer, vthreadOffset);
    }

    private static long getVmRef(J9ObjectPointer j9ObjectPointer) throws CorruptDataException {
        if (vmRefOffset == null) {
            vmRefOffset = J9ObjectHelper.getFieldOffset(j9ObjectPointer, "vmRef", "J");
        }
        return J9ObjectHelper.getLongField(j9ObjectPointer, vmRefOffset);
    }

    private static String getName(J9ObjectPointer j9ObjectPointer) throws CorruptDataException {
        String string = null;
        if (j9ObjectPointer.notNull()) {
            if (nameOffset == null) {
                nameOffset = J9ObjectHelper.getFieldOffset(j9ObjectPointer, "name", "Ljava/lang/String;");
            }
            string = J9ObjectHelper.getStringField(j9ObjectPointer, nameOffset);
        }
        return string != null ? string : "<N/A>";
    }

    public VirtualThreadsCommand() {
        this.addCommand("vthreads", "", "Lists virtual threads");
    }

    @Override
    public void run(String string, String[] stringArray, Context context, PrintStream printStream) throws DDRInteractiveCommandException {
        try {
            J9JavaVMPointer j9JavaVMPointer = J9RASHelper.getVM(DataType.getJ9RASPointer());
            if (JavaVersionHelper.ensureMinimumJavaVersion(19, j9JavaVMPointer, printStream)) {
                VirtualThreadsCommand.displayVirtualThreads(j9JavaVMPointer, printStream);
            }
        }
        catch (CorruptDataException | NoSuchFieldException exception) {
            throw new DDRInteractiveCommandException(exception);
        }
    }

    private static void displayVirtualThreads(J9JavaVMPointer j9JavaVMPointer, PrintStream printStream) throws CorruptDataException, NoSuchFieldException {
        String string = "0x%0" + UDATA.SIZEOF * 2 + "x";
        String string2 = "!continuationstack " + string + " !j9vmcontinuation " + string + " !j9object %s (Continuation) !j9object %s (VThread) - %s%n";
        MM_GCExtensionsPointer mM_GCExtensionsPointer = GCBase.getExtensions();
        UDATA uDATA = mM_GCExtensionsPointer.accessBarrier()._continuationLinkOffset();
        MM_ContinuationObjectListPointer mM_ContinuationObjectListPointer = mM_GCExtensionsPointer.continuationObjectLists();
        while (mM_ContinuationObjectListPointer.notNull()) {
            J9ObjectPointer j9ObjectPointer = mM_ContinuationObjectListPointer._head();
            while (j9ObjectPointer.notNull()) {
                long l = VirtualThreadsCommand.getVmRef(j9ObjectPointer);
                J9ObjectPointer j9ObjectPointer2 = VirtualThreadsCommand.getVirtualThread(j9ObjectPointer);
                String string3 = VirtualThreadsCommand.getName(j9ObjectPointer2);
                printStream.format(string2, l, l, j9ObjectPointer.getHexAddress(), j9ObjectPointer2.getHexAddress(), string3);
                j9ObjectPointer = ObjectReferencePointer.cast(j9ObjectPointer.addOffset(uDATA)).at(0L);
            }
            mM_ContinuationObjectListPointer = mM_ContinuationObjectListPointer._nextList();
        }
    }
}

