/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive.commands;

import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.corereaders.ICore;
import com.ibm.j9ddr.corereaders.Platform;
import com.ibm.j9ddr.corereaders.memory.IProcess;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.view.dtfj.image.J9DDRImageProcess;
import com.ibm.j9ddr.vm29.j9.DataType;
import com.ibm.j9ddr.vm29.pointer.U8Pointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9RASPointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9JavaVMHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9RASHelper;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Properties;

public class CoreInfoCommand
extends Command {
    public CoreInfoCommand() {
        this.addCommand("coreinfo", "", "Prints commandline, platform and -version info of VM found in the current core file.");
    }

    private void printUsage(PrintStream printStream) {
        printStream.println("coreinfo - Prints commandline, platform and -version info of VM found in the current core file.");
    }

    @Override
    public void run(String string, String[] stringArray, Context context, PrintStream printStream) throws DDRInteractiveCommandException {
        if (0 < stringArray.length) {
            printStream.println("!coreinfo expects no args. Usage :");
            this.printUsage(printStream);
            return;
        }
        try {
            J9RASPointer j9RASPointer = DataType.getJ9RASPointer();
            J9JavaVMPointer j9JavaVMPointer = J9RASHelper.getVM(j9RASPointer);
            IProcess iProcess = j9JavaVMPointer.getProcess();
            J9DDRImageProcess j9DDRImageProcess = new J9DDRImageProcess(iProcess);
            try {
                printStream.println("COMMANDLINE");
                printStream.println(j9DDRImageProcess.getCommandLine());
                printStream.println();
            }
            catch (DataUnavailable dataUnavailable) {
                printStream.println("COMMANDLINE is not available");
                printStream.println();
            }
            catch (com.ibm.dtfj.image.CorruptDataException corruptDataException) {
                throw new DDRInteractiveCommandException("CorruptDataException occured while getting the command line from process");
            }
            Properties properties = J9JavaVMHelper.getSystemProperties(j9JavaVMPointer);
            String string2 = "- not available";
            printStream.println("JAVA VM NAME\t- " + properties.getProperty("java.vm.name", string2));
            printStream.println("JAVA VM VERSION\t- " + properties.getProperty("java.vm.version", string2));
            printStream.println("JAVA SERVICE LEVEL INFO");
            try {
                printStream.println(j9RASPointer.serviceLevel().getCStringAtOffset(0L));
            }
            catch (CorruptDataException corruptDataException) {
                printStream.println(string2);
            }
            try {
                U8Pointer u8Pointer = j9RASPointer.productName();
                if (u8Pointer.notNull()) {
                    printStream.println("JAVA PRODUCT INFO");
                    try {
                        printStream.println(u8Pointer.getCStringAtOffset(0L));
                    }
                    catch (CorruptDataException corruptDataException) {
                        printStream.println(string2);
                    }
                }
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
            printStream.println("JAVA VERSION INFO");
            printStream.println(properties.getProperty("java.fullversion", string2));
            printStream.println();
            boolean bl = iProcess.bytesPerPointer() == 8;
            ICore iCore = iProcess.getAddressSpace().getCore();
            Platform platform = iCore.getPlatform();
            printStream.println("PLATFORM INFO");
            printStream.print("Platform Name :\t");
            printStream.print(platform.name());
            printStream.println(bl ? " 64Bit" : " 32Bit");
            printStream.print("OS Level\t: ");
            try {
                printStream.println(j9RASPointer.osnameEA().getCStringAtOffset(0L) + " " + j9RASPointer.osversionEA().getCStringAtOffset(0L));
            }
            catch (CorruptDataException corruptDataException) {
                printStream.println(string2);
            }
            printStream.println("Processors -");
            printStream.print("  Architecture\t: ");
            try {
                printStream.println(j9RASPointer.osarchEA().getCStringAtOffset(0L));
            }
            catch (CorruptDataException corruptDataException) {
                printStream.println(string2);
            }
            printStream.println("  How Many\t: " + j9RASPointer.cpus().longValue());
            printStream.println();
            printStream.println("VM PROPERTIES (these are not Java system properties)");
            ArrayList<String> arrayList = new ArrayList<String>(properties.stringPropertyNames());
            Collections.sort(arrayList);
            for (String object : arrayList) {
                printStream.println("  " + object + " = " + properties.get(object));
            }
            try {
                Properties properties2 = j9DDRImageProcess.getEnvironment();
                ArrayList<String> arrayList2 = new ArrayList<String>(properties2.stringPropertyNames());
                Collections.sort(arrayList2);
                printStream.println();
                printStream.println("ENVIRONMENT VARIABLES");
                for (String string3 : arrayList2) {
                    printStream.println("  " + string3 + "=" + properties2.get(string3));
                }
            }
            catch (com.ibm.dtfj.image.CorruptDataException corruptDataException) {
                throw new DDRInteractiveCommandException("CorruptDataException occured while getting the environment variables from process");
            }
            catch (DataUnavailable dataUnavailable) {
                printStream.println("Environment variables are not available");
                printStream.println();
            }
        }
        catch (CorruptDataException corruptDataException) {
            corruptDataException.printStackTrace();
        }
    }
}

