/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.vm29.j9.DataType;
import com.ibm.j9ddr.vm29.j9.walkers.ROMClassesIterator;
import com.ibm.j9ddr.vm29.pointer.AbstractPointer;
import com.ibm.j9ddr.vm29.pointer.I32Pointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9SharedCacheHeaderPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9SharedClassConfigPointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9RASHelper;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.ClassSummaryHelper;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.LinearDumper;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.RomClassWalker;
import com.ibm.j9ddr.vm29.types.UDATA;
import java.io.PrintStream;

public class RomClassSummaryCommand
extends Command {
    private final String[] preferredOrder = new String[]{"romHeader", "constantPool", "fields", "interfacesSRPs", "innerClassesSRPs", "enclosedInnerClassesSRPs", "cpNamesAndSignaturesSRPs", "methods", "cpShapeDescription", "classAnnotations", "enclosingObject", "optionalInfo", "UTF8"};

    public RomClassSummaryCommand() {
        this.addCommand("romclasssummary", "[local|shared] [nas]", "Display romclass summary");
    }

    @Override
    public void run(String string, String[] stringArray, Context context, PrintStream printStream) throws DDRInteractiveCommandException {
        try {
            Object object;
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            J9SharedClassConfigPointer j9SharedClassConfigPointer = J9SharedClassConfigPointer.NULL;
            J9JavaVMPointer j9JavaVMPointer = J9RASHelper.getVM(DataType.getJ9RASPointer());
            long l = 0L;
            long l2 = 0L;
            if (stringArray != null && stringArray.length >= 1) {
                if (stringArray[0].equals("shared")) {
                    bl2 = true;
                } else if (stringArray[0].equals("local")) {
                    bl = true;
                } else if (stringArray[0].equals("16bitnas")) {
                    bl3 = true;
                } else {
                    printStream.println("USAGE: !romclasssummary [local|shared] [16bitnas]");
                    return;
                }
                if (stringArray.length >= 2 && stringArray[1].equals("16bitnas")) {
                    bl3 = true;
                }
                if (bl2 || bl) {
                    j9SharedClassConfigPointer = j9JavaVMPointer.sharedClassConfig();
                    if (bl2 && j9SharedClassConfigPointer.isNull()) {
                        printStream.println("The request for '" + stringArray[0] + " classes' failed, because shared classes were not enabled on that dump file.");
                        return;
                    }
                    if (j9SharedClassConfigPointer.notNull()) {
                        l = UDATA.cast(j9SharedClassConfigPointer.cacheDescriptorList().romclassStartAddress()).longValue();
                        object = j9SharedClassConfigPointer.cacheDescriptorList().cacheStartAddress();
                        l2 = UDATA.cast((AbstractPointer)object).add(((J9SharedCacheHeaderPointer)object).segmentSRP()).longValue();
                    }
                }
            }
            object = new ClassSummaryHelper(this.preferredOrder);
            Statistics statistics = new Statistics();
            ROMClassesIterator rOMClassesIterator = new ROMClassesIterator(printStream, j9JavaVMPointer.classMemorySegments());
            while (rOMClassesIterator.hasNext()) {
                J9ROMClassPointer j9ROMClassPointer = rOMClassesIterator.next();
                if (bl2 || bl) {
                    long l3;
                    boolean bl4 = j9SharedClassConfigPointer.notNull() ? (l3 = j9ROMClassPointer.getAddress()) >= l && l3 < l2 : false;
                    if (bl2 && !bl4 || bl && bl4) continue;
                }
                RomClassWalker romClassWalker = new RomClassWalker(j9ROMClassPointer, context);
                LinearDumper linearDumper = new LinearDumper();
                LinearDumper.J9ClassRegionNode j9ClassRegionNode = linearDumper.getAllRegions(romClassWalker);
                ((ClassSummaryHelper)object).addRegionsForClass(j9ClassRegionNode);
                if (!bl3) continue;
                statistics.add(j9ClassRegionNode);
            }
            ((ClassSummaryHelper)object).printStatistics(printStream);
            if (statistics.nameAndSignatureSRP16bitSize != -1L) {
                printStream.println();
                printStream.println("<Total 16bit nameAndSignatureSRPs Size>");
                printStream.println(statistics.nameAndSignatureSRP16bitSize);
            }
            if (statistics.nameAndSignatureSRPCount != -1L && statistics.cpFieldNASCount != -1L) {
                printStream.println();
                printStream.println("<Shared nameAndSignatureSRPs>");
                printStream.println(statistics.cpFieldNASCount - statistics.nameAndSignatureSRPCount / 2L);
            }
        }
        catch (CorruptDataException corruptDataException) {
            throw new DDRInteractiveCommandException(corruptDataException);
        }
    }

    private class Statistics {
        public long nameAndSignatureSRP16bitSize = -1L;
        public long nameAndSignatureSRPCount = -1L;
        public long cpFieldNASCount = -1L;

        private Statistics() {
        }

        void add(LinearDumper.J9ClassRegionNode j9ClassRegionNode) throws CorruptDataException {
            this.addRecursive(j9ClassRegionNode, null);
        }

        void addRecursive(LinearDumper.J9ClassRegionNode j9ClassRegionNode, String string) throws CorruptDataException {
            LinearDumper.J9ClassRegion j9ClassRegion = j9ClassRegionNode.getNodeValue();
            String string2 = null;
            if (j9ClassRegion != null) {
                long l;
                string2 = j9ClassRegion.getName();
                if (string != null && string.equals("cpNamesAndSignaturesSRPs") && (long)((short)(l = I32Pointer.cast(j9ClassRegion.getSlotPtr()).at(0L).longValue())) == l) {
                    ++this.nameAndSignatureSRPCount;
                    this.nameAndSignatureSRP16bitSize += j9ClassRegion.getLength();
                }
                if (string2.equals("cpFieldNAS")) {
                    ++this.cpFieldNASCount;
                }
            }
            for (LinearDumper.J9ClassRegionNode j9ClassRegionNode2 : j9ClassRegionNode.getChildren()) {
                if (string2 != null && string != null && !string2.trim().equals("constantPool") && !string.trim().equals("constantPool") && !string2.trim().equals("cpNamesAndSignaturesSRPs")) continue;
                this.addRecursive(j9ClassRegionNode2, string2);
            }
        }
    }
}

