/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.view.dtfj;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.DataUnavailableException;
import com.ibm.j9ddr.IBootstrapRunnable;
import com.ibm.j9ddr.IVMData;
import com.ibm.j9ddr.InvalidDataTypeException;
import com.ibm.j9ddr.corereaders.memory.IProcess;
import com.ibm.j9ddr.view.dtfj.J9DDRDTFJUtils;
import com.ibm.j9ddr.view.dtfj.image.J9RASImageDataFactory;
import com.ibm.j9ddr.vm29.j9.DataType;
import com.ibm.j9ddr.vm29.pointer.U8Pointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9RASPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9RASSystemInfoPointer;
import com.ibm.j9ddr.vm29.structure.RasdumpInternalConstants;
import com.ibm.j9ddr.vm29.view.dtfj.DTFJContext;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;

public class J9RASInfoBootstrapShim
implements IBootstrapRunnable {
    @Override
    public void run(IVMData iVMData, Object[] objectArray) {
        Object[] objectArray2 = (Object[])objectArray[0];
        objectArray2[0] = new J9RASInfoObject();
    }

    private static final class J9RASInfoObject
    implements J9RASImageDataFactory.MachineData,
    J9RASImageDataFactory.ProcessData {
        private final J9RASPointer ptr = DataType.getJ9RASPointer();

        J9RASInfoObject() {
        }

        @Override
        public int version() throws CorruptDataException {
            return this.ptr.version().intValue() >> 16;
        }

        @Override
        public int cpus() throws CorruptDataException {
            try {
                return this.ptr.cpus().intValue();
            }
            catch (InvalidDataTypeException invalidDataTypeException) {
                throw new CorruptDataException("This value cannot be expressed : " + this.ptr.cpus().getHexValue(), invalidDataTypeException);
            }
        }

        @Override
        public long memoryBytes() throws CorruptDataException {
            try {
                return this.ptr.memory().longValue();
            }
            catch (InvalidDataTypeException invalidDataTypeException) {
                throw new CorruptDataException("This value cannot be expressed : " + this.ptr.memory().getHexValue(), invalidDataTypeException);
            }
        }

        @Override
        public String osArch() throws CorruptDataException {
            return this.ptr.osarchEA().getCStringAtOffset(0L);
        }

        @Override
        public String osName() throws CorruptDataException {
            return this.ptr.osnameEA().getCStringAtOffset(0L);
        }

        @Override
        public String osVersion() throws CorruptDataException {
            return this.ptr.osversionEA().getCStringAtOffset(0L);
        }

        @Override
        public long pid() throws CorruptDataException {
            try {
                return this.ptr.pid().longValue();
            }
            catch (InvalidDataTypeException invalidDataTypeException) {
                throw new CorruptDataException("This value cannot be expressed : " + this.ptr.pid().getHexValue(), invalidDataTypeException);
            }
        }

        @Override
        public long tid() throws CorruptDataException {
            try {
                return this.ptr.tid().longValue();
            }
            catch (InvalidDataTypeException invalidDataTypeException) {
                throw new CorruptDataException("This value cannot be expressed : " + this.ptr.tid().getHexValue(), invalidDataTypeException);
            }
        }

        @Override
        public String gpInfo() throws CorruptDataException {
            if (this.ptr.crashInfo().isNull()) {
                return "";
            }
            if (this.ptr.crashInfo().gpInfo().isNull()) {
                return null;
            }
            return this.ptr.crashInfo().gpInfo().getCStringAtOffset(0L);
        }

        @Override
        public String hostName() throws DataUnavailableException, CorruptDataException {
            if (this.ptr.hostnameEA().notNull()) {
                return this.ptr.hostnameEA().getCStringAtOffset(0L);
            }
            throw new DataUnavailableException("Host name not available");
        }

        @Override
        public Iterator<Object> ipaddresses() throws DataUnavailableException, CorruptDataException {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            U8Pointer u8Pointer = this.ptr.ipAddressesEA();
            if (u8Pointer.isNull()) {
                throw new DataUnavailableException("IP addresses not available");
            }
            byte[] byArray = new byte[4];
            byte[] byArray2 = new byte[16];
            block7: while (true) {
                int n = u8Pointer.at(0L).intValue();
                u8Pointer = u8Pointer.add(1L);
                try {
                    InetAddress inetAddress;
                    switch (n) {
                        case 0: {
                            break block7;
                        }
                        case 4: {
                            DataType.getProcess().getBytesAt(u8Pointer.getAddress(), byArray);
                            u8Pointer = u8Pointer.add(byArray.length);
                            inetAddress = InetAddress.getByAddress(byArray);
                            break;
                        }
                        case 6: {
                            DataType.getProcess().getBytesAt(u8Pointer.getAddress(), byArray2);
                            u8Pointer = u8Pointer.add(byArray2.length);
                            inetAddress = InetAddress.getByAddress(byArray2);
                            break;
                        }
                        default: {
                            arrayList.add(J9DDRDTFJUtils.newCorruptData(DTFJContext.getProcess(), "Unknown IP address type identifier : " + n));
                            break block7;
                        }
                    }
                    if (arrayList.contains(inetAddress)) continue;
                    arrayList.add(inetAddress);
                }
                catch (UnknownHostException unknownHostException) {
                    arrayList.add(J9DDRDTFJUtils.newCorruptData(DTFJContext.getProcess(), "Corrupt IP address : " + unknownHostException.getMessage()));
                }
            }
            if (arrayList.isEmpty()) {
                throw new DataUnavailableException("IP addresses not available");
            }
            return arrayList.iterator();
        }

        @Override
        public IProcess getProcess() {
            return DataType.getProcess();
        }

        @Override
        public long getEnvironment() throws CorruptDataException {
            return this.ptr.environment().longValue();
        }

        @Override
        public Properties systemInfo() throws DataUnavailableException, CorruptDataException {
            Properties properties = new Properties();
            J9RASSystemInfoPointer j9RASSystemInfoPointer = this.ptr.systemInfo();
            if (j9RASSystemInfoPointer.notNull()) {
                J9RASSystemInfoPointer j9RASSystemInfoPointer2 = j9RASSystemInfoPointer;
                do {
                    int n;
                    if ((n = j9RASSystemInfoPointer.key().intValue()) == (int)RasdumpInternalConstants.J9RAS_SYSTEMINFO_SCHED_COMPAT_YIELD) {
                        byte[] byArray = new byte[1];
                        j9RASSystemInfoPointer.dataEA().getBytesAtOffset(0L, byArray);
                        properties.put("/proc/sys/kernel/sched_compat_yield", new String(byArray, StandardCharsets.UTF_8));
                        continue;
                    }
                    if (n == (int)RasdumpInternalConstants.J9RAS_SYSTEMINFO_HYPERVISOR) {
                        properties.put("Hypervisor", U8Pointer.cast(j9RASSystemInfoPointer.data()).getCStringAtOffset(0L));
                        continue;
                    }
                    if (n == (int)RasdumpInternalConstants.J9RAS_SYSTEMINFO_CORE_PATTERN) {
                        properties.put("/proc/sys/kernel/core_pattern", U8Pointer.cast(j9RASSystemInfoPointer.data()).getCStringAtOffset(0L));
                        continue;
                    }
                    if (n != (int)RasdumpInternalConstants.J9RAS_SYSTEMINFO_CORE_USES_PID) continue;
                    properties.put("/proc/sys/kernel/core_uses_pid", U8Pointer.cast(j9RASSystemInfoPointer.data()).getCStringAtOffset(0L));
                } while (!(j9RASSystemInfoPointer = j9RASSystemInfoPointer.linkNext()).equals(j9RASSystemInfoPointer2));
            }
            return properties;
        }

        @Override
        public long dumpTimeMillis() throws DataUnavailableException, CorruptDataException {
            long l = this.ptr.dumpTimeMillis().longValue();
            if (l == 0L) {
                throw new DataUnavailableException("Dump creation time (millisecs) not set");
            }
            return l;
        }

        @Override
        public long dumpTimeNanos() throws DataUnavailableException, CorruptDataException {
            long l = this.ptr.dumpTimeNanos().longValue();
            if (l == 0L) {
                throw new DataUnavailableException("Dump creation time (nanosecs) not set");
            }
            return l;
        }
    }
}

