/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.view.dtfj.java;

import com.ibm.dtfj.image.CorruptData;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.java.JavaClass;
import com.ibm.dtfj.java.JavaClassLoader;
import com.ibm.dtfj.java.JavaObject;
import com.ibm.dtfj.java.JavaReference;
import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.events.IEventListener;
import com.ibm.j9ddr.view.dtfj.J9DDRDTFJUtils;
import com.ibm.j9ddr.view.dtfj.image.J9DDRCorruptData;
import com.ibm.j9ddr.view.dtfj.image.J9DDRImagePointer;
import com.ibm.j9ddr.view.dtfj.java.helper.DTFJJavaClassHelper;
import com.ibm.j9ddr.vm29.events.EventManager;
import com.ibm.j9ddr.vm29.j9.J9ObjectFieldOffset;
import com.ibm.j9ddr.vm29.j9.J9ObjectFieldOffsetIterator;
import com.ibm.j9ddr.vm29.j9.OptInfo;
import com.ibm.j9ddr.vm29.pointer.SelfRelativePointer;
import com.ibm.j9ddr.vm29.pointer.VoidPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ArrayClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9MethodPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9UTF8Pointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9ClassHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9ObjectHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9UTF8Helper;
import com.ibm.j9ddr.vm29.structure.J9JavaAccessFlags;
import com.ibm.j9ddr.vm29.structure.J9ROMFieldOffsetWalkState;
import com.ibm.j9ddr.vm29.types.U32;
import com.ibm.j9ddr.vm29.view.dtfj.DTFJContext;
import com.ibm.j9ddr.vm29.view.dtfj.java.DTFJJavaClassloader;
import com.ibm.j9ddr.vm29.view.dtfj.java.DTFJJavaField;
import com.ibm.j9ddr.vm29.view.dtfj.java.DTFJJavaFieldInstance;
import com.ibm.j9ddr.vm29.view.dtfj.java.DTFJJavaFieldStatic;
import com.ibm.j9ddr.vm29.view.dtfj.java.DTFJJavaMethod;
import com.ibm.j9ddr.vm29.view.dtfj.java.DTFJJavaObject;
import com.ibm.j9ddr.vm29.view.dtfj.java.DTFJJavaReference;
import com.ibm.j9ddr.vm29.view.dtfj.java.j9.DTFJConstantPoolIterator;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class DTFJJavaClass
implements JavaClass {
    private final J9ClassPointer j9class;
    private DTFJJavaClassloader javaClassLoader;
    private static final Logger log = DTFJContext.getLogger();
    private J9ClassPointer superclass = null;
    private Boolean isObjectArray = null;
    private Boolean isInterface = null;
    private Boolean isArray = null;
    private SoftReference<DTFJJavaObject> classObject = null;
    private static final int MAX_CLASS_FIELDS = 65535;
    private static final int MAX_CLASS_METHODS = 65535;
    private DTFJJavaClass componentType;
    static final Map<J9ClassPointer, List<Object>> declaredFieldsCache = new HashMap<J9ClassPointer, List<Object>>();
    private J9DDRImagePointer id;
    static final Map<J9ClassPointer, Integer> modifiersCache = new HashMap<J9ClassPointer, Integer>();
    private List<Object> references = null;
    private static final Map<J9ClassPointer, SuperClassCacheEntry> superClassCache = new HashMap<J9ClassPointer, SuperClassCacheEntry>();

    public DTFJJavaClass(J9ClassPointer j9ClassPointer) {
        this.j9class = j9ClassPointer;
    }

    J9ClassPointer getJ9Class() {
        return this.j9class;
    }

    public JavaClassLoader getClassLoader() throws com.ibm.dtfj.image.CorruptDataException {
        if (this.javaClassLoader == null) {
            try {
                this.javaClassLoader = new DTFJJavaClassloader(this.j9class.classLoader());
            }
            catch (Throwable throwable) {
                throw J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), throwable);
            }
        }
        return this.javaClassLoader;
    }

    public JavaClass getComponentType() throws com.ibm.dtfj.image.CorruptDataException {
        if (!this.isArray()) {
            throw new IllegalArgumentException("Class is not an array");
        }
        J9ArrayClassPointer j9ArrayClassPointer = J9ArrayClassPointer.cast(this.j9class);
        try {
            if (j9ArrayClassPointer.arity().eq(1L)) {
                if (this.componentType == null) {
                    try {
                        this.componentType = new DTFJJavaClass(J9ArrayClassPointer.cast(this.j9class).leafComponentType());
                    }
                    catch (CorruptDataException corruptDataException) {
                        J9DDRDTFJUtils.newCorruptDataException(DTFJContext.getProcess(), corruptDataException);
                    }
                }
                return this.componentType;
            }
            return new DTFJJavaClass(J9ArrayClassPointer.cast(this.j9class).componentType());
        }
        catch (Throwable throwable) {
            throw J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), throwable);
        }
    }

    public Iterator getConstantPoolReferences() {
        try {
            if (this.isArray()) {
                return J9DDRDTFJUtils.emptyIterator();
            }
            return new DTFJConstantPoolIterator(this.j9class);
        }
        catch (Throwable throwable) {
            CorruptData corruptData = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), throwable);
            return J9DDRDTFJUtils.corruptIterator(corruptData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getDeclaredFields() {
        List<Object> list = declaredFieldsCache.get(this.j9class);
        if (list == null) {
            final List<Object> list2 = list = new LinkedList<Object>();
            IEventListener iEventListener = new IEventListener(){

                @Override
                public void corruptData(String string, CorruptDataException corruptDataException, boolean bl) {
                    J9DDRCorruptData j9DDRCorruptData = J9DDRDTFJUtils.newCorruptData(DTFJContext.getProcess(), corruptDataException);
                    list2.add(j9DDRCorruptData);
                }
            };
            try {
                EventManager.register(iEventListener);
                J9ClassPointer j9ClassPointer = J9ClassPointer.NULL;
                try {
                    j9ClassPointer = this.getSuperClassPointer();
                }
                catch (CorruptDataException corruptDataException) {
                    list2.add(J9DDRDTFJUtils.newCorruptData(DTFJContext.getProcess(), "Unable to determine superclass"));
                }
                U32 u32 = new U32(J9ROMFieldOffsetWalkState.J9VM_FIELD_OFFSET_WALK_INCLUDE_STATIC | J9ROMFieldOffsetWalkState.J9VM_FIELD_OFFSET_WALK_INCLUDE_INSTANCE);
                long l = this.j9class.romClass().romFieldCount().longValue();
                Iterator<J9ObjectFieldOffset> iterator = null;
                if (l > 65535L) {
                    list2.add(J9DDRDTFJUtils.newCorruptData(DTFJContext.getProcess(), "Corrupt field count"));
                } else {
                    iterator = J9ObjectFieldOffsetIterator.J9ObjectFieldOffsetIteratorFor(this.j9class, j9ClassPointer, u32);
                }
                while (iterator != null && iterator.hasNext()) {
                    try {
                        J9ObjectFieldOffset j9ObjectFieldOffset = iterator.next();
                        log.fine(String.format("Declared field : %s", j9ObjectFieldOffset.getName()));
                        if (j9ObjectFieldOffset.isStatic()) {
                            list2.add(new DTFJJavaFieldStatic(this, j9ObjectFieldOffset));
                        } else {
                            list2.add(new DTFJJavaFieldInstance(this, j9ObjectFieldOffset));
                        }
                    }
                    catch (CorruptDataException corruptDataException) {
                        list2.add(J9DDRDTFJUtils.newCorruptData(DTFJContext.getProcess(), corruptDataException));
                    }
                    if ((long)list2.size() <= l) continue;
                    list2.add(J9DDRDTFJUtils.newCorruptData(DTFJContext.getProcess(), "Corrupt class returned more fields than it declared"));
                    break;
                }
                if (list2.size() < 1024) {
                    declaredFieldsCache.put(this.j9class, list2);
                }
            }
            catch (Throwable throwable) {
                list2.add(J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), throwable));
            }
            finally {
                EventManager.unregister(iEventListener);
            }
        }
        return list.iterator();
    }

    public Iterator getDeclaredMethods() {
        ArrayList<DTFJJavaMethod> arrayList;
        long l;
        J9MethodPointer j9MethodPointer;
        try {
            j9MethodPointer = this.j9class.ramMethods();
            l = this.j9class.romClass().romMethodCount().longValue();
            if (l > 65535L) {
                J9DDRCorruptData j9DDRCorruptData = J9DDRDTFJUtils.newCorruptData(DTFJContext.getProcess(), "Corrupt class, maximum number of methods exceeded");
                return J9DDRDTFJUtils.corruptIterator(j9DDRCorruptData);
            }
            arrayList = new ArrayList<DTFJJavaMethod>((int)l);
        }
        catch (Throwable throwable) {
            CorruptData corruptData = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), throwable);
            return J9DDRDTFJUtils.corruptIterator(corruptData);
        }
        int n = 0;
        while ((long)n < l) {
            try {
                DTFJJavaMethod dTFJJavaMethod = new DTFJJavaMethod(this, j9MethodPointer.add(n));
                arrayList.add(dTFJJavaMethod);
            }
            catch (Throwable throwable) {
                CorruptData corruptData = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), throwable);
                arrayList.add((DTFJJavaMethod)corruptData);
            }
            ++n;
        }
        return arrayList.iterator();
    }

    public ImagePointer getID() {
        if (this.id == null) {
            this.id = DTFJContext.getImagePointer(this.j9class.getAddress());
        }
        return this.id;
    }

    public Iterator getInterfaces() {
        SelfRelativePointer selfRelativePointer;
        ArrayList<String> arrayList;
        int n;
        try {
            n = this.j9class.romClass().interfaceCount().intValue();
            if (n > 65535) {
                String string = String.format("Invalid number of interfaces for class@0x%s", Long.toHexString(this.j9class.getAddress()));
                throw new CorruptDataException(string);
            }
            arrayList = new ArrayList<String>(n);
            selfRelativePointer = this.j9class.romClass().interfaces();
        }
        catch (Throwable throwable) {
            CorruptData corruptData = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), throwable);
            return J9DDRDTFJUtils.corruptIterator(corruptData);
        }
        try {
            for (int i = 0; i < n; ++i) {
                VoidPointer voidPointer = selfRelativePointer.add(i).get();
                try {
                    arrayList.add(J9UTF8Helper.stringValue(J9UTF8Pointer.cast(voidPointer)));
                    continue;
                }
                catch (Throwable throwable) {
                    CorruptData corruptData = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), throwable);
                    arrayList.add((String)corruptData);
                }
            }
        }
        catch (Throwable throwable) {
            CorruptData corruptData = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), throwable);
            arrayList.add((String)corruptData);
        }
        return arrayList.iterator();
    }

    public int getModifiers() throws com.ibm.dtfj.image.CorruptDataException {
        Integer n = modifiersCache.get(this.j9class);
        if (n == null) {
            try {
                n = J9ClassHelper.getJavaLangClassModifiers(this.j9class);
                modifiersCache.put(this.j9class, n);
            }
            catch (Throwable throwable) {
                throw J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), throwable);
            }
        }
        return n;
    }

    public String getName() throws com.ibm.dtfj.image.CorruptDataException {
        try {
            if (this.isArray()) {
                return J9ClassHelper.getArrayName(this.j9class);
            }
            return J9ClassHelper.getName(this.j9class);
        }
        catch (Throwable throwable) {
            throw J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), throwable);
        }
    }

    boolean isObjectArray() throws com.ibm.dtfj.image.CorruptDataException, CorruptDataException {
        try {
            if (this.isObjectArray == null) {
                J9ArrayClassPointer j9ArrayClassPointer;
                this.isObjectArray = this.isArray() ? ((j9ArrayClassPointer = J9ArrayClassPointer.cast(this.j9class)).arity().gt(1) || J9ClassHelper.isClassSignature(this.getName().charAt(1)) ? Boolean.valueOf(true) : Boolean.valueOf(false)) : Boolean.valueOf(false);
            }
            return this.isObjectArray;
        }
        catch (Throwable throwable) {
            throw J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), throwable);
        }
    }

    public JavaObject getObject() throws com.ibm.dtfj.image.CorruptDataException {
        DTFJJavaObject dTFJJavaObject = null;
        if (this.classObject != null) {
            dTFJJavaObject = this.classObject.get();
        }
        if (dTFJJavaObject == null) {
            try {
                dTFJJavaObject = new DTFJJavaObject(this.j9class.classObject());
                this.classObject = new SoftReference<DTFJJavaObject>(dTFJJavaObject);
            }
            catch (Throwable throwable) {
                throw J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), throwable);
            }
        }
        return dTFJJavaObject;
    }

    public Iterator getReferences() {
        if (this.references == null) {
            try {
                this.references = new ArrayList<Object>();
                this.addConstantPoolReferences(this.references);
                this.addStaticFieldReferences(this.references);
                this.addSuperclassReference(this.references);
                this.addClassLoaderReference(this.references);
                this.addClassObjectReference(this.references);
            }
            catch (Throwable throwable) {
                CorruptData corruptData = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), throwable);
                this.references.add(corruptData);
            }
        }
        return this.references.iterator();
    }

    private void addStaticFieldReferences(List<Object> list) {
        Iterator iterator = this.getDeclaredFields();
        Object var4_3 = null;
        while (iterator.hasNext()) {
            Object object;
            Object e = iterator.next();
            var4_3 = e;
            if (!(e instanceof DTFJJavaField)) break;
            DTFJJavaField dTFJJavaField = var4_3;
            if (!(dTFJJavaField instanceof DTFJJavaFieldStatic)) continue;
            try {
                JavaObject javaObject;
                char c = dTFJJavaField.getSignature().charAt(0);
                if (c != 'L' && c != '[' || (javaObject = (JavaObject)dTFJJavaField.get(null)) == null) continue;
                object = dTFJJavaField.getName();
                String string = "Static field";
                if (null != object) {
                    string = string + " [field name:" + (String)object + "]";
                }
                DTFJJavaReference dTFJJavaReference = new DTFJJavaReference(this, javaObject, string, 8, 0, 1);
                list.add(dTFJJavaReference);
            }
            catch (Throwable throwable) {
                object = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), throwable);
                list.add(object);
            }
        }
    }

    private void addSuperclassReference(List<Object> list) {
        DTFJJavaReference dTFJJavaReference = null;
        try {
            JavaClass javaClass = this.getSuperclass();
            if (null != javaClass) {
                dTFJJavaReference = new DTFJJavaReference(this, javaClass, "Superclass", 10, 0, 1);
                list.add(dTFJJavaReference);
            }
        }
        catch (Throwable throwable) {
            CorruptData corruptData = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), throwable);
            list.add(corruptData);
        }
    }

    private void addClassLoaderReference(List<Object> list) {
        DTFJJavaReference dTFJJavaReference = null;
        try {
            JavaObject javaObject;
            JavaClassLoader javaClassLoader = this.getClassLoader();
            if (null != javaClassLoader && null != (javaObject = javaClassLoader.getObject())) {
                dTFJJavaReference = new DTFJJavaReference(this, javaObject, "Classloader", 4, 0, 1);
                list.add(dTFJJavaReference);
            }
        }
        catch (Throwable throwable) {
            CorruptData corruptData = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), throwable);
            list.add(corruptData);
        }
    }

    private void addClassObjectReference(List<Object> list) {
        DTFJJavaReference dTFJJavaReference = null;
        try {
            JavaObject javaObject = this.getObject();
            if (null != javaObject) {
                dTFJJavaReference = new DTFJJavaReference(this, javaObject, "Class object", 12, 0, 1);
                list.add(dTFJJavaReference);
            }
        }
        catch (Throwable throwable) {
            CorruptData corruptData = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), throwable);
            list.add(corruptData);
        }
    }

    private JavaReference addConstantPoolReferences(List<Object> list) {
        DTFJJavaReference dTFJJavaReference = null;
        Iterator iterator = this.getConstantPoolReferences();
        try {
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (e instanceof JavaObject) {
                    dTFJJavaReference = new DTFJJavaReference(this, e, "Constant Pool Object", 9, 0, 1);
                } else if (e instanceof JavaClass) {
                    dTFJJavaReference = new DTFJJavaReference(this, e, "Constant Pool Class", 9, 0, 1);
                }
                if (null == dTFJJavaReference) continue;
                list.add(dTFJJavaReference);
            }
        }
        catch (Throwable throwable) {
            CorruptData corruptData = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), throwable);
            list.add(corruptData);
        }
        return dTFJJavaReference;
    }

    private J9ClassPointer getSuperClassPointer() throws CorruptDataException {
        if (this.superclass == null) {
            this.superclass = J9ClassHelper.superclass(this.j9class);
        }
        return this.superclass;
    }

    public JavaClass getSuperclass() throws com.ibm.dtfj.image.CorruptDataException {
        SuperClassCacheEntry superClassCacheEntry = superClassCache.get(this.j9class);
        if (null == superClassCacheEntry) {
            try {
                J9ClassPointer j9ClassPointer;
                superClassCacheEntry = this.isInterface() ? new SuperClassCacheEntry(null) : ((j9ClassPointer = this.getSuperClassPointer()) == null ? new SuperClassCacheEntry(null) : new SuperClassCacheEntry(new DTFJJavaClass(j9ClassPointer)));
                superClassCache.put(this.j9class, superClassCacheEntry);
            }
            catch (Throwable throwable) {
                throw J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), throwable);
            }
        }
        if (superClassCacheEntry.superClass != null && superClassCacheEntry.superClass instanceof DTFJJavaClass && ((DTFJJavaClass)superClassCacheEntry.superClass).getJ9Class().isNull()) {
            return null;
        }
        return superClassCacheEntry.superClass;
    }

    private boolean isInterface() throws CorruptDataException {
        if (this.isInterface == null) {
            J9ROMClassPointer j9ROMClassPointer = this.j9class.romClass();
            this.isInterface = j9ROMClassPointer.modifiers().allBitsIn(J9JavaAccessFlags.J9AccInterface) ? Boolean.valueOf(true) : Boolean.valueOf(false);
        }
        return this.isInterface;
    }

    public boolean isArray() throws com.ibm.dtfj.image.CorruptDataException {
        if (this.isArray == null) {
            try {
                this.isArray = J9ClassHelper.isArrayClass(this.j9class);
            }
            catch (Throwable throwable) {
                throw J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), throwable);
            }
        }
        return this.isArray;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof DTFJJavaClass) {
            DTFJJavaClass dTFJJavaClass = (DTFJJavaClass)object;
            return this.j9class.getAddress() == dTFJJavaClass.j9class.getAddress();
        }
        return false;
    }

    public int hashCode() {
        return (int)this.j9class.getAddress();
    }

    public String getFilename() throws com.ibm.dtfj.image.CorruptDataException {
        try {
            return OptInfo.getSourceFileNameForROMClass(this.j9class.romClass());
        }
        catch (Throwable throwable) {
            throw J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), throwable);
        }
    }

    public String toString() {
        try {
            return this.getName();
        }
        catch (com.ibm.dtfj.image.CorruptDataException corruptDataException) {
            return "JavaClass 0x" + Long.toHexString(this.j9class.getAddress()) + " (exception reading class name)";
        }
    }

    public long getInstanceSize() throws com.ibm.dtfj.image.CorruptDataException {
        try {
            return this.j9class.totalInstanceSize().longValue() + J9ObjectHelper.headerSize();
        }
        catch (Throwable throwable) {
            throw J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), throwable);
        }
    }

    public JavaObject getProtectionDomain() throws DataUnavailable, com.ibm.dtfj.image.CorruptDataException {
        try {
            return DTFJJavaClassHelper.getProtectionDomain(this);
        }
        catch (Throwable throwable) {
            throw J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), throwable);
        }
    }

    public boolean isPacked() {
        return false;
    }

    public long getPackedDataSize() throws DataUnavailable, com.ibm.dtfj.image.CorruptDataException {
        return 0L;
    }

    private static class SuperClassCacheEntry {
        public final JavaClass superClass;

        public SuperClassCacheEntry(JavaClass javaClass) {
            this.superClass = javaClass;
        }
    }
}

