/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.view.dtfj.java;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.java.JavaLocation;
import com.ibm.dtfj.java.JavaMethod;
import com.ibm.dtfj.java.JavaStackFrame;
import com.ibm.j9ddr.view.dtfj.J9DDRDTFJUtils;
import com.ibm.j9ddr.vm29.j9.OptInfo;
import com.ibm.j9ddr.vm29.pointer.U8Pointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm29.pointer.generated.J9MethodPointer;
import com.ibm.j9ddr.vm29.types.UDATA;
import com.ibm.j9ddr.vm29.view.dtfj.DTFJContext;
import com.ibm.j9ddr.vm29.view.dtfj.java.DTFJJavaMethod;
import com.ibm.j9ddr.vm29.view.dtfj.java.DTFJJavaThread;
import java.lang.reflect.Modifier;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class DTFJJavaStackFrame
implements JavaStackFrame,
JavaLocation {
    private final ImagePointer basePointer;
    private final DTFJJavaMethod dtfjMethod;
    private final ImagePointer pc;
    private final boolean jitMethod;
    private final U8Pointer bytecodePCOffset;
    private final J9MethodPointer j9method;
    private final DTFJJavaThread thread;
    private List<Object> roots = new LinkedList<Object>();

    public DTFJJavaStackFrame(DTFJJavaThread dTFJJavaThread, DTFJJavaMethod dTFJJavaMethod, J9MethodPointer j9MethodPointer, ImagePointer imagePointer, ImagePointer imagePointer2, U8Pointer u8Pointer, boolean bl) {
        this.dtfjMethod = dTFJJavaMethod;
        this.basePointer = imagePointer2;
        this.bytecodePCOffset = u8Pointer;
        this.pc = imagePointer;
        this.jitMethod = bl;
        this.j9method = j9MethodPointer;
        this.thread = dTFJJavaThread;
    }

    public ImagePointer getBasePointer() throws CorruptDataException {
        return this.basePointer;
    }

    public Iterator getHeapRoots() {
        return this.roots.iterator();
    }

    public JavaLocation getLocation() throws CorruptDataException {
        return this;
    }

    void addReference(Object object) {
        this.roots.add(object);
    }

    boolean isJitMethod() {
        return this.jitMethod;
    }

    public ImagePointer getAddress() throws CorruptDataException {
        return this.pc;
    }

    public int getCompilationLevel() throws CorruptDataException {
        return this.jitMethod ? 1 : 0;
    }

    public String getFilename() throws DataUnavailable, CorruptDataException {
        return this.dtfjMethod.getFilename();
    }

    public int getLineNumber() throws DataUnavailable, CorruptDataException {
        if (J9BuildFlags.J9VM_OPT_DEBUG_INFO_SERVER) {
            int n = 0;
            try {
                n = OptInfo.getLineNumberForROMClass(this.j9method, UDATA.cast(this.bytecodePCOffset));
            }
            catch (Throwable throwable) {
                throw J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), throwable);
            }
            if (n < 0) {
                throw new DataUnavailable();
            }
            return n;
        }
        throw new DataUnavailable();
    }

    public JavaMethod getMethod() throws CorruptDataException {
        return this.dtfjMethod;
    }

    public boolean equals(Object object) {
        if (object instanceof DTFJJavaStackFrame) {
            DTFJJavaStackFrame dTFJJavaStackFrame = (DTFJJavaStackFrame)object;
            if (!dTFJJavaStackFrame.basePointer.equals((Object)this.basePointer)) {
                return false;
            }
            if (!dTFJJavaStackFrame.bytecodePCOffset.equals(this.bytecodePCOffset)) {
                return false;
            }
            if (!dTFJJavaStackFrame.j9method.equals(this.j9method)) {
                return false;
            }
            if (!dTFJJavaStackFrame.pc.equals((Object)this.pc)) {
                return false;
            }
            return dTFJJavaStackFrame.jitMethod == this.jitMethod;
        }
        return false;
    }

    public int hashCode() {
        return this.basePointer.hashCode();
    }

    public String toString() {
        try {
            String string = "";
            try {
                string = this.dtfjMethod.getDeclaringClass().getName();
                string = string.replace("/", ".");
            }
            catch (DataUnavailable dataUnavailable) {
                string = "<class name unavailable>";
            }
            String string2 = this.dtfjMethod.getName();
            if (Modifier.isNative(this.dtfjMethod.getModifiers())) {
                return string + "." + string2 + "()";
            }
            String string3 = this.dtfjMethod.getFilename();
            int n = -1;
            try {
                n = this.getLineNumber();
            }
            catch (DataUnavailable dataUnavailable) {
                // empty catch block
            }
            if (n != -1) {
                return string + "." + string2 + "(" + string3 + ":" + n + ")";
            }
            return string + "." + string2 + "(" + string3 + ")";
        }
        catch (Throwable throwable) {
            J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), throwable);
            return super.toString();
        }
    }
}

