/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cuda;

import com.ibm.cuda.CudaDevice;
import com.ibm.cuda.CudaException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.util.concurrent.atomic.AtomicLong;

public final class CudaBuffer
implements AutoCloseable {
    private static final ByteOrder DeviceOrder = ByteOrder.LITTLE_ENDIAN;
    private final int deviceId;
    private final AtomicLong devicePtr;
    private final long length;
    private final CudaBuffer parent;

    private static native long allocate(int var0, long var1) throws CudaException;

    private static native ByteBuffer allocateDirectBuffer(long var0);

    private static int chunkBytes(long l) {
        return l <= Integer.MAX_VALUE ? (int)l : 0x7FFFFFF8;
    }

    private static native void copyFromDevice(int var0, long var1, int var3, long var4, long var6) throws CudaException;

    private static native void copyFromHostByte(int var0, long var1, byte[] var3, int var4, int var5) throws CudaException;

    private static native void copyFromHostChar(int var0, long var1, char[] var3, int var4, int var5) throws CudaException;

    private static native void copyFromHostDirect(int var0, long var1, Buffer var3, long var4, long var6) throws CudaException;

    private static native void copyFromHostDouble(int var0, long var1, double[] var3, int var4, int var5) throws CudaException;

    private static native void copyFromHostFloat(int var0, long var1, float[] var3, int var4, int var5) throws CudaException;

    private static native void copyFromHostInt(int var0, long var1, int[] var3, int var4, int var5) throws CudaException;

    private static native void copyFromHostLong(int var0, long var1, long[] var3, int var4, int var5) throws CudaException;

    private static native void copyFromHostShort(int var0, long var1, short[] var3, int var4, int var5) throws CudaException;

    private static native void copyToHostByte(int var0, long var1, byte[] var3, int var4, int var5) throws CudaException;

    private static native void copyToHostChar(int var0, long var1, char[] var3, int var4, int var5) throws CudaException;

    private static native void copyToHostDirect(int var0, long var1, Buffer var3, long var4, long var6) throws CudaException;

    private static native void copyToHostDouble(int var0, long var1, double[] var3, int var4, int var5) throws CudaException;

    private static native void copyToHostFloat(int var0, long var1, float[] var3, int var4, int var5) throws CudaException;

    private static native void copyToHostInt(int var0, long var1, int[] var3, int var4, int var5) throws CudaException;

    private static native void copyToHostLong(int var0, long var1, long[] var3, int var4, int var5) throws CudaException;

    private static native void copyToHostShort(int var0, long var1, short[] var3, int var4, int var5) throws CudaException;

    private static native void fill(int var0, long var1, int var3, int var4, long var5) throws CudaException;

    private static native void freeDirectBuffer(Buffer var0);

    private static void rangeCheck(long l, long l2, long l3) {
        if (l2 > l3) {
            throw new IllegalArgumentException("fromIndex(" + l2 + ") > toIndex(" + l3 + ')');
        }
        if (l2 < 0L) {
            throw new IndexOutOfBoundsException(String.valueOf(l2));
        }
        if (l3 > l) {
            throw new IndexOutOfBoundsException(String.valueOf(l3));
        }
    }

    private static native void release(int var0, long var1) throws CudaException;

    private CudaBuffer(CudaBuffer cudaBuffer, int n, long l, long l2) {
        this.deviceId = n;
        this.devicePtr = new AtomicLong(l);
        this.length = l2;
        this.parent = cudaBuffer;
    }

    public CudaBuffer(CudaDevice cudaDevice, long l) throws CudaException {
        this.deviceId = cudaDevice.getDeviceId();
        this.devicePtr = new AtomicLong(CudaBuffer.allocate(this.deviceId, l));
        this.length = l;
        this.parent = null;
    }

    public CudaBuffer atOffset(long l) {
        return this.slice(l, this.length);
    }

    @Override
    public void close() throws CudaException {
        long l = this.devicePtr.getAndSet(0L);
        if (l != 0L && this.parent == null) {
            CudaBuffer.release(this.deviceId, l);
        }
    }

    public void copyFrom(byte[] byArray) throws CudaException {
        this.copyFrom(byArray, 0, byArray.length);
    }

    public void copyFrom(byte[] byArray, int n, int n2) throws CudaException {
        CudaBuffer.rangeCheck(byArray.length, n, n2);
        this.lengthCheck(n2 - n, 0);
        CudaBuffer.copyFromHostByte(this.deviceId, this.getAddress(), byArray, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyFrom(ByteBuffer byteBuffer) throws CudaException {
        int n = byteBuffer.position();
        int n2 = byteBuffer.limit();
        int n3 = n2 - n;
        this.lengthCheck(n3, 0);
        if (byteBuffer.isDirect()) {
            CudaBuffer.copyFromHostDirect(this.deviceId, this.getAddress(), byteBuffer, n, n2);
        } else if (byteBuffer.hasArray()) {
            int n4 = byteBuffer.arrayOffset();
            this.copyFrom(byteBuffer.array(), n + n4, n2 + n4);
        } else {
            ByteBuffer byteBuffer2 = CudaBuffer.allocateDirectBuffer(n3).order(DeviceOrder);
            try {
                byteBuffer2.put(byteBuffer);
                CudaBuffer.copyFromHostDirect(this.deviceId, this.getAddress(), byteBuffer2, 0L, n3);
            }
            finally {
                CudaBuffer.freeDirectBuffer(byteBuffer2);
            }
        }
        byteBuffer.position(n2);
    }

    public void copyFrom(char[] cArray) throws CudaException {
        this.copyFrom(cArray, 0, cArray.length);
    }

    public void copyFrom(char[] cArray, int n, int n2) throws CudaException {
        CudaBuffer.rangeCheck(cArray.length, n, n2);
        this.lengthCheck(n2 - n, 1);
        CudaBuffer.copyFromHostChar(this.deviceId, this.getAddress(), cArray, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyFrom(CharBuffer charBuffer) throws CudaException {
        int n = charBuffer.position();
        int n2 = charBuffer.limit();
        this.lengthCheck(n2 - n, 1);
        if (charBuffer.isDirect()) {
            CudaBuffer.copyFromHostDirect(this.deviceId, this.getAddress(), charBuffer, (long)n << 1, (long)n2 << 1);
        } else if (charBuffer.hasArray()) {
            int n3 = charBuffer.arrayOffset();
            this.copyFrom(charBuffer.array(), n + n3, n2 + n3);
        } else {
            long l = (long)(n2 - n) << 1;
            int n4 = CudaBuffer.chunkBytes(l);
            CharBuffer charBuffer2 = charBuffer.slice();
            CharBuffer charBuffer3 = CudaBuffer.allocateDirectBuffer(n4).order(DeviceOrder).asCharBuffer();
            try {
                for (long i = 0L; i < l; i += (long)n4) {
                    long l2 = Math.min(i + (long)n4, l);
                    charBuffer2.limit((int)(l2 >> 1));
                    charBuffer3.clear();
                    charBuffer3.put(charBuffer2);
                    CudaBuffer.copyFromHostDirect(this.deviceId, this.getAddress() + i, charBuffer3, 0L, l2 - i);
                }
            }
            finally {
                CudaBuffer.freeDirectBuffer(charBuffer3);
            }
        }
        charBuffer.position(n2);
    }

    public void copyFrom(CudaBuffer cudaBuffer, long l, long l2) throws CudaException {
        long l3 = l2 - l;
        CudaBuffer.rangeCheck(cudaBuffer.length, l, l2);
        this.lengthCheck(l3, 0);
        CudaBuffer.copyFromDevice(this.deviceId, this.getAddress(), cudaBuffer.deviceId, cudaBuffer.getAddress() + l, l3);
    }

    public void copyFrom(double[] dArray) throws CudaException {
        this.copyFrom(dArray, 0, dArray.length);
    }

    public void copyFrom(double[] dArray, int n, int n2) throws CudaException {
        CudaBuffer.rangeCheck(dArray.length, n, n2);
        this.lengthCheck(n2 - n, 3);
        CudaBuffer.copyFromHostDouble(this.deviceId, this.getAddress(), dArray, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyFrom(DoubleBuffer doubleBuffer) throws CudaException {
        int n = doubleBuffer.position();
        int n2 = doubleBuffer.limit();
        this.lengthCheck(n2 - n, 3);
        if (doubleBuffer.isDirect()) {
            CudaBuffer.copyFromHostDirect(this.deviceId, this.getAddress(), doubleBuffer, (long)n << 3, (long)n2 << 3);
        } else if (doubleBuffer.hasArray()) {
            int n3 = doubleBuffer.arrayOffset();
            this.copyFrom(doubleBuffer.array(), n + n3, n2 + n3);
        } else {
            long l = (long)(n2 - n) << 3;
            int n4 = CudaBuffer.chunkBytes(l);
            DoubleBuffer doubleBuffer2 = doubleBuffer.slice();
            DoubleBuffer doubleBuffer3 = CudaBuffer.allocateDirectBuffer(n4).order(DeviceOrder).asDoubleBuffer();
            try {
                for (long i = 0L; i < l; i += (long)n4) {
                    long l2 = Math.min(i + (long)n4, l);
                    doubleBuffer2.limit((int)(l2 >> 3));
                    doubleBuffer3.clear();
                    doubleBuffer3.put(doubleBuffer2);
                    CudaBuffer.copyFromHostDirect(this.deviceId, this.getAddress() + i, doubleBuffer3, 0L, l2 - i);
                }
            }
            finally {
                CudaBuffer.freeDirectBuffer(doubleBuffer3);
            }
        }
        doubleBuffer.position(n2);
    }

    public void copyFrom(float[] fArray) throws CudaException {
        this.copyFrom(fArray, 0, fArray.length);
    }

    public void copyFrom(float[] fArray, int n, int n2) throws CudaException {
        CudaBuffer.rangeCheck(fArray.length, n, n2);
        this.lengthCheck(n2 - n, 2);
        CudaBuffer.copyFromHostFloat(this.deviceId, this.getAddress(), fArray, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyFrom(FloatBuffer floatBuffer) throws CudaException {
        int n = floatBuffer.position();
        int n2 = floatBuffer.limit();
        this.lengthCheck(n2 - n, 2);
        if (floatBuffer.isDirect()) {
            CudaBuffer.copyFromHostDirect(this.deviceId, this.getAddress(), floatBuffer, (long)n << 2, (long)n2 << 2);
        } else if (floatBuffer.hasArray()) {
            int n3 = floatBuffer.arrayOffset();
            this.copyFrom(floatBuffer.array(), n + n3, n2 + n3);
        } else {
            long l = (long)(n2 - n) << 2;
            int n4 = CudaBuffer.chunkBytes(l);
            FloatBuffer floatBuffer2 = floatBuffer.slice();
            FloatBuffer floatBuffer3 = CudaBuffer.allocateDirectBuffer(n4).order(DeviceOrder).asFloatBuffer();
            try {
                for (long i = 0L; i < l; i += (long)n4) {
                    long l2 = Math.min(i + (long)n4, l);
                    floatBuffer2.limit((int)(l2 >> 2));
                    floatBuffer3.clear();
                    floatBuffer3.put(floatBuffer2);
                    CudaBuffer.copyFromHostDirect(this.deviceId, this.getAddress() + i, floatBuffer3, 0L, l2 - i);
                }
            }
            finally {
                CudaBuffer.freeDirectBuffer(floatBuffer3);
            }
        }
        floatBuffer.position(n2);
    }

    public void copyFrom(int[] nArray) throws CudaException {
        this.copyFrom(nArray, 0, nArray.length);
    }

    public void copyFrom(int[] nArray, int n, int n2) throws CudaException {
        CudaBuffer.rangeCheck(nArray.length, n, n2);
        this.lengthCheck(n2 - n, 2);
        CudaBuffer.copyFromHostInt(this.deviceId, this.getAddress(), nArray, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyFrom(IntBuffer intBuffer) throws CudaException {
        int n = intBuffer.position();
        int n2 = intBuffer.limit();
        this.lengthCheck(n2 - n, 2);
        if (intBuffer.isDirect()) {
            CudaBuffer.copyFromHostDirect(this.deviceId, this.getAddress(), intBuffer, (long)n << 2, (long)n2 << 2);
        } else if (intBuffer.hasArray()) {
            int n3 = intBuffer.arrayOffset();
            this.copyFrom(intBuffer.array(), n + n3, n2 + n3);
        } else {
            long l = (long)(n2 - n) << 2;
            int n4 = CudaBuffer.chunkBytes(l);
            IntBuffer intBuffer2 = intBuffer.slice();
            IntBuffer intBuffer3 = CudaBuffer.allocateDirectBuffer(n4).order(DeviceOrder).asIntBuffer();
            try {
                for (long i = 0L; i < l; i += (long)n4) {
                    long l2 = Math.min(i + (long)n4, l);
                    intBuffer2.limit((int)(l2 >> 2));
                    intBuffer3.clear();
                    intBuffer3.put(intBuffer2);
                    CudaBuffer.copyFromHostDirect(this.deviceId, this.getAddress() + i, intBuffer3, 0L, l2 - i);
                }
            }
            finally {
                CudaBuffer.freeDirectBuffer(intBuffer3);
            }
        }
        intBuffer.position(n2);
    }

    public void copyFrom(long[] lArray) throws CudaException {
        this.copyFrom(lArray, 0, lArray.length);
    }

    public void copyFrom(long[] lArray, int n, int n2) throws CudaException {
        CudaBuffer.rangeCheck(lArray.length, n, n2);
        this.lengthCheck(n2 - n, 3);
        CudaBuffer.copyFromHostLong(this.deviceId, this.getAddress(), lArray, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyFrom(LongBuffer longBuffer) throws CudaException {
        int n = longBuffer.position();
        int n2 = longBuffer.limit();
        this.lengthCheck(n2 - n, 3);
        if (longBuffer.isDirect()) {
            CudaBuffer.copyFromHostDirect(this.deviceId, this.getAddress(), longBuffer, (long)n << 3, (long)n2 << 3);
        } else if (longBuffer.hasArray()) {
            int n3 = longBuffer.arrayOffset();
            this.copyFrom(longBuffer.array(), n + n3, n2 + n3);
        } else {
            long l = (long)(n2 - n) << 3;
            int n4 = CudaBuffer.chunkBytes(l);
            LongBuffer longBuffer2 = longBuffer.slice();
            LongBuffer longBuffer3 = CudaBuffer.allocateDirectBuffer(n4).order(DeviceOrder).asLongBuffer();
            try {
                for (long i = 0L; i < l; i += (long)n4) {
                    long l2 = Math.min(i + (long)n4, l);
                    longBuffer2.limit((int)(l2 >> 3));
                    longBuffer3.clear();
                    longBuffer3.put(longBuffer2);
                    CudaBuffer.copyFromHostDirect(this.deviceId, this.getAddress() + i, longBuffer3, 0L, l2 - i);
                }
            }
            finally {
                CudaBuffer.freeDirectBuffer(longBuffer3);
            }
        }
        longBuffer.position(n2);
    }

    public void copyFrom(short[] sArray) throws CudaException {
        this.copyFrom(sArray, 0, sArray.length);
    }

    public void copyFrom(short[] sArray, int n, int n2) throws CudaException {
        CudaBuffer.rangeCheck(sArray.length, n, n2);
        this.lengthCheck(n2 - n, 1);
        CudaBuffer.copyFromHostShort(this.deviceId, this.getAddress(), sArray, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyFrom(ShortBuffer shortBuffer) throws CudaException {
        int n = shortBuffer.position();
        int n2 = shortBuffer.limit();
        this.lengthCheck(n2 - n, 1);
        if (shortBuffer.isDirect()) {
            CudaBuffer.copyFromHostDirect(this.deviceId, this.getAddress(), shortBuffer, (long)n << 1, (long)n2 << 1);
        } else if (shortBuffer.hasArray()) {
            int n3 = shortBuffer.arrayOffset();
            this.copyFrom(shortBuffer.array(), n + n3, n2 + n3);
        } else {
            long l = (long)(n2 - n) << 1;
            int n4 = CudaBuffer.chunkBytes(l);
            ShortBuffer shortBuffer2 = shortBuffer.slice();
            ShortBuffer shortBuffer3 = CudaBuffer.allocateDirectBuffer(n4).order(DeviceOrder).asShortBuffer();
            try {
                for (long i = 0L; i < l; i += (long)n4) {
                    long l2 = Math.min(i + (long)n4, l);
                    shortBuffer2.limit((int)(l2 >> 1));
                    shortBuffer3.clear();
                    shortBuffer3.put(shortBuffer2);
                    CudaBuffer.copyFromHostDirect(this.deviceId, this.getAddress() + i, shortBuffer3, 0L, l2 - i);
                }
            }
            finally {
                CudaBuffer.freeDirectBuffer(shortBuffer3);
            }
        }
        shortBuffer.position(n2);
    }

    public void copyTo(byte[] byArray) throws CudaException {
        this.copyTo(byArray, 0, byArray.length);
    }

    public void copyTo(byte[] byArray, int n, int n2) throws CudaException {
        CudaBuffer.rangeCheck(byArray.length, n, n2);
        this.lengthCheck(n2 - n, 0);
        CudaBuffer.copyToHostByte(this.deviceId, this.getAddress(), byArray, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyTo(ByteBuffer byteBuffer) throws CudaException {
        int n = byteBuffer.position();
        int n2 = byteBuffer.limit();
        int n3 = n2 - n;
        this.lengthCheck(n3, 0);
        if (byteBuffer.isDirect()) {
            CudaBuffer.copyToHostDirect(this.deviceId, this.getAddress(), byteBuffer, n, n2);
        } else if (byteBuffer.hasArray()) {
            int n4 = byteBuffer.arrayOffset();
            this.copyTo(byteBuffer.array(), n + n4, n2 + n4);
        } else {
            ByteBuffer byteBuffer2 = CudaBuffer.allocateDirectBuffer(n3).order(DeviceOrder);
            try {
                CudaBuffer.copyToHostDirect(this.deviceId, this.getAddress(), byteBuffer2, 0L, n3);
                byteBuffer.put(byteBuffer2);
            }
            finally {
                CudaBuffer.freeDirectBuffer(byteBuffer2);
            }
        }
        byteBuffer.position(n2);
    }

    public void copyTo(char[] cArray) throws CudaException {
        this.copyTo(cArray, 0, cArray.length);
    }

    public void copyTo(char[] cArray, int n, int n2) throws CudaException {
        CudaBuffer.rangeCheck(cArray.length, n, n2);
        this.lengthCheck(n2 - n, 1);
        CudaBuffer.copyToHostChar(this.deviceId, this.getAddress(), cArray, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyTo(CharBuffer charBuffer) throws CudaException {
        int n = charBuffer.position();
        int n2 = charBuffer.limit();
        this.lengthCheck(n2 - n, 1);
        if (charBuffer.isDirect()) {
            CudaBuffer.copyToHostDirect(this.deviceId, this.getAddress(), charBuffer, (long)n << 1, (long)n2 << 1);
        } else if (charBuffer.hasArray()) {
            int n3 = charBuffer.arrayOffset();
            this.copyTo(charBuffer.array(), n + n3, n2 + n3);
        } else {
            long l = (long)(n2 - n) << 1;
            int n4 = CudaBuffer.chunkBytes(l);
            CharBuffer charBuffer2 = CudaBuffer.allocateDirectBuffer(n4).order(DeviceOrder).asCharBuffer();
            try {
                for (long i = 0L; i < l; i += (long)n4) {
                    int n5 = (int)Math.min(l - i, (long)n4);
                    charBuffer2.position(0).limit(n5 >> 1);
                    CudaBuffer.copyToHostDirect(this.deviceId, this.getAddress() + i, charBuffer2, 0L, n5);
                    charBuffer.put(charBuffer2);
                }
            }
            finally {
                CudaBuffer.freeDirectBuffer(charBuffer2);
            }
        }
        charBuffer.position(n2);
    }

    public void copyTo(double[] dArray) throws CudaException {
        this.copyTo(dArray, 0, dArray.length);
    }

    public void copyTo(double[] dArray, int n, int n2) throws CudaException {
        CudaBuffer.rangeCheck(dArray.length, n, n2);
        this.lengthCheck(n2 - n, 3);
        CudaBuffer.copyToHostDouble(this.deviceId, this.getAddress(), dArray, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyTo(DoubleBuffer doubleBuffer) throws CudaException {
        int n = doubleBuffer.position();
        int n2 = doubleBuffer.limit();
        this.lengthCheck(n2 - n, 3);
        if (doubleBuffer.isDirect()) {
            CudaBuffer.copyToHostDirect(this.deviceId, this.getAddress(), doubleBuffer, (long)n << 3, (long)n2 << 3);
        } else if (doubleBuffer.hasArray()) {
            int n3 = doubleBuffer.arrayOffset();
            this.copyTo(doubleBuffer.array(), n + n3, n2 + n3);
        } else {
            long l = (long)(n2 - n) << 3;
            int n4 = CudaBuffer.chunkBytes(l);
            DoubleBuffer doubleBuffer2 = CudaBuffer.allocateDirectBuffer(n4).order(DeviceOrder).asDoubleBuffer();
            try {
                for (long i = 0L; i < l; i += (long)n4) {
                    int n5 = (int)Math.min(l - i, (long)n4);
                    doubleBuffer2.position(0).limit(n5 >> 3);
                    CudaBuffer.copyToHostDirect(this.deviceId, this.getAddress() + i, doubleBuffer2, 0L, n5);
                    doubleBuffer.put(doubleBuffer2);
                }
            }
            finally {
                CudaBuffer.freeDirectBuffer(doubleBuffer2);
            }
        }
        doubleBuffer.position(n2);
    }

    public void copyTo(float[] fArray) throws CudaException {
        this.copyTo(fArray, 0, fArray.length);
    }

    public void copyTo(float[] fArray, int n, int n2) throws CudaException {
        CudaBuffer.rangeCheck(fArray.length, n, n2);
        this.lengthCheck(n2 - n, 2);
        CudaBuffer.copyToHostFloat(this.deviceId, this.getAddress(), fArray, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyTo(FloatBuffer floatBuffer) throws CudaException {
        int n = floatBuffer.position();
        int n2 = floatBuffer.limit();
        this.lengthCheck(n2 - n, 2);
        if (floatBuffer.isDirect()) {
            CudaBuffer.copyToHostDirect(this.deviceId, this.getAddress(), floatBuffer, (long)n << 2, (long)n2 << 2);
        } else if (floatBuffer.hasArray()) {
            int n3 = floatBuffer.arrayOffset();
            this.copyTo(floatBuffer.array(), n + n3, n2 + n3);
        } else {
            long l = (long)(n2 - n) << 2;
            int n4 = CudaBuffer.chunkBytes(l);
            FloatBuffer floatBuffer2 = CudaBuffer.allocateDirectBuffer(n4).order(DeviceOrder).asFloatBuffer();
            try {
                for (long i = 0L; i < l; i += (long)n4) {
                    int n5 = (int)Math.min(l - i, (long)n4);
                    floatBuffer2.position(0).limit(n5 >> 2);
                    CudaBuffer.copyToHostDirect(this.deviceId, this.getAddress() + i, floatBuffer2, 0L, n5);
                    floatBuffer.put(floatBuffer2);
                }
            }
            finally {
                CudaBuffer.freeDirectBuffer(floatBuffer2);
            }
        }
        floatBuffer.position(n2);
    }

    public void copyTo(int[] nArray) throws CudaException {
        this.copyTo(nArray, 0, nArray.length);
    }

    public void copyTo(int[] nArray, int n, int n2) throws CudaException {
        CudaBuffer.rangeCheck(nArray.length, n, n2);
        this.lengthCheck(n2 - n, 2);
        CudaBuffer.copyToHostInt(this.deviceId, this.getAddress(), nArray, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyTo(IntBuffer intBuffer) throws CudaException {
        int n = intBuffer.position();
        int n2 = intBuffer.limit();
        this.lengthCheck(n2 - n, 2);
        if (intBuffer.isDirect()) {
            CudaBuffer.copyToHostDirect(this.deviceId, this.getAddress(), intBuffer, (long)n << 2, (long)n2 << 2);
        } else if (intBuffer.hasArray()) {
            int n3 = intBuffer.arrayOffset();
            this.copyTo(intBuffer.array(), n + n3, n2 + n3);
        } else {
            long l = (long)(n2 - n) << 2;
            int n4 = CudaBuffer.chunkBytes(l);
            IntBuffer intBuffer2 = CudaBuffer.allocateDirectBuffer(n4).order(DeviceOrder).asIntBuffer();
            try {
                for (long i = 0L; i < l; i += (long)n4) {
                    int n5 = (int)Math.min(l - i, (long)n4);
                    intBuffer2.position(0).limit(n5 >> 2);
                    CudaBuffer.copyToHostDirect(this.deviceId, this.getAddress() + i, intBuffer2, 0L, n5);
                    intBuffer.put(intBuffer2);
                }
            }
            finally {
                CudaBuffer.freeDirectBuffer(intBuffer2);
            }
        }
        intBuffer.position(n2);
    }

    public void copyTo(long[] lArray) throws CudaException {
        this.copyTo(lArray, 0, lArray.length);
    }

    public void copyTo(long[] lArray, int n, int n2) throws CudaException {
        CudaBuffer.rangeCheck(lArray.length, n, n2);
        this.lengthCheck(n2 - n, 3);
        CudaBuffer.copyToHostLong(this.deviceId, this.getAddress(), lArray, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyTo(LongBuffer longBuffer) throws CudaException {
        int n = longBuffer.position();
        int n2 = longBuffer.limit();
        this.lengthCheck(n2 - n, 3);
        if (longBuffer.isDirect()) {
            CudaBuffer.copyToHostDirect(this.deviceId, this.getAddress(), longBuffer, (long)n << 3, (long)n2 << 3);
        } else if (longBuffer.hasArray()) {
            int n3 = longBuffer.arrayOffset();
            this.copyTo(longBuffer.array(), n + n3, n2 + n3);
        } else {
            long l = (long)(n2 - n) << 3;
            int n4 = CudaBuffer.chunkBytes(l);
            LongBuffer longBuffer2 = CudaBuffer.allocateDirectBuffer(n4).order(DeviceOrder).asLongBuffer();
            try {
                for (long i = 0L; i < l; i += (long)n4) {
                    int n5 = (int)Math.min(l - i, (long)n4);
                    longBuffer2.position(0).limit(n5 >> 3);
                    CudaBuffer.copyToHostDirect(this.deviceId, this.getAddress() + i, longBuffer2, 0L, n5);
                    longBuffer.put(longBuffer2);
                }
            }
            finally {
                CudaBuffer.freeDirectBuffer(longBuffer2);
            }
        }
        longBuffer.position(n2);
    }

    public void copyTo(short[] sArray) throws CudaException {
        this.copyTo(sArray, 0, sArray.length);
    }

    public void copyTo(short[] sArray, int n, int n2) throws CudaException {
        CudaBuffer.rangeCheck(sArray.length, n, n2);
        this.lengthCheck(n2 - n, 1);
        CudaBuffer.copyToHostShort(this.deviceId, this.getAddress(), sArray, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyTo(ShortBuffer shortBuffer) throws CudaException {
        int n = shortBuffer.position();
        int n2 = shortBuffer.limit();
        this.lengthCheck(n2 - n, 1);
        if (shortBuffer.isDirect()) {
            CudaBuffer.copyToHostDirect(this.deviceId, this.getAddress(), shortBuffer, (long)n << 1, (long)n2 << 1);
        } else if (shortBuffer.hasArray()) {
            int n3 = shortBuffer.arrayOffset();
            this.copyTo(shortBuffer.array(), n + n3, n2 + n3);
        } else {
            long l = (long)(n2 - n) << 1;
            int n4 = CudaBuffer.chunkBytes(l);
            ShortBuffer shortBuffer2 = CudaBuffer.allocateDirectBuffer(n4).order(DeviceOrder).asShortBuffer();
            try {
                for (long i = 0L; i < l; i += (long)n4) {
                    int n5 = (int)Math.min(l - i, (long)n4);
                    shortBuffer2.position(0).limit(n5 >> 1);
                    CudaBuffer.copyToHostDirect(this.deviceId, this.getAddress() + i, shortBuffer2, 0L, n5);
                    shortBuffer.put(shortBuffer2);
                }
            }
            finally {
                CudaBuffer.freeDirectBuffer(shortBuffer2);
            }
        }
        shortBuffer.position(n2);
    }

    public void fillByte(byte by, long l) throws CudaException {
        this.lengthCheck(l, 0);
        CudaBuffer.fill(this.deviceId, this.getAddress(), 1, by, l);
    }

    public void fillChar(char c, long l) throws CudaException {
        this.lengthCheck(l, 1);
        CudaBuffer.fill(this.deviceId, this.getAddress(), 2, c, l);
    }

    public void fillFloat(float f, long l) throws CudaException {
        this.fillInt(Float.floatToRawIntBits(f), l);
    }

    public void fillInt(int n, long l) throws CudaException {
        this.lengthCheck(l, 2);
        CudaBuffer.fill(this.deviceId, this.getAddress(), 4, n, l);
    }

    public void fillShort(short s, long l) throws CudaException {
        this.lengthCheck(l, 1);
        CudaBuffer.fill(this.deviceId, this.getAddress(), 2, s, l);
    }

    long getAddress() {
        long l = this.devicePtr.get();
        if (l != 0L) {
            if (this.parent == null || this.parent.devicePtr.get() != 0L) {
                return l;
            }
            this.devicePtr.set(0L);
        }
        throw new IllegalStateException();
    }

    public long getLength() {
        return this.length;
    }

    private void lengthCheck(long l, int n) {
        if (0L > l || l > this.length >> n) {
            throw new IndexOutOfBoundsException(String.valueOf(l));
        }
    }

    public CudaBuffer slice(long l, long l2) {
        if (l == 0L && l2 == this.length) {
            return this;
        }
        CudaBuffer.rangeCheck(this.length, l, l2);
        return new CudaBuffer(this.parent != null ? this.parent : this, this.deviceId, this.getAddress() + l, l2 - l);
    }
}

