/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dataaccess;

import java.util.Arrays;

class CommonData {
    public static final int HIGHER_NIBBLE_MASK = 240;
    public static final int LOWER_NIBBLE_MASK = 15;
    public static final int INTEGER_MASK = 255;
    static final byte PACKED_ZERO = 0;
    static final byte PACKED_SIGNED_ZERO = 12;
    static final byte PACKED_PLUS = 12;
    static final byte PACKED_MINUS = 13;
    private static final byte PACKED_ALT_PLUS = 15;
    private static final byte PACKED_ALT_PLUS1 = 14;
    private static final byte PACKED_ALT_PLUS2 = 10;
    private static final byte PACKED_ALT_MINUS = 11;
    protected static final byte EXTERNAL_SIGN_PLUS = 78;
    protected static final byte EXTERNAL_SIGN_MINUS = 96;
    protected static final byte EXTERNAL_EMBEDDED_SIGN_PLUS = -64;
    protected static final byte EXTERNAL_EMBEDDED_SIGN_MINUS = -48;
    protected static final byte EXTERNAL_EMBEDDED_SIGN_PLUS_ALTERNATE_A = -96;
    protected static final byte EXTERNAL_EMBEDDED_SIGN_PLUS_ALTERNATE_E = -32;
    protected static final byte EXTERNAL_EMBEDDED_SIGN_PLUS_ALTERNATE_F = -16;
    protected static final byte EXTERNAL_EMBEDDED_SIGN_MINUS_ALTERNATE_B = -80;
    protected static final byte PACKED_INVALID_DIGIT = -1;
    private static final int BYTE_ARITHMETICS_TABLE_LENGTH = 1024;
    private static final byte[] packedSumValues = new byte[1024];
    private static final byte[] packedSumPlusOneValues = new byte[1024];
    private static final byte[] packedDifferenceValues = new byte[1024];
    private static final byte[] packedDifferenceMinusOneValues = new byte[1024];

    CommonData() {
    }

    public static int getPackedSumValues(int n) {
        return packedSumValues[n] & 0xFF;
    }

    public static int getExternalByteCounts(int n, int n2) {
        switch (n2) {
            case 1: 
            case 2: {
                return n;
            }
            case 3: 
            case 4: {
                return n + 1;
            }
        }
        throw new IllegalArgumentException("illegal decimalType.");
    }

    public static byte getPackedSumPlusOneValues(int n) {
        return packedSumPlusOneValues[n];
    }

    public static byte getPackedDifferenceValues(int n) {
        return packedDifferenceValues[n];
    }

    public static byte getPackedDifferenceMinusOneValues(int n) {
        return packedDifferenceMinusOneValues[n];
    }

    public static byte getPackedAddOneValues(byte by) {
        int n = (by & 0xF0) >> 4;
        int n2 = (by & 0xF) + 1;
        if (n2 == 10) {
            n2 = 0;
            if (++n == 10) {
                n = 0;
            }
        }
        return (byte)((n << 4) + n2);
    }

    public static byte getPackedBorrowOneValues(byte by) {
        int n = (by & 0xF0) >> 4;
        int n2 = (by & 0xF) - 1;
        if (n2 < 0) {
            n2 = 9;
            if (--n < 0) {
                n = 9;
            }
        }
        return (byte)((n << 4) + n2);
    }

    public static int getPackedToBinaryValues(int n) {
        return ((n & 0xF0) >> 4) * 10 + (n & 0xF);
    }

    public static byte getBinaryToPackedValues(int n) {
        int n2 = (n / 10 << 4) + n % 10;
        return (byte)n2;
    }

    public static byte getSign(int n) {
        return (byte)(n == 13 || n == 11 ? 13 : 12);
    }

    public static int getPackedByteCount(int n) {
        return n / 2 + 1;
    }

    public static byte getPackedAddOneSignValues(byte by) {
        int n = (by & 0xF0) >> 4;
        if (++n == 10) {
            n = 0;
        }
        return (byte)(n << 4 | by & 0xF);
    }

    public static void setPackedSumArrays(int n, int n2, int n3, int n4) {
        byte by;
        int n5 = (n << 5) + n2;
        int n6 = (n3 << 5) + n4;
        int n7 = n5 + n6;
        int n8 = (n2 + n4) % 10;
        int n9 = n8 < n2 ? (n + n3 + 1) % 10 : (n + n3) % 10;
        CommonData.packedSumValues[n7] = by = (byte)((n9 << 4) + n8);
        n8 = (n2 + n4 + 1) % 10;
        n9 = n8 <= n2 ? (n + n3 + 1) % 10 : (n + n3) % 10;
        CommonData.packedSumPlusOneValues[n7] = by = (byte)((n9 << 4) + n8);
        n7 = n5 - n6 & 0x3FF;
        n8 = (n2 - n4 + 10) % 10;
        n9 = n8 > n2 ? (n - n3 - 1 + 10) % 10 : (n - n3 + 10) % 10;
        by = (byte)((n9 << 4) + n8);
        if (packedDifferenceValues[n7] == -1) {
            CommonData.packedDifferenceValues[n7] = by;
        }
        n9 = (n8 = (n2 - n4 - 1 + 10) % 10) >= n2 ? (n - n3 - 1 + 10) % 10 : (n - n3 + 10) % 10;
        CommonData.packedDifferenceMinusOneValues[n7] = by = (byte)((n9 << 4) + n8);
    }

    static {
        Arrays.fill(packedSumValues, (byte)-1);
        Arrays.fill(packedSumPlusOneValues, (byte)-1);
        Arrays.fill(packedDifferenceValues, (byte)-1);
        Arrays.fill(packedDifferenceMinusOneValues, (byte)-1);
        for (int i = 0; i < 10; ++i) {
            for (int j = 0; j < 10; ++j) {
                for (int k = 0; k < 10; ++k) {
                    for (int i2 = 0; i2 < 10; ++i2) {
                        CommonData.setPackedSumArrays(i, j, k, i2);
                    }
                }
            }
        }
    }
}

