/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.ldap;

import com.sun.jndi.toolkit.url.Uri;
import com.sun.jndi.toolkit.url.UrlUtil;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.security.AccessController;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.naming.NamingException;
import sun.security.action.GetPropertyAction;

public final class LdapURL
extends Uri {
    private static final String PARSE_MODE_PROP = "com.sun.jndi.ldapURLParsing";
    private static final Uri.ParseMode DEFAULT_PARSE_MODE = Uri.ParseMode.COMPAT;
    public static final Uri.ParseMode PARSE_MODE;
    private boolean useSsl = false;
    private String DN = null;
    private String attributes = null;
    private String scope = null;
    private String filter = null;
    private String extensions = null;

    public LdapURL(String string) throws NamingException {
        try {
            this.init(string);
            this.useSsl = this.scheme.equalsIgnoreCase("ldaps");
            if (!this.scheme.equalsIgnoreCase("ldap") && !this.useSsl) {
                throw this.newInvalidURISchemeException(string);
            }
            this.parsePathAndQuery();
        }
        catch (MalformedURLException malformedURLException) {
            NamingException namingException = new NamingException("Cannot parse url: " + string);
            namingException.setRootCause(malformedURLException);
            throw namingException;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            NamingException namingException = new NamingException("Cannot parse url: " + string);
            namingException.setRootCause(unsupportedEncodingException);
            throw namingException;
        }
    }

    @Override
    protected MalformedURLException newInvalidURISchemeException(String string) {
        return new MalformedURLException("Not an LDAP URL: " + string);
    }

    @Override
    protected boolean isSchemeOnly(String string) {
        return LdapURL.isLdapSchemeOnly(string);
    }

    @Override
    protected Uri.ParseMode parseMode() {
        return PARSE_MODE;
    }

    public boolean useSsl() {
        return this.useSsl;
    }

    public String getDN() {
        return this.DN;
    }

    public String getAttributes() {
        return this.attributes;
    }

    public String getScope() {
        return this.scope;
    }

    public String getFilter() {
        return this.filter;
    }

    public String getExtensions() {
        return this.extensions;
    }

    public static String[] fromList(String string) throws NamingException {
        String[] stringArray = new String[(string.length() + 1) / 2];
        int n = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n++] = LdapURL.validateURI(stringTokenizer.nextToken());
        }
        String[] stringArray2 = new String[n];
        System.arraycopy((Object)stringArray, 0, (Object)stringArray2, 0, n);
        return stringArray2;
    }

    public static boolean isLdapSchemeOnly(String string) {
        return "ldap:".equals(string) || "ldaps:".equals(string);
    }

    public static String validateURI(String string) {
        if (PARSE_MODE == Uri.ParseMode.LEGACY) {
            return string;
        }
        if (LdapURL.isLdapSchemeOnly(string)) {
            return string;
        }
        return URI.create(string).toString();
    }

    public static boolean hasQueryComponents(String string) {
        return string.lastIndexOf(63) != -1;
    }

    static String toUrlString(String string, int n, String string2, boolean bl) {
        try {
            String string3;
            String string4 = string3 = string != null ? string : "";
            if (string3.indexOf(58) != -1 && string3.charAt(0) != '[') {
                string3 = "[" + string3 + "]";
            }
            String string5 = n != -1 ? ":" + n : "";
            String string6 = string2 != null ? "/" + UrlUtil.encode(string2, "UTF8") : "";
            String string7 = bl ? "ldaps://" + string3 + string5 + string6 : "ldap://" + string3 + string5 + string6;
            return LdapURL.validateURI(string7);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalStateException("UTF-8 encoding unavailable");
        }
    }

    private void parsePathAndQuery() throws MalformedURLException, UnsupportedEncodingException {
        int n;
        if (this.path.equals("")) {
            return;
        }
        String string = this.DN = this.path.startsWith("/") ? this.path.substring(1) : this.path;
        if (this.DN.length() > 0) {
            this.DN = UrlUtil.decode(this.DN, "UTF8");
        }
        if (this.query == null || this.query.length() < 2) {
            return;
        }
        int n2 = 1;
        int n3 = this.query.indexOf(63, n2);
        int n4 = n = n3 == -1 ? this.query.length() : n3;
        if (n - n2 > 0) {
            this.attributes = this.query.substring(n2, n);
        }
        if ((n2 = n + 1) >= this.query.length()) {
            return;
        }
        n3 = this.query.indexOf(63, n2);
        int n5 = n = n3 == -1 ? this.query.length() : n3;
        if (n - n2 > 0) {
            this.scope = this.query.substring(n2, n);
        }
        if ((n2 = n + 1) >= this.query.length()) {
            return;
        }
        n3 = this.query.indexOf(63, n2);
        int n6 = n = n3 == -1 ? this.query.length() : n3;
        if (n - n2 > 0) {
            this.filter = this.query.substring(n2, n);
            this.filter = UrlUtil.decode(this.filter, "UTF8");
        }
        if ((n2 = n + 1) >= this.query.length()) {
            return;
        }
        if (this.query.length() - n2 > 0) {
            this.extensions = this.query.substring(n2);
            this.extensions = UrlUtil.decode(this.extensions, "UTF8");
        }
    }

    static {
        GetPropertyAction getPropertyAction = new GetPropertyAction(PARSE_MODE_PROP, DEFAULT_PARSE_MODE.toString());
        Uri.ParseMode parseMode = DEFAULT_PARSE_MODE;
        try {
            String string = AccessController.doPrivileged(getPropertyAction);
            parseMode = Uri.ParseMode.valueOf(string.toUpperCase(Locale.ROOT));
        }
        catch (Throwable throwable) {
            parseMode = DEFAULT_PARSE_MODE;
        }
        finally {
            PARSE_MODE = parseMode;
        }
    }
}

