/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.utils;

import java.io.IOException;
import java.io.OutputStream;

public class UnsyncByteArrayOutputStream
extends OutputStream {
    private static final int VM_ARRAY_INDEX_MAX_VALUE = 0x7FFFFFF7;
    private static final int INITIAL_SIZE = 8192;
    private byte[] buf = new byte[8192];
    private int size = 8192;
    private int pos;

    @Override
    public void write(byte[] byArray) {
        if (0x7FFFFFF7 - this.pos < byArray.length) {
            throw new OutOfMemoryError();
        }
        int n = this.pos + byArray.length;
        if (n > this.size) {
            this.expandSize(n);
        }
        System.arraycopy((Object)byArray, 0, (Object)this.buf, this.pos, byArray.length);
        this.pos = n;
    }

    @Override
    public void write(byte[] byArray, int n, int n2) {
        if (0x7FFFFFF7 - this.pos < n2) {
            throw new OutOfMemoryError();
        }
        int n3 = this.pos + n2;
        if (n3 > this.size) {
            this.expandSize(n3);
        }
        System.arraycopy((Object)byArray, n, (Object)this.buf, this.pos, n2);
        this.pos = n3;
    }

    @Override
    public void write(int n) {
        if (0x7FFFFFF7 - this.pos == 0) {
            throw new OutOfMemoryError();
        }
        int n2 = this.pos + 1;
        if (n2 > this.size) {
            this.expandSize(n2);
        }
        this.buf[this.pos++] = (byte)n;
    }

    public byte[] toByteArray() {
        byte[] byArray = new byte[this.pos];
        System.arraycopy((Object)this.buf, 0, (Object)byArray, 0, this.pos);
        return byArray;
    }

    public void reset() {
        this.pos = 0;
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        outputStream.write(this.buf, 0, this.pos);
    }

    private void expandSize(int n) {
        int n2 = this.size;
        while (n > n2) {
            if ((n2 <<= 1) >= 0) continue;
            n2 = 0x7FFFFFF7;
        }
        byte[] byArray = new byte[n2];
        System.arraycopy((Object)this.buf, 0, (Object)byArray, 0, this.pos);
        this.buf = byArray;
        this.size = n2;
    }
}

