/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractQueue;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.SortedSet;
import java.util.Spliterator;
import java.util.function.Consumer;
import sun.misc.SharedSecrets;

public class PriorityQueue<E>
extends AbstractQueue<E>
implements Serializable {
    private static final long serialVersionUID = -7720805057305804111L;
    private static final int DEFAULT_INITIAL_CAPACITY = 11;
    transient Object[] queue;
    private int size = 0;
    private final Comparator<? super E> comparator;
    transient int modCount = 0;
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;

    public PriorityQueue() {
        this(11, null);
    }

    public PriorityQueue(int n) {
        this(n, null);
    }

    public PriorityQueue(Comparator<? super E> comparator) {
        this(11, comparator);
    }

    public PriorityQueue(int n, Comparator<? super E> comparator) {
        if (n < 1) {
            throw new IllegalArgumentException();
        }
        this.queue = new Object[n];
        this.comparator = comparator;
    }

    public PriorityQueue(Collection<? extends E> collection) {
        if (collection instanceof SortedSet) {
            SortedSet sortedSet = (SortedSet)collection;
            this.comparator = sortedSet.comparator();
            this.initElementsFromCollection(sortedSet);
        } else if (collection instanceof PriorityQueue) {
            PriorityQueue priorityQueue = (PriorityQueue)collection;
            this.comparator = priorityQueue.comparator();
            this.initFromPriorityQueue(priorityQueue);
        } else {
            this.comparator = null;
            this.initFromCollection(collection);
        }
    }

    public PriorityQueue(PriorityQueue<? extends E> priorityQueue) {
        this.comparator = priorityQueue.comparator();
        this.initFromPriorityQueue(priorityQueue);
    }

    public PriorityQueue(SortedSet<? extends E> sortedSet) {
        this.comparator = sortedSet.comparator();
        this.initElementsFromCollection(sortedSet);
    }

    private void initFromPriorityQueue(PriorityQueue<? extends E> priorityQueue) {
        if (priorityQueue.getClass() == PriorityQueue.class) {
            this.queue = priorityQueue.toArray();
            this.size = priorityQueue.size();
        } else {
            this.initFromCollection(priorityQueue);
        }
    }

    private void initElementsFromCollection(Collection<? extends E> collection) {
        int n;
        Object[] objectArray = collection.toArray();
        if (collection.getClass() != ArrayList.class) {
            objectArray = Arrays.copyOf(objectArray, objectArray.length, Object[].class);
        }
        if ((n = objectArray.length) == 1 || this.comparator != null) {
            for (int i = 0; i < n; ++i) {
                if (objectArray[i] != null) continue;
                throw new NullPointerException();
            }
        }
        this.queue = objectArray;
        this.size = objectArray.length;
    }

    private void initFromCollection(Collection<? extends E> collection) {
        this.initElementsFromCollection(collection);
        this.heapify();
    }

    private void grow(int n) {
        int n2;
        int n3 = n2 + ((n2 = this.queue.length) < 64 ? n2 + 2 : n2 >> 1);
        if (n3 - 0x7FFFFFF7 > 0) {
            n3 = PriorityQueue.hugeCapacity(n);
        }
        this.queue = Arrays.copyOf(this.queue, n3);
    }

    private static int hugeCapacity(int n) {
        if (n < 0) {
            throw new OutOfMemoryError();
        }
        return n > 0x7FFFFFF7 ? Integer.MAX_VALUE : 0x7FFFFFF7;
    }

    @Override
    public boolean add(E e) {
        return this.offer(e);
    }

    @Override
    public boolean offer(E e) {
        if (e == null) {
            throw new NullPointerException();
        }
        ++this.modCount;
        int n = this.size;
        if (n >= this.queue.length) {
            this.grow(n + 1);
        }
        this.size = n + 1;
        if (n == 0) {
            this.queue[0] = e;
        } else {
            this.siftUp(n, e);
        }
        return true;
    }

    @Override
    public E peek() {
        return (E)(this.size == 0 ? null : this.queue[0]);
    }

    private int indexOf(Object object) {
        if (object != null) {
            for (int i = 0; i < this.size; ++i) {
                if (!object.equals(this.queue[i])) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public boolean remove(Object object) {
        int n = this.indexOf(object);
        if (n == -1) {
            return false;
        }
        this.removeAt(n);
        return true;
    }

    boolean removeEq(Object object) {
        for (int i = 0; i < this.size; ++i) {
            if (object != this.queue[i]) continue;
            this.removeAt(i);
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(Object object) {
        return this.indexOf(object) != -1;
    }

    @Override
    public Object[] toArray() {
        return Arrays.copyOf(this.queue, this.size);
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        int n = this.size;
        if (TArray.length < n) {
            return Arrays.copyOf(this.queue, n, TArray.getClass());
        }
        System.arraycopy((Object)this.queue, 0, TArray, 0, n);
        if (TArray.length > n) {
            TArray[n] = null;
        }
        return TArray;
    }

    @Override
    public Iterator<E> iterator() {
        return new Itr();
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void clear() {
        ++this.modCount;
        for (int i = 0; i < this.size; ++i) {
            this.queue[i] = null;
        }
        this.size = 0;
    }

    @Override
    public E poll() {
        if (this.size == 0) {
            return null;
        }
        int n = --this.size;
        ++this.modCount;
        Object object = this.queue[0];
        Object object2 = this.queue[n];
        this.queue[n] = null;
        if (n != 0) {
            this.siftDown(0, object2);
        }
        return (E)object;
    }

    private E removeAt(int n) {
        int n2;
        ++this.modCount;
        if ((n2 = --this.size) == n) {
            this.queue[n] = null;
        } else {
            Object object = this.queue[n2];
            this.queue[n2] = null;
            this.siftDown(n, object);
            if (this.queue[n] == object) {
                this.siftUp(n, object);
                if (this.queue[n] != object) {
                    return (E)object;
                }
            }
        }
        return null;
    }

    private void siftUp(int n, E e) {
        if (this.comparator != null) {
            this.siftUpUsingComparator(n, e);
        } else {
            this.siftUpComparable(n, e);
        }
    }

    private void siftUpComparable(int n, E e) {
        int n2;
        Object object;
        Comparable comparable = (Comparable)e;
        while (n > 0 && comparable.compareTo(object = this.queue[n2 = n - 1 >>> 1]) < 0) {
            this.queue[n] = object;
            n = n2;
        }
        this.queue[n] = comparable;
    }

    private void siftUpUsingComparator(int n, E e) {
        int n2;
        Object object;
        while (n > 0 && this.comparator.compare(e, object = this.queue[n2 = n - 1 >>> 1]) < 0) {
            this.queue[n] = object;
            n = n2;
        }
        this.queue[n] = e;
    }

    private void siftDown(int n, E e) {
        if (this.comparator != null) {
            this.siftDownUsingComparator(n, e);
        } else {
            this.siftDownComparable(n, e);
        }
    }

    private void siftDownComparable(int n, E e) {
        Comparable comparable = (Comparable)e;
        int n2 = this.size >>> 1;
        while (n < n2) {
            int n3 = (n << 1) + 1;
            Object object = this.queue[n3];
            int n4 = n3 + 1;
            if (n4 < this.size && ((Comparable)object).compareTo(this.queue[n4]) > 0) {
                n3 = n4;
                object = this.queue[n3];
            }
            if (comparable.compareTo(object) <= 0) break;
            this.queue[n] = object;
            n = n3;
        }
        this.queue[n] = comparable;
    }

    private void siftDownUsingComparator(int n, E e) {
        int n2 = this.size >>> 1;
        while (n < n2) {
            int n3 = (n << 1) + 1;
            Object object = this.queue[n3];
            int n4 = n3 + 1;
            if (n4 < this.size && this.comparator.compare(object, this.queue[n4]) > 0) {
                n3 = n4;
                object = this.queue[n3];
            }
            if (this.comparator.compare(e, object) <= 0) break;
            this.queue[n] = object;
            n = n3;
        }
        this.queue[n] = e;
    }

    private void heapify() {
        for (int i = (this.size >>> 1) - 1; i >= 0; --i) {
            this.siftDown(i, this.queue[i]);
        }
    }

    public Comparator<? super E> comparator() {
        return this.comparator;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(Math.max(2, this.size + 1));
        for (int i = 0; i < this.size; ++i) {
            objectOutputStream.writeObject(this.queue[i]);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        objectInputStream.readInt();
        SharedSecrets.getJavaOISAccess().checkArray(objectInputStream, Object[].class, this.size);
        this.queue = new Object[this.size];
        for (int i = 0; i < this.size; ++i) {
            this.queue[i] = objectInputStream.readObject();
        }
        this.heapify();
    }

    @Override
    public final Spliterator<E> spliterator() {
        return new PriorityQueueSpliterator(this, 0, -1, 0);
    }

    static final class PriorityQueueSpliterator<E>
    implements Spliterator<E> {
        private final PriorityQueue<E> pq;
        private int index;
        private int fence;
        private int expectedModCount;

        PriorityQueueSpliterator(PriorityQueue<E> priorityQueue, int n, int n2, int n3) {
            this.pq = priorityQueue;
            this.index = n;
            this.fence = n2;
            this.expectedModCount = n3;
        }

        private int getFence() {
            int n = this.fence;
            if (n < 0) {
                this.expectedModCount = this.pq.modCount;
                n = this.fence = ((PriorityQueue)this.pq).size;
            }
            return n;
        }

        @Override
        public PriorityQueueSpliterator<E> trySplit() {
            PriorityQueueSpliterator<E> priorityQueueSpliterator;
            int n = this.index;
            int n2 = this.getFence();
            int n3 = n + n2 >>> 1;
            if (n >= n3) {
                priorityQueueSpliterator = null;
            } else {
                this.index = n3;
                PriorityQueueSpliterator<E> priorityQueueSpliterator2 = new PriorityQueueSpliterator<E>(this.pq, n, this.index, this.expectedModCount);
                priorityQueueSpliterator = priorityQueueSpliterator2;
            }
            return priorityQueueSpliterator;
        }

        @Override
        public void forEachRemaining(Consumer<? super E> consumer) {
            if (consumer == null) {
                throw new NullPointerException();
            }
            PriorityQueue<E> priorityQueue = this.pq;
            if (priorityQueue != null) {
                Object[] objectArray = priorityQueue.queue;
                if (priorityQueue.queue != null) {
                    int n;
                    int n2 = this.fence;
                    if (n2 < 0) {
                        n = priorityQueue.modCount;
                        n2 = ((PriorityQueue)priorityQueue).size;
                    } else {
                        n = this.expectedModCount;
                    }
                    int n3 = this.index;
                    if (n3 >= 0 && (this.index = n2) <= objectArray.length) {
                        while (true) {
                            Object object;
                            if (n3 < n2) {
                                object = objectArray[n3];
                                if (object == null) break;
                            } else {
                                if (priorityQueue.modCount != n) break;
                                return;
                            }
                            consumer.accept(object);
                            ++n3;
                        }
                    }
                }
            }
            throw new ConcurrentModificationException();
        }

        @Override
        public boolean tryAdvance(Consumer<? super E> consumer) {
            if (consumer == null) {
                throw new NullPointerException();
            }
            int n = this.getFence();
            int n2 = this.index;
            if (n2 >= 0 && n2 < n) {
                this.index = n2 + 1;
                Object object = this.pq.queue[n2];
                if (object == null) {
                    throw new ConcurrentModificationException();
                }
                consumer.accept(object);
                if (this.pq.modCount != this.expectedModCount) {
                    throw new ConcurrentModificationException();
                }
                return true;
            }
            return false;
        }

        @Override
        public long estimateSize() {
            return this.getFence() - this.index;
        }

        @Override
        public int characteristics() {
            return 16704;
        }
    }

    private final class Itr
    implements Iterator<E> {
        private int cursor = 0;
        private int lastRet = -1;
        private ArrayDeque<E> forgetMeNot = null;
        private E lastRetElt = null;
        private int expectedModCount;

        private Itr() {
            this.expectedModCount = PriorityQueue.this.modCount;
        }

        @Override
        public boolean hasNext() {
            return this.cursor < PriorityQueue.this.size || this.forgetMeNot != null && !this.forgetMeNot.isEmpty();
        }

        @Override
        public E next() {
            if (this.expectedModCount != PriorityQueue.this.modCount) {
                throw new ConcurrentModificationException();
            }
            if (this.cursor < PriorityQueue.this.size) {
                this.lastRet = this.cursor++;
                return PriorityQueue.this.queue[this.lastRet];
            }
            if (this.forgetMeNot != null) {
                this.lastRet = -1;
                this.lastRetElt = this.forgetMeNot.poll();
                if (this.lastRetElt != null) {
                    return this.lastRetElt;
                }
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            if (this.expectedModCount != PriorityQueue.this.modCount) {
                throw new ConcurrentModificationException();
            }
            if (this.lastRet != -1) {
                Object object = PriorityQueue.this.removeAt(this.lastRet);
                this.lastRet = -1;
                if (object == null) {
                    --this.cursor;
                } else {
                    if (this.forgetMeNot == null) {
                        this.forgetMeNot = new ArrayDeque();
                    }
                    this.forgetMeNot.add(object);
                }
            } else if (this.lastRetElt != null) {
                PriorityQueue.this.removeEq(this.lastRetElt);
                this.lastRetElt = null;
            } else {
                throw new IllegalStateException();
            }
            this.expectedModCount = PriorityQueue.this.modCount;
        }
    }
}

