/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.text.BreakIterator;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.Arrays;

class WhitespaceBasedBreakIterator
extends BreakIterator {
    private char[] text = new char[0];
    private int[] breaks = new int[]{0};
    private int pos = 0;

    WhitespaceBasedBreakIterator() {
    }

    @Override
    public void setText(CharacterIterator characterIterator) {
        int n = characterIterator.getBeginIndex();
        this.text = new char[characterIterator.getEndIndex() - n];
        int[] nArray = new int[this.text.length + 1];
        int n2 = 0;
        nArray[n2++] = n;
        int n3 = 0;
        boolean bl = false;
        char c = characterIterator.first();
        while (c != '\uffff') {
            this.text[n3] = c;
            boolean bl2 = Character.isWhitespace(c);
            if (bl && !bl2) {
                nArray[n2++] = n3 + n;
            }
            bl = bl2;
            ++n3;
            c = characterIterator.next();
        }
        if (this.text.length > 0) {
            nArray[n2++] = this.text.length + n;
        }
        this.breaks = new int[n2];
        System.arraycopy((Object)nArray, 0, (Object)this.breaks, 0, n2);
    }

    @Override
    public CharacterIterator getText() {
        return new StringCharacterIterator(new String(this.text));
    }

    @Override
    public int first() {
        this.pos = 0;
        return this.breaks[0];
    }

    @Override
    public int last() {
        this.pos = this.breaks.length - 1;
        return this.breaks[this.pos];
    }

    @Override
    public int current() {
        return this.breaks[this.pos];
    }

    @Override
    public int next() {
        return this.pos == this.breaks.length - 1 ? -1 : this.breaks[++this.pos];
    }

    @Override
    public int previous() {
        return this.pos == 0 ? -1 : this.breaks[--this.pos];
    }

    @Override
    public int next(int n) {
        return this.checkhit(this.pos + n);
    }

    @Override
    public int following(int n) {
        return this.adjacent(n, 1);
    }

    @Override
    public int preceding(int n) {
        return this.adjacent(n, -1);
    }

    private int checkhit(int n) {
        if (n < 0 || n >= this.breaks.length) {
            return -1;
        }
        this.pos = n;
        return this.breaks[this.pos];
    }

    private int adjacent(int n, int n2) {
        int n3 = Arrays.binarySearch(this.breaks, n);
        int n4 = n3 < 0 ? (n2 < 0 ? -1 : -2) : 0;
        return this.checkhit(Math.abs(n3) + n2 + n4);
    }
}

