/*
 * Decompiled with CFR 0.152.
 */
package openj9.internal.security;

import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import sun.security.util.Debug;

public final class RestrictedSecurity {
    private static final Debug debug = Debug.getInstance("semerufips");
    private static final boolean userEnabledFIPS;
    private static boolean isFIPSSupported;
    private static boolean isFIPSEnabled;
    private static final boolean allowSetProperties;
    private static final boolean isNSSSupported;
    private static final boolean userSetProfile;
    private static final boolean shouldEnableSecurity;
    private static String selectedProfile;
    private static String profileID;
    private static boolean securityEnabled;
    private static String userSecurityID;
    private static ProfileParser profileParser;
    private static boolean enableCheckHashes;
    private static RestrictedSecurityProperties restricts;
    private static final Set<String> unmodifiableProperties;
    private static final Map<String, List<String>> supportedPlatformsNSS;

    private RestrictedSecurity() {
    }

    private static boolean isJarVerifierInStackTrace() {
        StackTraceElement[] stackTraceElementArray;
        for (StackTraceElement stackTraceElement : stackTraceElementArray = Thread.currentThread().getStackTrace()) {
            if (!"java.util.jar.JarVerifier".equals(stackTraceElement.getClassName())) continue;
            return true;
        }
        return false;
    }

    public static void checkHashValues() {
        RestrictedSecurity.checkHashValues(true);
    }

    private static void checkHashValues(boolean bl) {
        ProfileParser profileParser = RestrictedSecurity.profileParser;
        if (profileParser != null) {
            if (bl) {
                enableCheckHashes = true;
            }
            if (enableCheckHashes && !RestrictedSecurity.isJarVerifierInStackTrace()) {
                RestrictedSecurity.profileParser = null;
                profileParser.checkHashValues();
            }
        }
    }

    public static boolean isEnabled() {
        return securityEnabled;
    }

    public static String getRandomAlgorithm() {
        if (!securityEnabled) {
            RestrictedSecurity.printStackTraceAndExit("Restricted security mode secure random algorithm can only be used when restricted security mode is enabled.");
        }
        return RestrictedSecurity.restricts.jdkSecureRandomAlgorithm;
    }

    public static boolean isFIPSEnabled() {
        if (securityEnabled) {
            return isFIPSEnabled;
        }
        return false;
    }

    public static boolean isServiceAllowed(Provider.Service service) {
        if (securityEnabled) {
            RestrictedSecurity.checkHashValues(false);
            return restricts.isRestrictedServiceAllowed(service, true);
        }
        return true;
    }

    public static boolean canServiceBeRegistered(Provider.Service service) {
        if (securityEnabled) {
            RestrictedSecurity.checkHashValues(false);
            return restricts.isRestrictedServiceAllowed(service, false);
        }
        return true;
    }

    public static boolean isProviderAllowed(String string) {
        if (securityEnabled) {
            RestrictedSecurity.checkHashValues(false);
            int n = string.indexOf(45);
            if (n >= 0) {
                string = string.substring(0, n);
            }
            return restricts.isRestrictedProviderAllowed(string);
        }
        return true;
    }

    public static boolean isProviderAllowed(Class<?> clazz) {
        if (securityEnabled) {
            RestrictedSecurity.checkHashValues(false);
            String string = clazz.getName();
            if (Provider.class.isAssignableFrom(clazz)) {
                return restricts.isRestrictedProviderAllowed(string);
            }
            if (debug != null) {
                debug.println("The provider class " + string + " does not extend java.security.Provider.");
            }
        }
        return true;
    }

    private static void getProfileID(Properties properties) {
        String string = "RestrictedSecurity." + selectedProfile;
        if (selectedProfile.indexOf(46) != -1) {
            if (debug != null) {
                debug.println("Profile specified using full name (i.e., <profile.version>): " + selectedProfile);
            }
            for (Object k : properties.keySet()) {
                String string2;
                if (!(k instanceof String) || !(string2 = (String)k).startsWith(string)) continue;
                profileID = string;
                return;
            }
            RestrictedSecurity.printStackTraceAndExit(selectedProfile + " is not present in the java.security file.");
        } else {
            if (debug != null) {
                debug.println("Profile specified without version (i.e., <profile>): " + selectedProfile);
            }
            String string3 = null;
            boolean bl = false;
            String string4 = string + '.';
            for (Object k : properties.keySet()) {
                String string5;
                if (!(k instanceof String) || !(string5 = (String)k).startsWith(string4)) continue;
                bl = true;
                if (!string5.endsWith(".desc.default") || !Boolean.parseBoolean(properties.getProperty(string5))) continue;
                if (string3 == null) {
                    string3 = string5.substring(0, string5.length() - ".desc.default".length());
                    continue;
                }
                RestrictedSecurity.printStackTraceAndExit("Multiple default RestrictedSecurity profiles for " + selectedProfile);
            }
            if (!bl) {
                RestrictedSecurity.printStackTraceAndExit(selectedProfile + " is not present in the java.security file.");
            } else if (string3 == null) {
                RestrictedSecurity.printStackTraceAndExit("No default RestrictedSecurity profile was found for " + selectedProfile);
            } else {
                profileID = string3;
            }
        }
    }

    private static void checkIfKnownProfileSupported() {
        if (profileID.contains("NSS") && !isNSSSupported) {
            RestrictedSecurity.printStackTraceAndExit("NSS RestrictedSecurity profiles are not supported on this platform.");
        }
        if (debug != null) {
            debug.println("RestrictedSecurity profile " + profileID + " is supported on this platform.");
        }
    }

    private static void checkFIPSCompatibility() {
        boolean bl = restricts.descIsFIPS;
        if (bl) {
            if (debug != null) {
                debug.println("RestrictedSecurity profile " + profileID + " is specified as FIPS compliant.");
            }
            isFIPSEnabled = true;
        } else {
            RestrictedSecurity.printStackTraceAndExit("RestrictedSecurity profile " + profileID + " is not specified as FIPS compliant, but the semeru.fips system property is set to true.");
        }
    }

    public static void checkSetSecurityProperty(String string) {
        if (debug != null) {
            debug.println("RestrictedSecurity: Checking whether property '" + string + "' can be set.");
        }
        if (unmodifiableProperties.contains(string)) {
            if (debug != null) {
                debug.println("RestrictedSecurity: Property '" + string + "' cannot be set.");
                debug.println("If you want to override the check and allow all securityproperties to be set, use '-Dsemeru.fips.allowsetproperties=true'.");
                debug.println("BEWARE: You might not be FIPS compliant if you select to override!");
            }
            throw new SecurityException("Property '" + string + "' cannot be set programmatically when in FIPS mode");
        }
        if (debug != null) {
            debug.println("RestrictedSecurity: Property '" + string + "' can be set without issue.");
        }
    }

    public static boolean configure(Properties properties) {
        if (securityEnabled) {
            RestrictedSecurity.printStackTraceAndExit("Restricted security mode is already initialized, it can't be initialized twice.");
        }
        try {
            if (shouldEnableSecurity) {
                if (debug != null) {
                    debug.println("Restricted security mode is being enabled...");
                }
                RestrictedSecurity.getProfileID(properties);
                RestrictedSecurity.checkIfKnownProfileSupported();
                profileParser = new ProfileParser(profileID, properties);
                restricts = RestrictedSecurity.profileParser.getProperties();
                RestrictedSecurity.restrictsCheck();
                Iterator iterator = properties.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    String string = (String)entry.getKey();
                    if (!string.startsWith("security.provider")) continue;
                    if (debug != null) {
                        debug.println("Removing provider: " + entry);
                    }
                    iterator.remove();
                }
                RestrictedSecurity.setProviders(properties);
                RestrictedSecurity.setProperties(properties);
                if (debug != null) {
                    debug.println("Restricted security mode loaded.");
                    debug.println("Restricted security mode properties: " + properties.toString());
                }
                securityEnabled = true;
            }
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.println("Unable to load restricted security mode configurations.");
            }
            RestrictedSecurity.printStackTraceAndExit(exception);
        }
        return securityEnabled;
    }

    private static void setProviders(Properties properties) {
        if (debug != null) {
            debug.println("Adding restricted security provider.");
        }
        int n = 0;
        for (String string : restricts.providers) {
            properties.setProperty("security.provider." + ++n, string);
            if (debug == null) continue;
            debug.println("Added restricted security provider: " + string);
        }
    }

    private static void setProperties(Properties properties) {
        String string;
        Object object2;
        if (debug != null) {
            debug.println("Adding restricted security properties.");
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("jdk.tls.disabledNamedCurves", restricts.jdkTlsDisabledNamedCurves);
        hashMap.put("jdk.tls.disabledAlgorithms", restricts.jdkTlsDisabledAlgorithms);
        hashMap.put("jdk.tls.ephemeralDHKeySize", restricts.jdkTlsEphemeralDHKeySize);
        hashMap.put("jdk.tls.legacyAlgorithms", restricts.jdkTlsLegacyAlgorithms);
        hashMap.put("jdk.certpath.disabledAlgorithms", restricts.jdkCertpathDisabledAlgorithms);
        hashMap.put("jdk.security.legacyAlgorithms", restricts.jdkSecurityLegacyAlgorithms);
        if (restricts.descIsFIPS) {
            if (RestrictedSecurity.restricts.jdkFipsMode == null) {
                RestrictedSecurity.printStackTraceAndExit(profileID + ".fips.mode property is not set in FIPS profile");
            }
            if ((object2 = System.getProperty("com.ibm.fips.mode")) == null) {
                System.setProperty("com.ibm.fips.mode", RestrictedSecurity.restricts.jdkFipsMode);
            } else if (!((String)object2).equals(RestrictedSecurity.restricts.jdkFipsMode)) {
                RestrictedSecurity.printStackTraceAndExit("Property com.ibm.fips.mode is incompatible with semeru.customprofile and semeru.fips properties");
            }
        }
        if (userEnabledFIPS && !allowSetProperties) {
            unmodifiableProperties.addAll(hashMap.keySet());
        }
        for (Map.Entry object3 : hashMap.entrySet()) {
            String string2 = (String)object3.getKey();
            String string3 = (String)object3.getValue();
            if (RestrictedSecurity.isNullOrBlank(string3)) continue;
            properties.setProperty(string2, string3);
            if (debug == null) continue;
            debug.println("Added restricted security properties, with property: " + string2 + " value: " + string3);
        }
        object2 = restricts.keyStoreType;
        if (!RestrictedSecurity.isNullOrBlank((String)object2)) {
            properties.setProperty("keystore.type", (String)object2);
        }
        if (!RestrictedSecurity.isNullOrBlank(string = restricts.keyStore)) {
            System.setProperty("javax.net.ssl.keyStore", string);
        }
    }

    private static void restrictsCheck() {
        if (restricts == null) {
            RestrictedSecurity.printStackTraceAndExit("Restricted security property is null.");
        }
        if (RestrictedSecurity.isPolicySunset(restricts.descSunsetDate)) {
            RestrictedSecurity.printStackTraceAndExit("Restricted security policy expired.");
        }
        if (RestrictedSecurity.isNullOrBlank(RestrictedSecurity.restricts.jdkSecureRandomAlgorithm)) {
            RestrictedSecurity.printStackTraceAndExit("Restricted security mode secure random is missing.");
        }
        if (userEnabledFIPS) {
            RestrictedSecurity.checkFIPSCompatibility();
        }
    }

    private static boolean isPolicySunset(String string) {
        boolean bl = false;
        if (!RestrictedSecurity.isNullOrBlank(string)) {
            try {
                bl = LocalDate.parse(string, DateTimeFormatter.ofPattern("yyyy-MM-dd")).isBefore(LocalDate.now());
            }
            catch (DateTimeParseException dateTimeParseException) {
                RestrictedSecurity.printStackTraceAndExit("Restricted security policy sunset date is incorrect, the correct format is yyyy-MM-dd.");
            }
        }
        if (debug != null) {
            debug.println("Restricted security policy is sunset: " + bl);
        }
        return bl;
    }

    private static boolean isBlank(String string) {
        return string.trim().isEmpty();
    }

    private static boolean isNullOrBlank(String string) {
        return string == null || RestrictedSecurity.isBlank(string);
    }

    private static void printStackTraceAndExit(Exception exception) {
        exception.printStackTrace();
        System.exit(1);
    }

    private static void printStackTraceAndExit(String string) {
        RestrictedSecurity.printStackTraceAndExit(new RuntimeException(string));
    }

    private static boolean isAsterisk(String string) {
        return "*".equals(string);
    }

    static {
        unmodifiableProperties = new HashSet<String>();
        supportedPlatformsNSS = new HashMap<String, List<String>>();
        supportedPlatformsNSS.put("Arch", Arrays.asList("amd64", "ppc64le", "s390x"));
        supportedPlatformsNSS.put("OS", Arrays.asList("Linux"));
        String[] stringArray = AccessController.doPrivileged(new PrivilegedAction<String[]>(){

            @Override
            public String[] run() {
                return new String[]{System.getProperty("semeru.fips"), System.getProperty("semeru.customprofile"), System.getProperty("os.name"), System.getProperty("os.arch"), System.getProperty("semeru.fips.allowsetproperties")};
            }
        });
        boolean bl = false;
        for (String string : supportedPlatformsNSS.get("OS")) {
            if (!stringArray[2].contains(string)) continue;
            bl = true;
        }
        boolean bl2 = false;
        for (String string : supportedPlatformsNSS.get("Arch")) {
            if (!stringArray[3].contains(string)) continue;
            bl2 = true;
        }
        isFIPSSupported = isNSSSupported = bl && bl2;
        userEnabledFIPS = Boolean.parseBoolean(stringArray[0]);
        allowSetProperties = Boolean.parseBoolean(stringArray[4]);
        if (userEnabledFIPS && isFIPSSupported) {
            selectedProfile = "NSS.140-2";
        }
        if (stringArray[1] != null) {
            selectedProfile = stringArray[1];
            userSetProfile = true;
        } else {
            userSetProfile = false;
        }
        if (userEnabledFIPS && !isFIPSSupported && !userSetProfile) {
            RestrictedSecurity.printStackTraceAndExit("FIPS mode is not supported on this platform by default.\n Use the semeru.customprofile system property to use an available FIPS-compliant profile.\n Note: Not all platforms support FIPS at the moment.");
        }
        shouldEnableSecurity = userEnabledFIPS && isFIPSSupported || userSetProfile;
    }

    private static final class Constraint {
        final String type;
        final String algorithm;
        final String attributes;
        final String acceptedUses;

        Constraint(String string, String string2, String string3, String string4) {
            this.type = string;
            this.algorithm = string2;
            this.attributes = string3;
            this.acceptedUses = string4;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("{").append(this.type);
            stringBuilder.append(", ").append(this.algorithm);
            stringBuilder.append(", ").append(this.attributes);
            if (this.acceptedUses != null) {
                stringBuilder.append(", ").append(this.acceptedUses);
            }
            stringBuilder.append("}");
            return stringBuilder.toString();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof Constraint) {
                Constraint constraint = (Constraint)object;
                return Objects.equals(this.type, constraint.type) && Objects.equals(this.algorithm, constraint.algorithm) && Objects.equals(this.attributes, constraint.attributes) && Objects.equals(this.acceptedUses, constraint.acceptedUses);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.type, this.algorithm, this.attributes, this.acceptedUses);
        }
    }

    private static final class ProfileParser {
        private final Map<String, String> profileProperties;
        private boolean descIsDefault;
        private boolean descIsFIPS;
        private final List<String> providers;
        private final List<String> providersFullyQualifiedClassName;
        private final Map<String, List<Constraint>> providerConstraints;
        private final String profileID;
        private final Map<String, String> profilesHashes;
        private final Map<String, List<String>> profilesInfo;
        private final Set<String> parsedProfiles;
        private final Properties securityProps;
        private final Set<String> profileCheckPropertyNames;
        private final Set<String> profileCheckProviderNames;

        private ProfileParser(String string, Properties properties) {
            Objects.requireNonNull(properties);
            this.profileID = string;
            this.securityProps = properties;
            this.profileProperties = new HashMap<String, String>();
            this.providers = new ArrayList<String>();
            this.providersFullyQualifiedClassName = new ArrayList<String>();
            this.providerConstraints = new HashMap<String, List<Constraint>>();
            this.profilesHashes = new HashMap<String, String>();
            this.profilesInfo = new HashMap<String, List<String>>();
            this.parsedProfiles = new HashSet<String>();
            this.profileCheckPropertyNames = new HashSet<String>();
            this.profileCheckProviderNames = new HashSet<String>();
            this.init(this.profileID);
            this.checkProfileCheck(this.profileID);
        }

        private RestrictedSecurityProperties getProperties() {
            return new RestrictedSecurityProperties(this.profileID, this);
        }

        private boolean isFIPS1402Profile(String string) {
            return "140-2".equals(this.securityProps.getProperty(string + ".fips.mode"));
        }

        private void init(String string) {
            if (debug != null) {
                debug.println("Initializing restricted security properties for '" + string + "'.");
            }
            if (!this.parsedProfiles.add(string)) {
                RestrictedSecurity.printStackTraceAndExit(string + " has already been parsed. Potential infinite recursion.");
            }
            this.loadProfileCheck(string);
            String string2 = string + ".extends";
            String string3 = ProfileParser.parseProperty(this.securityProps.getProperty(string2));
            if (string3 != null) {
                if (debug != null) {
                    debug.println("\t'" + string + "' extends '" + string3 + "'.");
                }
                this.profileCheckPropertyNames.remove(string2);
                String string4 = null;
                if (string3.indexOf(46) != string3.lastIndexOf(46)) {
                    int n = string3.length();
                    for (Object k : this.securityProps.keySet()) {
                        String string5;
                        String string6;
                        if (!(k instanceof String) || !(string6 = (String)k).startsWith(string3) || !(string5 = string6.substring(n)).startsWith(".desc") && !string5.startsWith(".fips") && !string5.startsWith(".javax") && !string5.startsWith(".jce") && !string5.startsWith(".securerandom") && !string5.startsWith(".tls")) continue;
                        string4 = string3;
                        break;
                    }
                    if (string4 == null) {
                        RestrictedSecurity.printStackTraceAndExit(string3 + " that is supposed to extend '" + string + "' is not present in the java.security file or any appended files.");
                    }
                } else {
                    RestrictedSecurity.printStackTraceAndExit(string3 + " that is supposed to extend '" + string + "' is not a full profile name.");
                }
                this.init(string4);
                this.update(string);
            } else {
                try {
                    ArrayList<String> arrayList = new ArrayList<String>();
                    this.initProviders(string, arrayList);
                    this.loadProperties(string, arrayList);
                    String string7 = string + ".desc.hash";
                    String string8 = this.securityProps.getProperty(string7);
                    if (string8 != null) {
                        this.profilesHashes.put(string, string8);
                        this.profilesInfo.put(string, arrayList);
                        this.profileCheckPropertyNames.remove(string7);
                    } else if (!this.isFIPS1402Profile(string)) {
                        RestrictedSecurity.printStackTraceAndExit(string + " is a base profile, so a hash value is mandatory.");
                    }
                }
                catch (Exception exception) {
                    if (debug != null) {
                        debug.println("Unable to initialize restricted security mode.");
                    }
                    RestrictedSecurity.printStackTraceAndExit(exception);
                }
            }
            if (debug != null) {
                debug.println("Initialization of restricted security properties for '" + string + "' completed.");
            }
        }

        private void update(String string) {
            try {
                ArrayList<String> arrayList = new ArrayList<String>();
                this.updateProviders(string, arrayList);
                this.loadProperties(string, arrayList);
                String string2 = string + ".desc.hash";
                String string3 = this.securityProps.getProperty(string2);
                if (string3 != null) {
                    this.profilesHashes.put(this.profileID, string3);
                    this.profilesInfo.put(this.profileID, arrayList);
                    this.profileCheckPropertyNames.remove(string2);
                }
            }
            catch (Exception exception) {
                if (debug != null) {
                    debug.println("Unable to update restricted security properties for '" + string + "'.");
                }
                RestrictedSecurity.printStackTraceAndExit(exception);
            }
        }

        private void parseProvider(String string, int n, boolean bl) {
            String string2;
            if (debug != null) {
                debug.println("\t\tLoading provider in position " + n);
            }
            ProfileParser.checkProviderFormat(string, bl);
            int n2 = string.indexOf(91);
            String string3 = string2 = n2 < 0 ? string.trim() : string.substring(0, n2).trim();
            if (bl) {
                this.providers.set(n - 1, string2);
            } else {
                this.providers.add(n - 1, string2);
            }
            n2 = string2.indexOf(32);
            if (n2 >= 0) {
                string2 = string2.substring(0, n2);
            }
            string2 = string2.trim();
            boolean bl2 = false;
            if (bl) {
                String string4 = this.providersFullyQualifiedClassName.get(n - 1);
                bl2 = !string4.equals(string2);
                this.providersFullyQualifiedClassName.set(n - 1, string2);
            } else {
                this.providersFullyQualifiedClassName.add(n - 1, string2);
            }
            if (debug != null) {
                debug.println("\t\tLoaded provider in position " + n + " named: " + string2);
            }
            this.setConstraints(string2, string, bl2);
        }

        private void removeProvider(String string, int n) {
            int n2;
            if (debug != null) {
                debug.println("\t\tRemoving provider in position " + n);
            }
            if (n == (n2 = this.providersFullyQualifiedClassName.size())) {
                if (debug != null) {
                    debug.println("\t\t\tLast provider. Only one to be removed.");
                }
                String string2 = this.providersFullyQualifiedClassName.remove(n - 1);
                this.providers.remove(n - 1);
                this.providerConstraints.remove(string2);
                if (debug != null) {
                    debug.println("\t\tProvider " + string2 + " removed.");
                }
                return;
            }
            for (int i = n2; i >= n; --i) {
                String string3;
                if (debug != null) {
                    debug.println("\t\t\tNot the last provider. More to be removed.");
                }
                if ((string3 = this.securityProps.getProperty(string + ".jce.provider." + i)) == null || !RestrictedSecurity.isBlank(string3)) {
                    RestrictedSecurity.printStackTraceAndExit("Cannot specify an empty provider in position " + n + " when non-empty ones are specified after it.");
                }
                String string4 = this.providersFullyQualifiedClassName.remove(i - 1);
                this.providers.remove(i - 1);
                this.providerConstraints.remove(string4);
                if (debug == null) continue;
                debug.println("\t\tProvider " + string4 + " removed.");
            }
        }

        private void initProviders(String string, List<String> list) {
            String string2;
            String string3;
            if (debug != null) {
                debug.println("\tLoading providers of restricted security profile.");
            }
            int n = 1;
            while ((string3 = this.securityProps.getProperty(string2 = string + ".jce.provider." + n)) != null) {
                if (RestrictedSecurity.isBlank(string3)) {
                    RestrictedSecurity.printStackTraceAndExit("Cannot specify an empty provider in position " + n + ". Nothing specified before.");
                }
                list.add(string2 + "=" + string3);
                this.parseProvider(string3, n, false);
                this.profileCheckProviderNames.remove(string2);
                ++n;
            }
            if (this.providers.isEmpty()) {
                RestrictedSecurity.printStackTraceAndExit("No providers are specified as part of the Restricted Security profile.");
            }
            if (debug != null) {
                debug.println("\tProviders of restricted security profile successfully loaded.");
            }
        }

        private void updateProviders(String string, List<String> list) {
            String string2;
            String string3;
            int n;
            boolean bl = false;
            int n2 = this.providersFullyQualifiedClassName.size();
            for (n = 1; n <= n2; ++n) {
                string3 = string + ".jce.provider." + n;
                string2 = this.securityProps.getProperty(string3);
                if (string2 == null) continue;
                list.add(string3 + "=" + string2);
                if (RestrictedSecurity.isBlank(string2)) {
                    this.removeProvider(string, n);
                    bl = true;
                    break;
                }
                this.parseProvider(string2, n, true);
                this.profileCheckProviderNames.remove(string3);
            }
            n = n2 + 1;
            while ((string2 = this.securityProps.getProperty(string3 = string + ".jce.provider." + n)) != null) {
                if (RestrictedSecurity.isBlank(string2)) {
                    RestrictedSecurity.printStackTraceAndExit("Cannot specify an empty provider in position " + n + ". Nothing specified before.");
                }
                if (bl) {
                    RestrictedSecurity.printStackTraceAndExit("Cannot add a provider in position " + n + " after removing the ones in previous positions.");
                }
                list.add(string3 + "=" + string2);
                this.parseProvider(string2, n, false);
                this.profileCheckProviderNames.remove(string3);
                ++n;
            }
        }

        private String getExistingValue(String string) {
            if (debug != null) {
                debug.println("\tGetting previous value of property: " + string);
            }
            String string2 = this.profileProperties.get(string);
            String string3 = "\t\tPrevious value from extended profile: ";
            if (string2 == null) {
                String string4;
                string3 = "\t\tPrevious value from java.security file: ";
                switch (string) {
                    case "jdkCertpathDisabledAlgorithms": {
                        string4 = "jdk.certpath.disabledAlgorithms";
                        break;
                    }
                    case "jdkSecurityLegacyAlgorithms": {
                        string4 = "jdk.security.legacyAlgorithms";
                        break;
                    }
                    case "jdkTlsDisabledAlgorithms": {
                        string4 = "jdk.tls.disabledAlgorithms";
                        break;
                    }
                    case "jdkTlsDisabledNamedCurves": {
                        string4 = "jdk.tls.disabledNamedCurves";
                        break;
                    }
                    case "jdkTlsLegacyAlgorithms": {
                        string4 = "jdk.tls.legacyAlgorithms";
                        break;
                    }
                    default: {
                        return null;
                    }
                }
                string2 = this.securityProps.getProperty(string4);
            }
            if (debug != null && string2 != null) {
                debug.println(string3 + string2);
            }
            return string2;
        }

        private void loadProperties(String string, List<String> list) {
            if (debug != null) {
                debug.println("\tLoading properties of restricted security profile.");
            }
            this.setProperty("descName", string + ".desc.name", list);
            if (this.setProperty("descIsDefaultString", string + ".desc.default", list)) {
                this.descIsDefault = Boolean.parseBoolean(this.profileProperties.get("descIsDefaultString"));
            }
            if (this.setProperty("descIsFIPSString", string + ".desc.fips", list)) {
                this.descIsFIPS = Boolean.parseBoolean(this.profileProperties.get("descIsFIPSString"));
            }
            this.setProperty("descNumber", string + ".desc.number", list);
            this.setProperty("descPolicy", string + ".desc.policy", list);
            this.setProperty("descSunsetDate", string + ".desc.sunsetDate", list);
            this.setProperty("jdkTlsDisabledNamedCurves", string + ".tls.disabledNamedCurves", list);
            this.setProperty("jdkTlsDisabledAlgorithms", string + ".tls.disabledAlgorithms", list);
            this.setProperty("jdkTlsEphemeralDHKeySize", string + ".tls.ephemeralDHKeySize", list);
            this.setProperty("jdkTlsLegacyAlgorithms", string + ".tls.legacyAlgorithms", list);
            this.setProperty("jdkCertpathDisabledAlgorithms", string + ".jce.certpath.disabledAlgorithms", list);
            this.setProperty("jdkSecurityLegacyAlgorithms", string + ".jce.legacyAlgorithms", list);
            this.setProperty("keyStoreType", string + ".keystore.type", list);
            this.setProperty("keyStore", string + ".javax.net.ssl.keyStore", list);
            this.setProperty("jdkSecureRandomAlgorithm", string + ".securerandom.algorithm", list);
            this.setProperty("jdkFipsMode", string + ".fips.mode", list);
            if (debug != null) {
                debug.println("\tProperties of restricted security profile successfully loaded.");
            }
        }

        private void setConstraints(String string, String string2, boolean bl) {
            ArrayList<Constraint> arrayList;
            if (debug != null) {
                debug.println("\t\tLoading constraints for security provider: " + string);
            }
            ArrayList<Constraint> arrayList2 = new ArrayList<Constraint>();
            string2 = string2.replaceAll("\\s+", "");
            Pattern pattern = Pattern.compile("\\[.+\\]");
            Matcher matcher = pattern.matcher(string2);
            if (!matcher.find()) {
                if (debug != null) {
                    debug.println("\t\t\tNo constraints for security provider: " + string);
                }
                this.providerConstraints.put(string, arrayList2);
                return;
            }
            pattern = Pattern.compile("\\[([+-]?)\\{(\\w+),([A-Za-z0-9./_:#-]+),([A-Za-z0-9=*|.:]+)(,[A-Za-z0-9._:/$]+)?\\}(,\\{(\\w+),([A-Za-z0-9./_:#-]+),([A-Za-z0-9=*|.:]+)(,[A-Za-z0-9._:/$]+)?\\})*\\]");
            matcher = pattern.matcher(string2);
            if (!matcher.find()) {
                RestrictedSecurity.printStackTraceAndExit("Incorrect constraint definition for provider " + string);
            }
            String string3 = matcher.group(1);
            pattern = Pattern.compile("\\{(\\w+),([A-Za-z0-9./_:#-]+),([A-Za-z0-9=*|.:]+)(,[A-Za-z0-9._:/$]+)?\\}");
            matcher = pattern.matcher(string2);
            while (matcher.find()) {
                arrayList = matcher.group(1);
                String string4 = matcher.group(2);
                String object = matcher.group(3);
                String string5 = matcher.group(4);
                if (string5 != null) {
                    string5 = string5.substring(1);
                    boolean bl2 = false;
                    String[] stringArray = string5.split(":");
                    if (stringArray.length != 2) {
                        bl2 = true;
                    } else {
                        switch (stringArray[0]) {
                            case "FullClassName": 
                            case "Package": {
                                break;
                            }
                            default: {
                                bl2 = true;
                            }
                        }
                    }
                    if (bl2) {
                        RestrictedSecurity.printStackTraceAndExit("Incorrect specification of accepted uses in constraint for " + arrayList + ", " + (String)string4 + ": " + string5);
                    }
                }
                if (!RestrictedSecurity.isAsterisk(object)) {
                    String[] stringArray;
                    for (String string6 : stringArray = object.split(":")) {
                        String[] stringArray2 = string6.split("=", 2);
                        if (stringArray2.length == 2) continue;
                        RestrictedSecurity.printStackTraceAndExit("Constraint attributes format is incorrect: " + string2);
                    }
                }
                Constraint stringArray = new Constraint((String)((Object)arrayList), string4, object, string5);
                arrayList2.add(stringArray);
            }
            if (RestrictedSecurity.isNullOrBlank(string3)) {
                this.providerConstraints.put(string, arrayList2);
            } else {
                if (bl) {
                    RestrictedSecurity.printStackTraceAndExit("Cannot append or remove constraints since the provider " + string + " wasn't in this position in the profile extended.");
                }
                if ((arrayList = this.providerConstraints.get(string)) == null) {
                    arrayList = new ArrayList<Constraint>();
                    this.providerConstraints.put(string, arrayList);
                }
                if (string3.equals("+")) {
                    arrayList.addAll(arrayList2);
                } else {
                    for (Constraint constraint : arrayList2) {
                        if (arrayList.remove(constraint)) continue;
                        RestrictedSecurity.printStackTraceAndExit("Constraint " + constraint + "is not part of existing constraints.");
                    }
                }
            }
            if (debug != null) {
                debug.println("\t\t\tSuccessfully loaded constraints for security provider: " + string);
            }
        }

        private void checkHashValues() {
            for (Map.Entry<String, String> entry : this.profilesHashes.entrySet()) {
                String[] stringArray;
                String string = entry.getKey();
                String string2 = entry.getValue();
                List<String> list = this.profilesInfo.get(string);
                if (debug != null) {
                    debug.println("Calculating hash for '" + string + "'.");
                }
                if ((stringArray = string2.split(":")).length != 2) {
                    RestrictedSecurity.printStackTraceAndExit("Incorrect definition of hash value for " + string);
                }
                String string3 = stringArray[0].trim();
                String string4 = stringArray[1].trim();
                try {
                    MessageDigest messageDigest = MessageDigest.getInstance(string3);
                    byte[] byArray = list.stream().sorted().collect(Collectors.joining("\n")).getBytes(StandardCharsets.UTF_8);
                    byte[] byArray2 = messageDigest.digest(byArray);
                    StringBuilder stringBuilder = new StringBuilder();
                    for (byte by : byArray2) {
                        stringBuilder.append(String.format("%02x", by & 0xFF));
                    }
                    Object object = stringBuilder.toString();
                    if (debug != null) {
                        debug.println("\tCalculated hash for '" + string + "': " + (String)object);
                        debug.println("\tExpected hash for '" + string + "': " + string4);
                    }
                    if (((String)object).equalsIgnoreCase(string4)) continue;
                    RestrictedSecurity.printStackTraceAndExit("Hex produced from profile is not the same is a base profile, so a hash value is mandatory.");
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    if (debug != null) {
                        debug.println("The hash algorithm specified for '" + string + "' is not available.");
                    }
                    RestrictedSecurity.printStackTraceAndExit(noSuchAlgorithmException);
                }
            }
        }

        private void listAvailableProfiles() {
            System.out.println();
            System.out.println("Restricted Security Available Profiles' Info:");
            System.out.println("=============================================");
            HashSet<String> hashSet = new HashSet<String>();
            Pattern pattern = Pattern.compile("^(RestrictedSecurity\\.\\S+)\\.desc\\.name");
            for (Object object : this.securityProps.keySet()) {
                String string;
                Matcher matcher;
                if (!(object instanceof String) || !(matcher = pattern.matcher(string = (String)object)).matches()) continue;
                hashSet.add(matcher.group(1));
            }
            System.out.println("The available Restricted Security profiles:\n");
            for (String string : hashSet) {
                this.printProfile(string);
            }
        }

        private void printProfile(String string) {
            Set<String> set = this.securityProps.stringPropertyNames();
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            ArrayList<String> arrayList3 = new ArrayList<String>();
            for (String string2 : set) {
                if (string2.startsWith(string + ".desc.") || string2.startsWith(string + ".fips.")) {
                    arrayList.add(string2 + this.securityProps.getProperty(string2));
                    continue;
                }
                if (string2.startsWith(string + ".jce.provider.")) {
                    arrayList2.add(string2 + this.securityProps.getProperty(string2));
                    continue;
                }
                if (!string2.startsWith(string)) continue;
                arrayList3.add(string2 + this.securityProps.getProperty(string2));
            }
            System.out.println(string + " Profile Info:");
            System.out.println("==========================================");
            for (String string2 : arrayList) {
                System.out.println(string2);
            }
            System.out.println();
            System.out.println(string + " Profile Providers:");
            System.out.println("===============================================");
            for (String string2 : arrayList2) {
                System.out.println(string2);
            }
            System.out.println();
            System.out.println(string + " Profile Restrictions:");
            System.out.println("==================================================");
            for (String string2 : arrayList3) {
                System.out.println(string2);
            }
            System.out.println();
        }

        private boolean setProperty(String string2, String string3, List<String> list) {
            if (debug != null) {
                debug.println("Setting property: " + string2);
            }
            String string4 = this.securityProps.getProperty(string3);
            string4 = ProfileParser.parseProperty(string4);
            String string5 = null;
            if (string4 != null) {
                list.add(string3 + "=" + string4);
                String string6 = this.getExistingValue(string2);
                if (string4.startsWith("+")) {
                    if (!ProfileParser.isPropertyAppendable(string2)) {
                        RestrictedSecurity.printStackTraceAndExit("Property '" + string2 + "' is not appendable.");
                    } else {
                        string4 = string4.substring(1).trim();
                        if (string6 == null) {
                            RestrictedSecurity.printStackTraceAndExit("Property '" + string2 + "' does not exist in parent profile or java.security file. Cannot append.");
                        } else {
                            string5 = RestrictedSecurity.isBlank(string6) ? string4 : (RestrictedSecurity.isBlank(string4) ? string6 : string6 + ", " + string4);
                        }
                    }
                } else if (string4.startsWith("-")) {
                    if (!ProfileParser.isPropertyAppendable(string2)) {
                        RestrictedSecurity.printStackTraceAndExit("Property '" + string2 + "' is not appendable.");
                    } else if (!RestrictedSecurity.isBlank(string4 = string4.substring(1).trim())) {
                        String[] stringArray;
                        if (string6 == null) {
                            RestrictedSecurity.printStackTraceAndExit("Property '" + string2 + "' does not exist in parent profile or java.security file. Cannot remove.");
                        }
                        List list2 = Stream.of(string6.split(",")).map(string -> string.trim()).collect(Collectors.toList());
                        for (String string7 : stringArray = string4.split(",")) {
                            if (list2.remove(string7.trim())) continue;
                            RestrictedSecurity.printStackTraceAndExit("Value '" + string7 + "' is not in existing values.");
                        }
                        string5 = String.join((CharSequence)",", list2);
                    } else if (string6 == null) {
                        RestrictedSecurity.printStackTraceAndExit("Property '" + string2 + "' does not exist in parent profile or java.security file. Cannot remove.");
                    } else {
                        string5 = RestrictedSecurity.isBlank(string6) ? string4 : string6;
                    }
                } else {
                    string5 = string4;
                }
                this.profileProperties.put(string2, string5);
                this.profileCheckPropertyNames.remove(string3);
                return true;
            }
            if (debug != null) {
                debug.println("Nothing to set. Value of property " + string2 + " is null.");
            }
            return false;
        }

        private String getProperty(String string) {
            return this.profileProperties.get(string);
        }

        private static boolean isPropertyAppendable(String string) {
            switch (string) {
                case "jdkCertpathDisabledAlgorithms": 
                case "jdkSecurityLegacyAlgorithms": 
                case "jdkTlsDisabledAlgorithms": 
                case "jdkTlsDisabledNamedCurves": 
                case "jdkTlsLegacyAlgorithms": {
                    return true;
                }
            }
            return false;
        }

        private static String parseProperty(String string) {
            if (string != null) {
                string = string.trim();
            }
            return string;
        }

        private static void checkProviderFormat(String string, boolean bl) {
            Pattern pattern = Pattern.compile("^([A-Za-z0-9.-]+)\\s*([A-Za-z0-9./\\\\${}]+)?\\s*(\\[\\s*([+-])?[A-Za-z0-9{}.=*|:$#,/_\\s-]+\\])?\\s*$");
            Matcher matcher = pattern.matcher(string);
            if (matcher.find()) {
                String string2 = matcher.group(1);
                if (string2.indexOf(46) <= 0) {
                    RestrictedSecurity.printStackTraceAndExit("Provider must be specified using the fully-qualified class name: " + string2);
                }
                String string3 = matcher.group(4);
                if (!bl && !RestrictedSecurity.isNullOrBlank(string3)) {
                    RestrictedSecurity.printStackTraceAndExit("Constraints of provider not previously specified cannot be modified: " + string2);
                }
            } else {
                RestrictedSecurity.printStackTraceAndExit("Provider format is incorrect: " + string);
            }
        }

        private void loadProfileCheck(String string) {
            Enumeration<?> enumeration = this.securityProps.propertyNames();
            String string2 = string + '.';
            while (enumeration.hasMoreElements()) {
                String string3 = (String)enumeration.nextElement();
                if (!string3.startsWith(string2)) continue;
                if (string3.contains(".jce.provider.")) {
                    this.profileCheckProviderNames.add(string3);
                    continue;
                }
                this.profileCheckPropertyNames.add(string3);
            }
        }

        private void checkProfileCheck(String string) {
            if (!this.profileCheckProviderNames.isEmpty()) {
                RestrictedSecurity.printStackTraceAndExit("The order numbers of providers in profile " + string + " (or a base profile) are not consecutive.");
            }
            if (!this.profileCheckPropertyNames.isEmpty()) {
                RestrictedSecurity.printStackTraceAndExit("The property names: " + this.profileCheckPropertyNames.stream().sorted().collect(Collectors.joining(", ")) + " in profile " + string + " (or a base profile) are not recognized.");
            }
        }
    }

    private static final class RestrictedSecurityProperties {
        private final String profileID;
        private final String descName;
        private final boolean descIsDefault;
        private final boolean descIsFIPS;
        private final String descNumber;
        private final String descPolicy;
        private final String descSunsetDate;
        private final String jdkTlsDisabledNamedCurves;
        private final String jdkTlsDisabledAlgorithms;
        private final String jdkTlsEphemeralDHKeySize;
        private final String jdkTlsLegacyAlgorithms;
        private final String jdkCertpathDisabledAlgorithms;
        private final String jdkSecurityLegacyAlgorithms;
        private final String keyStoreType;
        private final String keyStore;
        final String jdkSecureRandomAlgorithm;
        final String jdkFipsMode;
        private final List<String> providers;
        private final List<String> providersFullyQualifiedClassName;
        private final Map<String, Constraint[]> providerConstraints;

        private RestrictedSecurityProperties(String string, ProfileParser profileParser) {
            this.profileID = string;
            this.descName = profileParser.getProperty("descName");
            this.descIsDefault = profileParser.descIsDefault;
            this.descIsFIPS = profileParser.descIsFIPS;
            this.descNumber = profileParser.getProperty("descNumber");
            this.descPolicy = profileParser.getProperty("descPolicy");
            this.descSunsetDate = profileParser.getProperty("descSunsetDate");
            this.jdkTlsDisabledNamedCurves = profileParser.getProperty("jdkTlsDisabledNamedCurves");
            this.jdkTlsDisabledAlgorithms = profileParser.getProperty("jdkTlsDisabledAlgorithms");
            this.jdkTlsEphemeralDHKeySize = profileParser.getProperty("jdkTlsEphemeralDHKeySize");
            this.jdkTlsLegacyAlgorithms = profileParser.getProperty("jdkTlsLegacyAlgorithms");
            this.jdkCertpathDisabledAlgorithms = profileParser.getProperty("jdkCertpathDisabledAlgorithms");
            this.jdkSecurityLegacyAlgorithms = profileParser.getProperty("jdkSecurityLegacyAlgorithms");
            this.keyStoreType = profileParser.getProperty("keyStoreType");
            this.keyStore = profileParser.getProperty("keyStore");
            this.jdkSecureRandomAlgorithm = profileParser.getProperty("jdkSecureRandomAlgorithm");
            this.jdkFipsMode = profileParser.getProperty("jdkFipsMode");
            this.providers = new ArrayList<String>(profileParser.providers);
            this.providersFullyQualifiedClassName = new ArrayList<String>(profileParser.providersFullyQualifiedClassName);
            this.providerConstraints = profileParser.providerConstraints.entrySet().stream().collect(Collectors.toMap(entry -> (String)entry.getKey(), entry -> ((List)entry.getValue()).toArray(new Constraint[0])));
            if (debug != null) {
                this.listUsedProfile();
            }
        }

        boolean isRestrictedServiceAllowed(Provider.Service service, boolean bl) {
            Constraint[] constraintArray;
            Provider provider = service.getProvider();
            String string = provider.getClass().getName();
            if (debug != null) {
                debug.println("Checking service " + service.toString() + " offered by provider " + string + ".");
            }
            if ((constraintArray = this.providerConstraints.get(string)) == null) {
                if (debug != null) {
                    debug.println("Security constraints check. Disallow unknown provider: " + string);
                }
                return false;
            }
            if (constraintArray.length == 0) {
                if (debug != null) {
                    debug.println("No constraints for provider " + string + ".");
                }
                return true;
            }
            String string2 = service.getType();
            String string3 = service.getAlgorithm();
            if (debug != null) {
                debug.println("Security constraints check of provider.");
            }
            block8: for (Constraint constraint : constraintArray) {
                String[] stringArray;
                String string4 = constraint.type;
                String string5 = constraint.algorithm;
                String string6 = constraint.attributes;
                String string7 = constraint.acceptedUses;
                if (debug != null) {
                    debug.println("Checking provider constraint:\n\tService type: " + string4 + "\n\tAlgorithm: " + string5 + "\n\tAttributes: " + string6 + "\n\tAccepted uses: " + string7);
                }
                if (!RestrictedSecurity.isAsterisk(string4) && !string2.equalsIgnoreCase(string4)) {
                    if (debug == null) continue;
                    debug.println("The constraint doesn't apply to the service type.");
                    continue;
                }
                if (!RestrictedSecurity.isAsterisk(string5) && !string3.equalsIgnoreCase(string5)) {
                    if (debug == null) continue;
                    debug.println("The constraint doesn't apply to the service algorithm.");
                    continue;
                }
                if (!RestrictedSecurity.isAsterisk(string6)) {
                    stringArray = string6.split(":");
                    for (String string8 : stringArray) {
                        Object[] objectArray = string8.split("=", 2);
                        String string9 = ((String)objectArray[0]).trim();
                        String string10 = ((String)objectArray[1]).trim();
                        String string11 = service.getAttribute(string9);
                        if (debug != null) {
                            debug.println("Checking specific attribute with:\n\tName: " + string9 + "\n\tValue: " + string10 + "\nagainst the service attribute value: " + string11);
                        }
                        if (string11 == null || !string10.equalsIgnoreCase(string11)) {
                            if (debug == null) continue block8;
                            debug.println("Attributes don't match!");
                            debug.println("The following service:\n\tService type: " + string2 + "\n\tAlgorithm: " + string3 + "\n\tAttribute: " + string6 + "\nis NOT allowed in provider: " + string);
                            continue block8;
                        }
                        if (debug == null) continue;
                        debug.println("Attributes match!");
                    }
                }
                if (bl && string7 != null) {
                    stringArray = string7.split(":");
                    String string11 = stringArray[0];
                    String string12 = stringArray[1];
                    StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
                    boolean bl2 = false;
                    for (StackTraceElement stackTraceElement : stackTraceElementArray) {
                        if (debug != null) {
                            debug.println("Attempting to match " + stackTraceElement + " with: " + (String)string11 + " : " + string12);
                        }
                        String string13 = stackTraceElement.getClassName();
                        int n = string13.lastIndexOf(46);
                        String string14 = null;
                        if (n != -1) {
                            string14 = string13.substring(0, n);
                        }
                        switch (string11) {
                            case "FullClassName": {
                                bl2 = string13.equals(string12);
                                break;
                            }
                            case "Package": {
                                bl2 = string12.equals(string14);
                                break;
                            }
                            default: {
                                RestrictedSecurity.printStackTraceAndExit("Incorrect option to match in constraint: " + constraint);
                            }
                        }
                        if (bl2) break;
                    }
                    if (!bl2) {
                        if (debug == null) continue;
                        debug.println("Classes in call stack are not part of accepted uses!");
                        debug.println("The following service:\n\tService type: " + string2 + "\n\tAlgorithm: " + string3 + "\n\tAttribute: " + string6 + "\n\tAccepted uses: " + string7 + "\nis NOT allowed in provider: " + string);
                        continue;
                    }
                }
                if (debug != null) {
                    debug.println("All attributes matched!");
                    debug.println("The following service:\n\tService type: " + string2 + "\n\tAlgorithm: " + string3 + "\n\tAttribute: " + string6 + "\n\tAccepted uses: " + string7 + "\nis allowed in provider: " + string);
                }
                return true;
            }
            if (debug != null) {
                debug.println("Could not find a constraint to match.");
                debug.println("The following service:\n\tService type: " + string2 + "\n\tAlgorithm: " + string3 + "\nis NOT allowed in provider: " + string);
            }
            return false;
        }

        boolean isRestrictedProviderAllowed(String string) {
            if (debug != null) {
                debug.println("Checking the provider " + string + " in restricted security mode.");
            }
            if (this.providersFullyQualifiedClassName.contains(string)) {
                if (debug != null) {
                    debug.println("The provider " + string + " is allowed in restricted security mode.");
                }
                return true;
            }
            if (debug != null) {
                debug.println("The provider " + string + " is not allowed in restricted security mode.");
                debug.println("Stack trace:");
                StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
                for (int i = 1; i < stackTraceElementArray.length; ++i) {
                    StackTraceElement stackTraceElement = stackTraceElementArray[i];
                    debug.println("\tat " + stackTraceElement.getClassName() + "." + stackTraceElement.getMethodName() + "(" + stackTraceElement.getFileName() + ":" + stackTraceElement.getLineNumber() + ")");
                }
            }
            return false;
        }

        private void listUsedProfile() {
            System.out.println();
            System.out.println("Utilized Restricted Security Profile Info:");
            System.out.println("==========================================");
            System.out.println("The Restricted Security profile used is: " + this.profileID);
            System.out.println();
            System.out.println(this.profileID + " Profile Info:");
            System.out.println("==========================================");
            RestrictedSecurityProperties.printProperty(this.profileID + ".desc.name: ", this.descName);
            RestrictedSecurityProperties.printProperty(this.profileID + ".desc.default: ", "" + this.descIsDefault);
            RestrictedSecurityProperties.printProperty(this.profileID + ".desc.fips: ", "" + this.descIsFIPS);
            RestrictedSecurityProperties.printProperty(this.profileID + ".fips.mode: ", this.jdkFipsMode);
            RestrictedSecurityProperties.printProperty(this.profileID + ".desc.number: ", this.descNumber);
            RestrictedSecurityProperties.printProperty(this.profileID + ".desc.policy: ", this.descPolicy);
            RestrictedSecurityProperties.printProperty(this.profileID + ".desc.sunsetDate: ", this.descSunsetDate);
            System.out.println();
            System.out.println(this.profileID + " Profile Providers:");
            System.out.println("===============================================");
            for (int i = 0; i < this.providers.size(); ++i) {
                RestrictedSecurityProperties.printProperty(this.profileID + ".jce.provider." + (i + 1) + ": ", this.providers.get(i));
                String string = this.providersFullyQualifiedClassName.get(i);
                for (Constraint constraint : this.providerConstraints.get(string)) {
                    System.out.println("\t" + constraint.toString());
                }
            }
            System.out.println();
            System.out.println(this.profileID + " Profile Restrictions:");
            System.out.println("==================================================");
            RestrictedSecurityProperties.printProperty(this.profileID + ".tls.disabledNamedCurves: ", this.jdkTlsDisabledNamedCurves);
            RestrictedSecurityProperties.printProperty(this.profileID + ".tls.disabledAlgorithms: ", this.jdkTlsDisabledAlgorithms);
            RestrictedSecurityProperties.printProperty(this.profileID + ".tls.ephemeralDHKeySize: ", this.jdkTlsEphemeralDHKeySize);
            RestrictedSecurityProperties.printProperty(this.profileID + ".tls.legacyAlgorithms: ", this.jdkTlsLegacyAlgorithms);
            RestrictedSecurityProperties.printProperty(this.profileID + ".jce.certpath.disabledAlgorithms: ", this.jdkCertpathDisabledAlgorithms);
            RestrictedSecurityProperties.printProperty(this.profileID + ".jce.legacyAlgorithms: ", this.jdkSecurityLegacyAlgorithms);
            System.out.println();
            RestrictedSecurityProperties.printProperty(this.profileID + ".keystore.type: ", this.keyStoreType);
            RestrictedSecurityProperties.printProperty(this.profileID + ".javax.net.ssl.keyStore: ", this.keyStore);
            RestrictedSecurityProperties.printProperty(this.profileID + ".securerandom.algorithm: ", this.jdkSecureRandomAlgorithm);
            System.out.println();
        }

        private static void printProperty(String string, String string2) {
            if (string2 != null) {
                String string3 = string2.isEmpty() ? "EMPTY" : string2;
                System.out.println(string + string3);
            } else if (debug != null) {
                debug.println("Nothing to print. Value of property " + string + " is null.");
            }
        }
    }
}

