/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.IOException;
import java.security.AccessController;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import sun.nio.ch.AllocatedNativeObject;
import sun.nio.ch.FileDispatcherImpl;
import sun.nio.ch.IOUtil;
import sun.security.action.GetIntegerAction;

class EPollArrayWrapper {
    private static final int EPOLLIN = 1;
    private static final int EPOLL_CTL_ADD = 1;
    private static final int EPOLL_CTL_DEL = 2;
    private static final int EPOLL_CTL_MOD = 3;
    private static final int SIZE_EPOLLEVENT = EPollArrayWrapper.sizeofEPollEvent();
    private static final int EVENT_OFFSET = 0;
    private static final int DATA_OFFSET;
    private static final int FD_OFFSET;
    private static final int OPEN_MAX;
    private static final int NUM_EPOLLEVENTS;
    private static final byte KILLED = -1;
    private static final int INITIAL_PENDING_UPDATE_SIZE = 64;
    private static final int MAX_UPDATE_ARRAY_SIZE;
    private final int epfd;
    private final AllocatedNativeObject pollArray;
    private final long pollArrayAddress;
    private int outgoingInterruptFD;
    private int incomingInterruptFD;
    private int interruptedIndex;
    int updated;
    private final Object updateLock = new Object();
    private int updateCount;
    private int[] updateDescriptors = new int[64];
    private final byte[] eventsLow = new byte[MAX_UPDATE_ARRAY_SIZE];
    private Map<Integer, Byte> eventsHigh;
    private final BitSet registered = new BitSet();
    private boolean interrupted = false;

    EPollArrayWrapper() throws IOException {
        this.epfd = this.epollCreate();
        int n = NUM_EPOLLEVENTS * SIZE_EPOLLEVENT;
        this.pollArray = new AllocatedNativeObject(n, true);
        this.pollArrayAddress = this.pollArray.address();
        if (OPEN_MAX > MAX_UPDATE_ARRAY_SIZE) {
            this.eventsHigh = new HashMap<Integer, Byte>();
        }
    }

    void initInterrupt(int n, int n2) {
        this.outgoingInterruptFD = n2;
        this.incomingInterruptFD = n;
        this.epollCtl(this.epfd, 1, n, 1);
    }

    void putEventOps(int n, int n2) {
        int n3 = SIZE_EPOLLEVENT * n + 0;
        this.pollArray.putInt(n3, n2);
    }

    void putDescriptor(int n, int n2) {
        int n3 = SIZE_EPOLLEVENT * n + FD_OFFSET;
        this.pollArray.putInt(n3, n2);
    }

    int getEventOps(int n) {
        int n2 = SIZE_EPOLLEVENT * n + 0;
        return this.pollArray.getInt(n2);
    }

    int getDescriptor(int n) {
        int n2 = SIZE_EPOLLEVENT * n + FD_OFFSET;
        return this.pollArray.getInt(n2);
    }

    private boolean isEventsHighKilled(Integer n) {
        assert (n >= MAX_UPDATE_ARRAY_SIZE);
        Byte by = this.eventsHigh.get(n);
        return by != null && by == -1;
    }

    private void setUpdateEvents(int n, byte by, boolean bl) {
        if (n < MAX_UPDATE_ARRAY_SIZE) {
            if (this.eventsLow[n] != -1 || bl) {
                this.eventsLow[n] = by;
            }
        } else {
            Integer n2 = n;
            if (!this.isEventsHighKilled(n2) || bl) {
                this.eventsHigh.put(n2, by);
            }
        }
    }

    private byte getUpdateEvents(int n) {
        if (n < MAX_UPDATE_ARRAY_SIZE) {
            return this.eventsLow[n];
        }
        Byte by = this.eventsHigh.get(n);
        return by;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setInterest(int n, int n2) {
        Object object = this.updateLock;
        synchronized (object) {
            byte by;
            int n3 = this.updateDescriptors.length;
            if (this.updateCount == n3) {
                by = n3 + 64;
                int[] nArray = new int[by];
                System.arraycopy((Object)this.updateDescriptors, 0, (Object)nArray, 0, n3);
                this.updateDescriptors = nArray;
            }
            this.updateDescriptors[this.updateCount++] = n;
            by = (byte)n2;
            assert (by == n2 && by != -1);
            this.setUpdateEvents(n, by, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void add(int n) {
        Object object = this.updateLock;
        synchronized (object) {
            assert (!this.registered.get(n));
            this.setUpdateEvents(n, (byte)0, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(int n) {
        Object object = this.updateLock;
        synchronized (object) {
            this.setUpdateEvents(n, (byte)-1, false);
            if (this.registered.get(n)) {
                this.epollCtl(this.epfd, 2, n, 0);
                this.registered.clear(n);
            }
        }
    }

    void closeEPollFD() throws IOException {
        FileDispatcherImpl.closeIntFD(this.epfd);
        this.pollArray.free();
    }

    int poll(long l) throws IOException {
        this.updateRegistrations();
        this.updated = this.epollWait(this.pollArrayAddress, NUM_EPOLLEVENTS, l, this.epfd);
        for (int i = 0; i < this.updated; ++i) {
            if (this.getDescriptor(i) != this.incomingInterruptFD) continue;
            this.interruptedIndex = i;
            this.interrupted = true;
            break;
        }
        return this.updated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateRegistrations() {
        Object object = this.updateLock;
        synchronized (object) {
            for (int i = 0; i < this.updateCount; ++i) {
                int n = this.updateDescriptors[i];
                short s = this.getUpdateEvents(n);
                boolean bl = this.registered.get(n);
                int n2 = 0;
                if (s == -1) continue;
                if (bl) {
                    n2 = s != 0 ? 3 : 2;
                } else {
                    int n3 = n2 = s != 0 ? 1 : 0;
                }
                if (n2 == 0) continue;
                this.epollCtl(this.epfd, n2, n, s);
                if (n2 == 1) {
                    this.registered.set(n);
                    continue;
                }
                if (n2 != 2) continue;
                this.registered.clear(n);
            }
            this.updateCount = 0;
        }
    }

    public void interrupt() {
        EPollArrayWrapper.interrupt(this.outgoingInterruptFD);
    }

    public int interruptedIndex() {
        return this.interruptedIndex;
    }

    boolean interrupted() {
        return this.interrupted;
    }

    void clearInterrupted() {
        this.interrupted = false;
    }

    private native int epollCreate();

    private native void epollCtl(int var1, int var2, int var3, int var4);

    private native int epollWait(long var1, int var3, long var4, int var6) throws IOException;

    private static native int sizeofEPollEvent();

    private static native int offsetofData();

    private static native void interrupt(int var0);

    private static native void init();

    static {
        FD_OFFSET = DATA_OFFSET = EPollArrayWrapper.offsetofData();
        OPEN_MAX = IOUtil.fdLimit();
        NUM_EPOLLEVENTS = Math.min(OPEN_MAX, 8192);
        MAX_UPDATE_ARRAY_SIZE = AccessController.doPrivileged(new GetIntegerAction("sun.nio.ch.maxUpdateArraySize", Math.min(OPEN_MAX, 65536)));
        IOUtil.load();
        EPollArrayWrapper.init();
    }
}

