/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import sun.security.ssl.Alert;
import sun.security.ssl.HandshakeContext;
import sun.security.ssl.SSLConsumer;
import sun.security.ssl.SSLHandshake;
import sun.security.ssl.SignatureScheme;
import sun.security.ssl.TransportContext;

final class PostHandshakeContext
extends HandshakeContext {
    PostHandshakeContext(TransportContext transportContext) throws IOException {
        super(transportContext);
        if (!this.negotiatedProtocol.useTLS13PlusSpec()) {
            throw this.conContext.fatal(Alert.UNEXPECTED_MESSAGE, "Post-handshake not supported in " + this.negotiatedProtocol.name);
        }
        this.localSupportedSignAlgs = new ArrayList<SignatureScheme>(transportContext.conSession.getLocalSupportedSignatureSchemes());
        if (transportContext.sslConfig.isClientMode) {
            this.handshakeConsumers.putIfAbsent(SSLHandshake.KEY_UPDATE.id, SSLHandshake.KEY_UPDATE);
            this.handshakeConsumers.putIfAbsent(SSLHandshake.NEW_SESSION_TICKET.id, SSLHandshake.NEW_SESSION_TICKET);
        } else {
            this.handshakeConsumers.putIfAbsent(SSLHandshake.KEY_UPDATE.id, SSLHandshake.KEY_UPDATE);
        }
        this.handshakeFinished = true;
    }

    @Override
    void kickstart() throws IOException {
        SSLHandshake.kickstart(this);
    }

    @Override
    void dispatch(byte by, ByteBuffer byteBuffer) throws IOException {
        SSLConsumer sSLConsumer = (SSLConsumer)this.handshakeConsumers.get(by);
        if (sSLConsumer == null) {
            throw this.conContext.fatal(Alert.UNEXPECTED_MESSAGE, "Unexpected post-handshake message: " + SSLHandshake.nameOf(by));
        }
        try {
            sSLConsumer.consume(this, byteBuffer);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            throw this.conContext.fatal(Alert.UNEXPECTED_MESSAGE, "Unsupported post-handshake message: " + SSLHandshake.nameOf(by), unsupportedOperationException);
        }
        catch (BufferOverflowException | BufferUnderflowException runtimeException) {
            throw this.conContext.fatal(Alert.DECODE_ERROR, "Illegal handshake message: " + SSLHandshake.nameOf(by), runtimeException);
        }
    }

    static boolean isConsumable(TransportContext transportContext, byte by) {
        if (by == SSLHandshake.KEY_UPDATE.id) {
            return transportContext.protocolVersion.useTLS13PlusSpec();
        }
        if (by == SSLHandshake.NEW_SESSION_TICKET.id) {
            return transportContext.sslConfig.isClientMode;
        }
        return false;
    }
}

