/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview.heapdump.classic;

import com.ibm.jvm.dtfjview.heapdump.HeapDumpFormatter;
import com.ibm.jvm.dtfjview.heapdump.LongArrayReferenceIterator;
import com.ibm.jvm.dtfjview.heapdump.ReferenceIterator;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;

public class ClassicHeapDumpFormatter
extends HeapDumpFormatter {
    private static final String EOF_HEADER = "// EOF: Total 'Objects',Refs(null) :";
    private static final String BREAKDOWN_HEADER = "// Breakdown - Classes:";
    private static final String VERSION_HEADER = "// Version: ";
    private final BufferedWriter _out;
    private int _classCount = 0;
    private int _allObjectCount = 0;
    private int _objectArraysCount = 0;
    private int _primitiveArraysCount = 0;
    private int _referenceCount = 0;
    private int _nullReferenceCount = 0;
    private boolean _closed = false;
    private boolean is64bit = false;

    public ClassicHeapDumpFormatter(Writer writer, String string, boolean bl) throws IOException {
        super(string, bl);
        this._out = new BufferedWriter(writer);
        this.is64bit = bl;
        this.writeHeader();
    }

    private void writeHeader() throws IOException {
        this._out.write(VERSION_HEADER + this._version);
        this._out.newLine();
    }

    private void writeReferences(ReferenceIterator referenceIterator) throws IOException {
        if (referenceIterator == null) {
            return;
        }
        referenceIterator.reset();
        if (!referenceIterator.hasNext()) {
            this._out.write("\t");
            this._out.newLine();
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\t");
        boolean bl = true;
        while (referenceIterator.hasNext()) {
            Long l = referenceIterator.next();
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(" ");
            }
            stringBuffer.append(this.toHexString(l));
            ++this._referenceCount;
            if (l != 0L) continue;
            ++this._nullReferenceCount;
        }
        stringBuffer.append(" ");
        this._out.write(stringBuffer.toString());
        this._out.newLine();
    }

    private String toHexString(long l) {
        if (l == 0L) {
            return "0x0";
        }
        if (this.is64bit) {
            return "0x" + String.format("%016X", l);
        }
        return "0x" + String.format("%08X", l);
    }

    @Override
    public void addClass(long l, String string, long l2, int n, long l3, int n2, ReferenceIterator referenceIterator) throws IOException {
        this.checkClosed();
        this._out.write(this.toHexString(l) + " [" + n + "] CLS " + string);
        this._out.newLine();
        this.writeReferences(referenceIterator);
        ++this._classCount;
        ++this._allObjectCount;
    }

    private void checkClosed() {
        if (this._closed) {
            throw new UnsupportedOperationException("This dump has been closed");
        }
    }

    private void writeEntry(long l, long l2, String string, ReferenceIterator referenceIterator) throws IOException {
        this._out.write(this.toHexString(l) + " [" + l2 + "] OBJ " + string);
        this._out.newLine();
        this.writeReferences(referenceIterator);
        ++this._allObjectCount;
    }

    @Override
    public void addObject(long l, long l2, String string, int n, int n2, ReferenceIterator referenceIterator) throws IOException {
        this.checkClosed();
        this.writeEntry(l, n, string, referenceIterator);
    }

    private static ReferenceIterator addReference(final ReferenceIterator referenceIterator, final long l) {
        return new ReferenceIterator(){
            private boolean _returnedExtra = false;

            @Override
            public boolean hasNext() {
                if (this._returnedExtra) {
                    return referenceIterator.hasNext();
                }
                return true;
            }

            @Override
            public Long next() {
                if (this._returnedExtra) {
                    return referenceIterator.next();
                }
                this._returnedExtra = true;
                return l;
            }

            @Override
            public void reset() {
                referenceIterator.reset();
                this._returnedExtra = false;
            }
        };
    }

    @Override
    public void addObjectArray(long l, long l2, String string, long l3, String string2, long l4, int n, int n2, ReferenceIterator referenceIterator) throws IOException {
        this.checkClosed();
        this.writeEntry(l, l4, string, referenceIterator);
        ++this._objectArraysCount;
    }

    @Override
    public void addPrimitiveArray(long l, long l2, int n, long l3, int n2, int n3) throws IOException, IllegalArgumentException {
        this.checkClosed();
        LongArrayReferenceIterator longArrayReferenceIterator = new LongArrayReferenceIterator(new long[0]);
        this.writeEntry(l, l3, this.getPrimitiveArrayName(n), longArrayReferenceIterator);
        ++this._primitiveArraysCount;
    }

    private String getPrimitiveArrayName(int n) {
        switch (n) {
            case 0: {
                return "[Z";
            }
            case 1: {
                return "[C";
            }
            case 2: {
                return "[F";
            }
            case 3: {
                return "[D";
            }
            case 4: {
                return "[B";
            }
            case 5: {
                return "[S";
            }
            case 6: {
                return "[I";
            }
            case 7: {
                return "[J";
            }
        }
        throw new IllegalArgumentException("Unknown primitive type code: " + n);
    }

    @Override
    public void close() throws IOException {
        this.printBreakdown();
        this.printEOFSummary();
        this._out.close();
        this._closed = true;
    }

    private void printEOFSummary() throws IOException {
        StringBuffer stringBuffer = new StringBuffer(EOF_HEADER);
        stringBuffer.append(this._allObjectCount);
        stringBuffer.append(",");
        stringBuffer.append(this._referenceCount);
        stringBuffer.append("(");
        stringBuffer.append(this._nullReferenceCount);
        stringBuffer.append(")");
        this._out.write(stringBuffer.toString());
        this._out.newLine();
    }

    private void printBreakdown() throws IOException {
        int n = this._allObjectCount - this._primitiveArraysCount - this._objectArraysCount - this._classCount;
        StringBuffer stringBuffer = new StringBuffer(BREAKDOWN_HEADER);
        stringBuffer.append(this._classCount);
        stringBuffer.append(", Objects:");
        stringBuffer.append(n);
        stringBuffer.append(", ObjectArrays:");
        stringBuffer.append(this._objectArraysCount);
        stringBuffer.append(", PrimitiveArrays:");
        stringBuffer.append(this._primitiveArraysCount);
        this._out.write(stringBuffer.toString());
        this._out.newLine();
    }
}

