/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview.heapdump.portable;

import com.ibm.jvm.dtfjview.heapdump.portable.PortableHeapDumpRecord;
import java.io.DataOutput;
import java.io.IOException;

public class PrimitiveArrayRecord
extends PortableHeapDumpRecord {
    private final int _type;
    private final int _numberOfElements;
    private final int _hashCode;
    private final boolean _is64Bit;
    private final long _instanceSize;
    private final boolean _is32BitHash;

    public PrimitiveArrayRecord(long l, long l2, int n, int n2, int n3, boolean bl, long l3, boolean bl2) {
        super(l, l2, null);
        this._type = n;
        this._numberOfElements = n2;
        this._hashCode = n3;
        this._is64Bit = bl;
        this._instanceSize = l3;
        this._is32BitHash = bl2;
        if (n < 0 || n > 7) {
            throw new IllegalArgumentException("Unrecognised type code: " + n);
        }
    }

    @Override
    protected void writeHeapDump(DataOutput dataOutput) throws IOException {
        int n = 32;
        n = (byte)(n | this._type << 2);
        byte by = PortableHeapDumpRecord.sizeofReference(this._numberOfElements);
        byte by2 = by > this._gapSize ? by : this._gapSize;
        n = (byte)(n | by2);
        dataOutput.writeByte(n);
        this.writeReference(dataOutput, by2, this._gapPreceding);
        this.writeReference(dataOutput, by2, by);
        if (!this._is32BitHash) {
            dataOutput.writeShort(this._hashCode);
        }
        dataOutput.writeInt((int)(this._instanceSize / 4L));
    }
}

