/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.format;

import com.ibm.jvm.format.TraceFile;
import com.ibm.jvm.format.Util;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Vector;

public class StartupSection {
    private String eyecatcher_string;
    private int length;
    private int version;
    private int modification;
    private long options_offset;
    private long options_end;
    private TraceFile traceFile;
    private String[] startupOptions;

    public StartupSection(TraceFile traceFile, int n) throws IOException {
        this.traceFile = traceFile;
        traceFile.seek(n);
        this.eyecatcher_string = Util.convertAndCheckEyecatcher(traceFile.readI());
        this.length = traceFile.readI();
        this.version = traceFile.readI();
        this.modification = traceFile.readI();
        this.options_offset = traceFile.getFilePointer();
        this.options_end = n + this.length;
        Util.Debug.println("StartupSection: eyecatcher:        " + this.eyecatcher_string);
        Util.Debug.println("StartupSection: length:            " + this.length);
        Util.Debug.println("StartupSection: version:           " + this.version);
        Util.Debug.println("StartupSection: modification:      " + this.modification);
        this.startupOptions = this.readOptions(traceFile, this.options_offset);
    }

    private String[] readOptions(TraceFile traceFile, long l) throws IOException {
        String[] stringArray = null;
        Vector<String> vector = new Vector<String>();
        traceFile.seek(l);
        byte[] byArray = new byte[(int)(this.options_end - l)];
        Util.Debug.println("StartupSection: options_offset:        " + l);
        Util.Debug.println("StartupSection: options_end:           " + this.options_end);
        int n = 0;
        traceFile.read(byArray);
        for (n = 0; n < byArray.length; ++n) {
            StringBuffer stringBuffer = new StringBuffer();
            while (byArray[n] != 0) {
                stringBuffer.append((char)byArray[n]);
                ++n;
            }
            if (stringBuffer.length() == 0) break;
            String string = stringBuffer.toString();
            vector.add(string);
        }
        stringArray = new String[vector.size()];
        for (n = 0; n < vector.size(); ++n) {
            stringArray[n] = (String)vector.elementAt(n);
        }
        return stringArray;
    }

    protected void summary(BufferedWriter bufferedWriter) throws IOException {
        bufferedWriter.write("JVM Start-up Params :");
        bufferedWriter.newLine();
        for (int i = 0; i < this.startupOptions.length; ++i) {
            bufferedWriter.write(this.startupOptions[i]);
            bufferedWriter.newLine();
        }
        bufferedWriter.newLine();
    }

    protected String[] getStartUpOptions() {
        return this.startupOptions;
    }
}

