/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.transport.tcp;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import sun.rmi.transport.tcp.ConnectionMultiplexer;
import sun.rmi.transport.tcp.MultiplexConnectionInfo;

final class MultiplexInputStream
extends InputStream {
    private ConnectionMultiplexer manager;
    private MultiplexConnectionInfo info;
    private byte[] buffer;
    private int present = 0;
    private int pos = 0;
    private int requested = 0;
    private boolean disconnected = false;
    private Object lock = new Object();
    private int waterMark;
    private byte[] temp = new byte[1];

    MultiplexInputStream(ConnectionMultiplexer connectionMultiplexer, MultiplexConnectionInfo multiplexConnectionInfo, int n) {
        this.manager = connectionMultiplexer;
        this.info = multiplexConnectionInfo;
        this.buffer = new byte[n];
        this.waterMark = n / 2;
    }

    @Override
    public synchronized int read() throws IOException {
        int n = this.read(this.temp, 0, 1);
        if (n != 1) {
            return -1;
        }
        return this.temp[0] & 0xFF;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        if (n2 <= 0) {
            return 0;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.pos >= this.present) {
                this.present = 0;
                this.pos = 0;
            } else if (this.pos >= this.waterMark) {
                System.arraycopy((Object)this.buffer, this.pos, (Object)this.buffer, 0, this.present - this.pos);
                this.present -= this.pos;
                this.pos = 0;
            }
            int n4 = this.buffer.length - this.present;
            n3 = Math.max(n4 - this.requested, 0);
        }
        if (n3 > 0) {
            this.manager.sendRequest(this.info, n3);
        }
        object = this.lock;
        synchronized (object) {
            this.requested += n3;
            while (this.pos >= this.present && !this.disconnected) {
                try {
                    this.lock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this.disconnected && this.pos >= this.present) {
                return -1;
            }
            int n5 = this.present - this.pos;
            if (n2 < n5) {
                System.arraycopy((Object)this.buffer, this.pos, (Object)byArray, n, n2);
                this.pos += n2;
                return n2;
            }
            System.arraycopy((Object)this.buffer, this.pos, (Object)byArray, n, n5);
            this.present = 0;
            this.pos = 0;
            return n5;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int available() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            return this.present - this.pos;
        }
    }

    @Override
    public void close() throws IOException {
        this.manager.sendClose(this.info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void receive(int n, DataInputStream dataInputStream) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.pos > 0 && this.buffer.length - this.present < n) {
                System.arraycopy((Object)this.buffer, this.pos, (Object)this.buffer, 0, this.present - this.pos);
                this.present -= this.pos;
                this.pos = 0;
            }
            if (this.buffer.length - this.present < n) {
                throw new IOException("Receive buffer overflow");
            }
            dataInputStream.readFully(this.buffer, this.present, n);
            this.present += n;
            this.requested -= n;
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void disconnect() {
        Object object = this.lock;
        synchronized (object) {
            this.disconnected = true;
            this.lock.notifyAll();
        }
    }
}

