/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.lang.management.internal;

import com.ibm.java.lang.management.internal.ManagementUtils;
import java.lang.ref.SoftReference;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;

public final class StackTraceElementUtil {
    private static CompositeType compositeType;
    private static SoftReference<String[]> methodNameCache;
    private static SoftReference<String[]> returnTypeCache;

    public static StackTraceElement from(CompositeData compositeData) {
        return StackTraceElementUtil.fromArray(new CompositeData[]{compositeData})[0];
    }

    private static String[] getMethodNames() {
        String[] stringArray = null;
        if (null != methodNameCache) {
            stringArray = methodNameCache.get();
        }
        if (null == stringArray) {
            stringArray = new String[]{"className", "methodName", "fileName", "lineNumber", "nativeMethod"};
            methodNameCache = new SoftReference<String[]>(stringArray);
        }
        return stringArray;
    }

    private static String[] getMethodReturnTypeNames() {
        String[] stringArray = null;
        if (null != returnTypeCache) {
            stringArray = returnTypeCache.get();
        }
        if (null == stringArray) {
            stringArray = new String[]{"java.lang.String", "java.lang.String", "java.lang.String", "java.lang.Integer", "java.lang.Boolean"};
        }
        returnTypeCache = new SoftReference<String[]>(stringArray);
        return stringArray;
    }

    private static Object[] getValues(StackTraceElement stackTraceElement) {
        Object[] objectArray = new Object[]{stackTraceElement.getClassName(), stackTraceElement.getMethodName(), stackTraceElement.getFileName(), stackTraceElement.getLineNumber(), stackTraceElement.isNativeMethod()};
        return objectArray;
    }

    public static StackTraceElement[] fromArray(CompositeData[] compositeDataArray) {
        if (compositeDataArray == null) {
            return null;
        }
        String[] stringArray = StackTraceElementUtil.getMethodNames();
        String[] stringArray2 = StackTraceElementUtil.getMethodReturnTypeNames();
        int n = compositeDataArray.length;
        StackTraceElement[] stackTraceElementArray = new StackTraceElement[n];
        for (int i = 0; i < n; ++i) {
            StackTraceElement stackTraceElement;
            CompositeData compositeData = compositeDataArray[i];
            if (compositeData == null) {
                stackTraceElementArray[i] = null;
                continue;
            }
            ManagementUtils.verifyFieldNumber(compositeData, stringArray.length);
            ManagementUtils.verifyFieldNames(compositeData, stringArray);
            ManagementUtils.verifyFieldTypes(compositeData, stringArray, stringArray2);
            Object[] objectArray = compositeData.getAll(stringArray);
            String string = (String)objectArray[0];
            String string2 = (String)objectArray[1];
            String string3 = (String)objectArray[2];
            int n2 = (Integer)objectArray[3];
            boolean bl = (Boolean)objectArray[4];
            stackTraceElementArray[i] = stackTraceElement = new StackTraceElement(string, string2, string3, n2);
        }
        return stackTraceElementArray;
    }

    public static CompositeType getCompositeType() {
        block3: {
            if (compositeType == null) {
                String[] stringArray = StackTraceElementUtil.getMethodNames();
                String[] stringArray2 = StackTraceElementUtil.getMethodNames();
                OpenType[] openTypeArray = new OpenType[]{SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.INTEGER, SimpleType.BOOLEAN};
                try {
                    compositeType = new CompositeType(StackTraceElement.class.getName(), StackTraceElement.class.getName(), stringArray, stringArray2, openTypeArray);
                }
                catch (OpenDataException openDataException) {
                    if (!ManagementUtils.VERBOSE_MODE) break block3;
                    openDataException.printStackTrace(System.err);
                }
            }
        }
        return compositeType;
    }

    public static CompositeData toCompositeData(StackTraceElement stackTraceElement) {
        CompositeDataSupport compositeDataSupport;
        block3: {
            compositeDataSupport = null;
            if (stackTraceElement != null) {
                CompositeType compositeType = StackTraceElementUtil.getCompositeType();
                String[] stringArray = StackTraceElementUtil.getMethodNames();
                Object[] objectArray = StackTraceElementUtil.getValues(stackTraceElement);
                try {
                    compositeDataSupport = new CompositeDataSupport(compositeType, stringArray, objectArray);
                }
                catch (OpenDataException openDataException) {
                    if (!ManagementUtils.VERBOSE_MODE) break block3;
                    openDataException.printStackTrace(System.err);
                }
            }
        }
        return compositeDataSupport;
    }

    private StackTraceElementUtil() {
    }

    static {
        methodNameCache = null;
        returnTypeCache = null;
    }
}

