/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview.commands.xcommands;

import com.ibm.java.diagnostics.utils.IContext;
import com.ibm.java.diagnostics.utils.commands.CommandException;
import com.ibm.jvm.dtfjview.commands.BaseJdmpviewCommand;
import java.io.PrintStream;
import java.util.Properties;

public abstract class XCommand
extends BaseJdmpviewCommand {
    protected int argUnitSize = 1;
    protected int argUnitNumber = 1;
    protected String argDisplayFormat = "";

    public boolean recognises(String string, IContext iContext) {
        if (string.length() < 3) {
            return false;
        }
        return string.toLowerCase().startsWith("x/");
    }

    public void run(String string, String[] stringArray, IContext iContext, PrintStream printStream) throws CommandException {
        if (this.initCommand(string, stringArray, iContext, printStream)) {
            return;
        }
        if (string.length() > 3) {
            String string2 = string.substring(2, string.length());
            this.parseArgs(string2);
        }
        this.doCommand(stringArray);
    }

    protected abstract void doCommand(String[] var1);

    protected void parseArgs(String string) {
        char c;
        int n;
        Character c2;
        Character c3;
        int n2;
        if (null == string || string.equals("")) {
            n2 = 1;
            c3 = this.getDefaultUnitSize(this.ctx.getProperties());
            c2 = this.getDefaultDisplayFormat(this.ctx.getProperties());
        } else {
            n2 = 0;
            for (n = 0; n < string.length() && Character.isDigit(string.charAt(n)); ++n) {
                n2 *= 10;
                n2 += Character.getNumericValue(string.charAt(n));
            }
            if (0 == n2) {
                n2 = 1;
            }
            c2 = null;
            c3 = null;
            if (n < string.length()) {
                c = string.charAt(n);
                switch (c) {
                    case 'b': 
                    case 'g': 
                    case 'h': 
                    case 'w': {
                        c3 = Character.valueOf(c);
                        break;
                    }
                    default: {
                        c2 = Character.valueOf(c);
                    }
                }
                ++n;
            }
            if (n < string.length()) {
                c = string.charAt(n);
                switch (c) {
                    case 'b': 
                    case 'g': 
                    case 'h': 
                    case 'w': {
                        if (null == c3) {
                            c3 = Character.valueOf(c);
                            break;
                        }
                        this.out.println("first letter after \"x/\" was a unit size character; second letter (if specified) must be a display format letter but it was also a unit size character");
                        return;
                    }
                    default: {
                        if (null == c2) {
                            c2 = Character.valueOf(c);
                            break;
                        }
                        this.out.println("first letter after \"x/\" was a display format character; second letter (if specified) must be a unit size letter but it was also a display format character");
                        return;
                    }
                }
                ++n;
            }
            if (string.length() != n) {
                this.out.println("too many letters after \"x/\"; the \"x/\" command accepts at most two letters, a display format character and a unit size character");
                return;
            }
            if (null == c3) {
                c3 = this.getDefaultUnitSize(this.ctx.getProperties());
            } else {
                this.setDefaultUnitSize(this.ctx.getProperties(), c3);
            }
            if (null == c2) {
                c2 = this.getDefaultDisplayFormat(this.ctx.getProperties());
            } else {
                this.setDefaultDisplayFormat(this.ctx.getProperties(), c2);
            }
        }
        n = 1;
        c = c3.charValue();
        switch (c) {
            default: {
                n = 1;
                break;
            }
            case 'h': {
                n = 2;
                break;
            }
            case 'w': {
                n = 4;
                break;
            }
            case 'g': {
                n = 8;
            }
        }
        this.argUnitSize = n;
        this.argUnitNumber = n2;
        this.argDisplayFormat = c2.toString();
    }

    private Character getDefaultUnitSize(Properties properties) {
        Character c = (Character)properties.get("x_default_unit_size");
        if (null == c) {
            return Character.valueOf('w');
        }
        return c;
    }

    private Character getDefaultDisplayFormat(Properties properties) {
        Character c = (Character)properties.get("x_default_display_format");
        if (null == c) {
            return Character.valueOf('x');
        }
        return c;
    }

    private void setDefaultUnitSize(Properties properties, Character c) {
        properties.put("x_default_unit_size", c);
    }

    private void setDefaultDisplayFormat(Properties properties, Character c) {
        properties.put("x_default_display_format", c);
    }

    @Override
    public void printDetailedHelp(PrintStream printStream) {
        printStream.println("works like \"x/\" in gdb (including use of defaults): passes number of items to display and unit size ('b' for byte, 'h' for halfword, 'w' for word, 'g' for giant word) to sub-command (ie. x/12bd)");
    }
}

