/*
 * Decompiled with CFR 0.152.
 */
package javax.sound.midi;

import javax.sound.midi.InvalidMidiDataException;

public abstract class MidiMessage
implements Cloneable {
    protected byte[] data;
    protected int length = 0;

    protected MidiMessage(byte[] byArray) {
        this.data = byArray;
        if (byArray != null) {
            this.length = byArray.length;
        }
    }

    protected void setMessage(byte[] byArray, int n) throws InvalidMidiDataException {
        if (n < 0 || n > 0 && n > byArray.length) {
            throw new IndexOutOfBoundsException("length out of bounds: " + n);
        }
        this.length = n;
        if (this.data == null || this.data.length < this.length) {
            this.data = new byte[this.length];
        }
        System.arraycopy((Object)byArray, 0, (Object)this.data, 0, n);
    }

    public byte[] getMessage() {
        byte[] byArray = new byte[this.length];
        System.arraycopy((Object)this.data, 0, (Object)byArray, 0, this.length);
        return byArray;
    }

    public int getStatus() {
        if (this.length > 0) {
            return this.data[0] & 0xFF;
        }
        return 0;
    }

    public int getLength() {
        return this.length;
    }

    public abstract Object clone();
}

