/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.format;

import com.ibm.jvm.format.Message;
import com.ibm.jvm.format.TraceFormat;
import com.ibm.jvm.format.Util;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Hashtable;

public final class MessageFile
extends File {
    private BufferedReader reader;
    private String component;
    private String formatName;
    protected static float verMod;
    private static boolean first;
    private static Hashtable messages;
    private static final String fromDATFile = ".definedInDatFile";
    static int counter;
    static String savedComponentName;

    public MessageFile(String string) throws IOException {
        super(string);
        this.formatName = string;
        this.reader = new BufferedReader(new InputStreamReader(new FileInputStream(this)));
        first = true;
        this.read();
    }

    public float getVersion() {
        return verMod;
    }

    protected static final void initStatics() {
        verMod = 0.0f;
        first = true;
        messages = null;
    }

    private void read() throws IOException {
        String string = this.reader.readLine();
        while (string != null) {
            this.addMessage(string);
            string = this.reader.readLine();
        }
    }

    protected void addMessage(String string) {
        int n = string.indexOf(" ");
        int n2 = string.indexOf(" ", n + 1);
        int n3 = string.indexOf(" ", n2 + 1);
        String string2 = null;
        int n4 = -1;
        String string3 = null;
        String string4 = null;
        if (n == -1 || n2 == -1 || n3 == -1) {
            if (first) {
                first = false;
                verMod = string.equals("dg") ? 1.0f : Float.valueOf(string).floatValue();
                if (verMod < TraceFormat.verMod) {
                    TraceFormat.outStream.println(this.formatName + " (Version " + verMod + ") does not match this trace file (Version " + TraceFormat.verMod + ")");
                }
                return;
            }
            this.component = string;
            return;
        }
        if (verMod >= 5.0f) {
            int n5;
            int n6 = string.indexOf(" ", n3 + 1);
            string2 = new String(string.substring(0, n));
            if (verMod >= 5.1f && (n5 = string2.indexOf(46)) != -1) {
                String string5 = string2.substring(0, n5);
                String string6 = string2.substring(n5 + 1);
                n4 = Integer.parseInt(string6);
                string2 = string5;
            }
            if (messages == null) {
                messages = new Hashtable();
            }
            if (savedComponentName == null || !string2.equals(savedComponentName)) {
                String string7 = string2 + fromDATFile;
                messages.put(string7, fromDATFile);
                savedComponentName = string2;
                counter = 0;
            }
            n5 = counter++;
            if (n4 >= 0) {
                n5 = n4;
            }
            int n7 = Integer.parseInt(string.substring(n + 1, n2));
            int n8 = string.indexOf(" ", n6 + 1);
            int n9 = string.indexOf(" ", n8 + 1);
            string3 = string.substring(n8 + 1, n9);
            string4 = string.substring(n9 + 2, string.length() - 1);
            Message message = new Message(n7, string4, this.component, string3);
            String string8 = string2 + "." + n5;
            if (messages.containsKey(string8)) {
                System.err.println("Duplicate messages in .dat files: " + string8);
            } else {
                messages.put(string8, message);
            }
        } else {
            int n10 = Integer.parseInt(string.substring(0, n), 16);
            int n11 = Integer.parseInt(string.substring(n + 1, n2));
            if (verMod < 1.2f) {
                string3 = string.substring(n2 + 1, n3);
                string4 = string.substring(n3 + 2, string.length() - 1);
            } else {
                int n12 = string.indexOf(" ", n3 + 1);
                int n13 = string.indexOf(" ", n12 + 1);
                int n14 = string.indexOf(" ", n13 + 1);
                string3 = string.substring(n13 + 1, n14);
                string4 = string.substring(n14 + 2, string.length() - 1);
            }
            Message message = new Message(n11, string4, this.component, string3);
            if (messages == null) {
                messages = new Hashtable();
            }
            messages.put(n10, message);
        }
    }

    protected static Message getMessageFromID(int n) {
        if ((double)verMod >= 5.0) {
            TraceFormat.outStream.println("Trying to retrieve an old style message (" + Util.formatAsHexString(n) + ") from 5.0 or newer message file");
            return null;
        }
        if (messages == null) {
            messages = new Hashtable();
        }
        return (Message)messages.get(n);
    }

    protected static Message getMessageFromID(String string, int n) {
        String string2;
        Message message;
        if ((double)verMod < 5.0) {
            TraceFormat.outStream.println("Trying to retrieve a new style message (" + string + "." + n + ") from 1.1 or older message file");
            return null;
        }
        if (messages == null) {
            messages = new Hashtable();
        }
        if ((message = (Message)messages.get(string2 = new String(string + "." + n))) == null) {
            if (MessageFile.componentIsFromDATFile(string)) {
                TraceFormat.outStream.println("Error: " + string + "." + n + " not in dat file: dat files old or from incorrect VM.");
                message = new Message(14, "This tracepoint's format string was not available in dat file.", string, " ");
            } else {
                message = new Message(13, "%s", string, "%s");
            }
            messages.put(string2, message);
        }
        return message;
    }

    public static boolean componentIsFromDATFile(String string) {
        String string2 = string + fromDATFile;
        return messages != null && messages.containsKey(string2);
    }

    static {
        counter = 0;
        savedComponentName = null;
    }
}

