/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.j9.gc;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.events.EventManager;
import com.ibm.j9ddr.vm29.j9.gc.CorruptFreeEntryException;
import com.ibm.j9ddr.vm29.j9.gc.GCFreeListHeapIterator;
import com.ibm.j9ddr.vm29.j9.gc.GCFreeListIteratorAggregatedCellList;
import com.ibm.j9ddr.vm29.j9.gc.GCHeapLinkedFreeHeader;
import com.ibm.j9ddr.vm29.j9.gc.GCHeapRegionDescriptor;
import com.ibm.j9ddr.vm29.j9.gc.GCMemoryPool;
import com.ibm.j9ddr.vm29.pointer.generated.MM_MemoryPoolAggregatedCellListPointer;
import com.ibm.j9ddr.vm29.pointer.generated.MM_MemoryPoolPointer;

public class GCMemoryPoolAggregatedCellList
extends GCMemoryPool {
    protected MM_MemoryPoolAggregatedCellListPointer _memoryPool = null;

    protected GCMemoryPoolAggregatedCellList(GCHeapRegionDescriptor gCHeapRegionDescriptor, MM_MemoryPoolPointer mM_MemoryPoolPointer) throws CorruptDataException {
        super(gCHeapRegionDescriptor, mM_MemoryPoolPointer);
        this.init(gCHeapRegionDescriptor);
    }

    private void init(GCHeapRegionDescriptor gCHeapRegionDescriptor) throws CorruptDataException {
        this._region = gCHeapRegionDescriptor;
        this._memoryPoolType = GCMemoryPool.MemoryPoolType.SEGREGATED;
        this._memoryPool = MM_MemoryPoolAggregatedCellListPointer.cast(gCHeapRegionDescriptor.getMemoryPool());
    }

    public GCHeapLinkedFreeHeader getFirstFreeEntry() throws CorruptDataException {
        return GCHeapLinkedFreeHeader.fromLinkedFreeHeaderPointer(this._memoryPool._freeListHead());
    }

    public GCFreeListHeapIterator freeListIterator() throws CorruptDataException {
        return new GCFreeListIteratorAggregatedCellList(this);
    }

    @Override
    public void checkFreeListsImpl() {
        try {
            GCFreeListHeapIterator gCFreeListHeapIterator = this.freeListIterator();
            GCHeapLinkedFreeHeader gCHeapLinkedFreeHeader = null;
            while (gCFreeListHeapIterator.hasNext()) {
                GCHeapLinkedFreeHeader gCHeapLinkedFreeHeader2 = gCFreeListHeapIterator.next();
                try {
                    this.freeEntryCheck(gCHeapLinkedFreeHeader2, gCHeapLinkedFreeHeader);
                    gCHeapLinkedFreeHeader = gCHeapLinkedFreeHeader2;
                }
                catch (CorruptFreeEntryException corruptFreeEntryException) {
                    EventManager.raiseCorruptDataEvent("Free list corruption detected", corruptFreeEntryException, false);
                }
                catch (CorruptDataException corruptDataException) {
                    EventManager.raiseCorruptDataEvent("Corruption detected in free entry", corruptDataException, false);
                }
            }
        }
        catch (CorruptDataException corruptDataException) {
            EventManager.raiseCorruptDataEvent("Data corruption detected while validating freelists", corruptDataException, false);
        }
    }

    private void freeEntryCheck(GCHeapLinkedFreeHeader gCHeapLinkedFreeHeader, GCHeapLinkedFreeHeader gCHeapLinkedFreeHeader2) throws CorruptFreeEntryException, CorruptDataException {
        this.freeEntryCheckGeneric(gCHeapLinkedFreeHeader);
        if (gCHeapLinkedFreeHeader2 != null && gCHeapLinkedFreeHeader2.getHeader().lte(gCHeapLinkedFreeHeader.getHeader())) {
            throw new CorruptFreeEntryException("invalidOrdering", gCHeapLinkedFreeHeader.getHeader());
        }
    }
}

