/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.j9;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.j9.J9ThreadMonitorHelper;
import com.ibm.j9ddr.vm29.j9.MonitorTableList;
import com.ibm.j9ddr.vm29.j9.ObjectMonitor;
import com.ibm.j9ddr.vm29.j9.gc.GCVMThreadListIterator;
import com.ibm.j9ddr.vm29.pointer.ObjectMonitorReferencePointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm29.pointer.generated.J9ObjectMonitorPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ThreadAbstractMonitorPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ThreadPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9VMThreadPointer;
import com.ibm.j9ddr.vm29.pointer.generated.OmrBuildFlags;
import com.ibm.j9ddr.vm29.pointer.helper.J9ObjectHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9ThreadHelper;
import com.ibm.j9ddr.vm29.structure.J9Consts;
import com.ibm.j9ddr.vm29.structure.J9Object;
import com.ibm.j9ddr.vm29.types.IDATA;
import com.ibm.j9ddr.vm29.types.UDATA;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

class ObjectMonitor_V1
extends ObjectMonitor {
    private static HashMap<J9ObjectPointer, List<J9VMThreadPointer>> blockedThreadsCache;
    private J9VMThreadPointer owner;
    private long count;
    private boolean isInflated;
    private J9ObjectMonitorPointer lockword;
    private J9ThreadAbstractMonitorPointer monitor;
    private ArrayList<J9VMThreadPointer> waitingThreads;
    private ArrayList<J9VMThreadPointer> blockedThreads;
    private boolean ownerAndCountInitialized = false;
    private J9ObjectMonitorPointer j9objectMonitor;
    private J9ObjectPointer object;

    protected ObjectMonitor_V1(J9ObjectPointer j9ObjectPointer) throws CorruptDataException {
        this.object = j9ObjectPointer;
        this.j9objectMonitor = MonitorTableList.peek(j9ObjectPointer);
        this.initializeLockword();
    }

    @Override
    public J9ObjectPointer getObject() {
        return this.object;
    }

    @Override
    public J9ObjectMonitorPointer getLockword() {
        return this.lockword;
    }

    @Override
    public J9ThreadAbstractMonitorPointer getInflatedMonitor() {
        return this.monitor;
    }

    @Override
    public J9ObjectMonitorPointer getJ9ObjectMonitorPointer() {
        return this.j9objectMonitor;
    }

    @Override
    public J9VMThreadPointer getOwner() throws CorruptDataException {
        if (!this.ownerAndCountInitialized) {
            this.initializeOwnerAndCount();
        }
        return this.owner;
    }

    @Override
    public long getCount() throws CorruptDataException {
        if (!this.ownerAndCountInitialized) {
            this.initializeOwnerAndCount();
        }
        return this.count;
    }

    @Override
    public boolean isInflated() {
        return this.isInflated;
    }

    @Override
    public boolean isInTable() {
        return this.j9objectMonitor.notNull();
    }

    @Override
    public List<J9VMThreadPointer> getWaitingThreads() throws CorruptDataException {
        if (this.waitingThreads == null) {
            this.initializeWaitingThreads();
        }
        return this.waitingThreads;
    }

    @Override
    public List<J9VMThreadPointer> getBlockedThreads() throws CorruptDataException {
        if (this.blockedThreads == null) {
            this.initializeBlockedThreads();
        }
        return this.blockedThreads;
    }

    @Override
    public boolean isContended() throws CorruptDataException {
        if (this.isInflated) {
            return this.getBlockedThreads().size() > 0;
        }
        return this.lockword.allBitsIn(J9Object.OBJECT_HEADER_LOCK_FLC);
    }

    private void initializeOwnerAndCount() throws CorruptDataException {
        if (this.isInflated) {
            J9ThreadPointer j9ThreadPointer = this.monitor.owner();
            if (j9ThreadPointer.notNull()) {
                this.owner = J9ThreadHelper.getVMThread(j9ThreadPointer);
                this.count = this.monitor.count().longValue();
                if (this.count == 0L) {
                    this.owner = J9VMThreadPointer.NULL;
                }
            } else {
                this.owner = J9VMThreadPointer.NULL;
            }
        } else {
            this.owner = J9VMThreadPointer.cast(this.lockword.untag(J9Object.OBJECT_HEADER_LOCK_BITS_MASK));
            if (this.owner.notNull()) {
                UDATA uDATA = UDATA.cast(this.lockword).bitAnd(J9Object.OBJECT_HEADER_LOCK_BITS_MASK).rightShift((int)J9Object.OBJECT_HEADER_LOCK_RECURSION_OFFSET);
                if (J9BuildFlags.J9VM_THR_LOCK_RESERVATION) {
                    if (!this.lockword.allBitsIn(J9Object.OBJECT_HEADER_LOCK_RESERVED)) {
                        uDATA = uDATA.add(1L);
                    }
                    this.count = uDATA.longValue();
                } else {
                    this.count = uDATA.add(1L).longValue();
                }
                if (this.count == 0L) {
                    this.owner = J9VMThreadPointer.NULL;
                }
            }
        }
        this.ownerAndCountInitialized = true;
    }

    private void initializeWaitingThreads() throws CorruptDataException {
        this.waitingThreads = new ArrayList();
        if (!this.isInflated) {
            return;
        }
        J9ThreadPointer j9ThreadPointer = this.monitor.waiting();
        while (j9ThreadPointer.notNull()) {
            J9VMThreadPointer j9VMThreadPointer = J9ThreadHelper.getVMThread(j9ThreadPointer);
            if (j9VMThreadPointer.notNull()) {
                this.waitingThreads.add(j9VMThreadPointer);
            }
            j9ThreadPointer = j9ThreadPointer.next();
        }
    }

    private void initializeBlockedThreads() throws CorruptDataException {
        this.blockedThreads = new ArrayList();
        if (this.isInflated) {
            if (OmrBuildFlags.OMR_THR_THREE_TIER_LOCKING) {
                J9ThreadPointer j9ThreadPointer = J9ThreadMonitorHelper.getBlockingField(this.monitor);
                while (j9ThreadPointer.notNull()) {
                    J9VMThreadPointer j9VMThreadPointer = J9ThreadHelper.getVMThread(j9ThreadPointer);
                    if (j9VMThreadPointer.notNull()) {
                        this.blockedThreads.add(j9VMThreadPointer);
                    }
                    j9ThreadPointer = j9ThreadPointer.next();
                }
            } else {
                List<J9VMThreadPointer> list = ObjectMonitor_V1.getBlockedThreads(this.object);
                if (list != null) {
                    this.blockedThreads.addAll(list);
                }
            }
        } else {
            List<J9VMThreadPointer> list = ObjectMonitor_V1.getBlockedThreads(this.object);
            if (list != null) {
                this.blockedThreads.addAll(list);
            }
        }
    }

    private void initializeLockword() throws CorruptDataException {
        this.lockword = J9ObjectMonitorPointer.NULL;
        IDATA iDATA = new IDATA(J9ObjectHelper.clazz(this.object).lockOffset());
        if (iDATA.gte(new IDATA(0L))) {
            this.lockword = ObjectMonitorReferencePointer.cast(this.object.addOffset(iDATA.longValue())).at(0L);
        } else if (this.j9objectMonitor.notNull()) {
            this.lockword = this.j9objectMonitor.alternateLockword();
        }
        if (this.lockword.notNull()) {
            this.isInflated = this.lockword.allBitsIn(J9Object.OBJECT_HEADER_LOCK_INFLATED);
            if (this.isInflated) {
                this.monitor = J9ThreadAbstractMonitorPointer.cast(this.j9objectMonitor.monitor());
            }
        }
    }

    private static List<J9VMThreadPointer> getBlockedThreads(J9ObjectPointer j9ObjectPointer) throws CorruptDataException {
        if (blockedThreadsCache == null) {
            blockedThreadsCache = new HashMap();
            GCVMThreadListIterator gCVMThreadListIterator = GCVMThreadListIterator.from();
            while (gCVMThreadListIterator.hasNext()) {
                J9ObjectPointer j9ObjectPointer2;
                J9VMThreadPointer j9VMThreadPointer = gCVMThreadListIterator.next();
                if (!j9VMThreadPointer.publicFlags().allBitsIn(J9Consts.J9_PUBLIC_FLAGS_THREAD_BLOCKED) || !(j9ObjectPointer2 = j9VMThreadPointer.blockingEnterObject()).notNull()) continue;
                List<J9VMThreadPointer> list = blockedThreadsCache.get(j9ObjectPointer2);
                if (list == null) {
                    list = new ArrayList<J9VMThreadPointer>();
                    blockedThreadsCache.put(j9ObjectPointer2, list);
                }
                list.add(j9VMThreadPointer);
            }
        }
        return blockedThreadsCache.get(j9ObjectPointer);
    }

    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public int compareTo(ObjectMonitor objectMonitor) {
        int n = 0;
        ObjectMonitor_V1 objectMonitor_V1 = (ObjectMonitor_V1)objectMonitor;
        n = this.object.compare(objectMonitor_V1.object);
        return n;
    }
}

