/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.view.dtfj.java;

import com.ibm.dtfj.image.CorruptData;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.java.JavaRuntime;
import com.ibm.dtfj.java.JavaRuntimeMemoryCategory;
import com.ibm.dtfj.java.JavaRuntimeMemorySection;
import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.util.IteratorHelpers;
import com.ibm.j9ddr.view.dtfj.J9DDRDTFJUtils;
import com.ibm.j9ddr.vm29.pointer.generated.OMRMemCategoryPointer;
import com.ibm.j9ddr.vm29.pointer.helper.OMRMemCategoryHelper;
import com.ibm.j9ddr.vm29.types.UDATA;
import com.ibm.j9ddr.vm29.view.dtfj.DTFJContext;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class DTFJJavaRuntimeMemoryCategory
implements JavaRuntimeMemoryCategory {
    private final OMRMemCategoryPointer category;
    private final JavaRuntime runtime;

    public DTFJJavaRuntimeMemoryCategory(JavaRuntime javaRuntime, OMRMemCategoryPointer oMRMemCategoryPointer) {
        this.category = oMRMemCategoryPointer;
        this.runtime = javaRuntime;
    }

    public Iterator<?> getChildren() throws com.ibm.dtfj.image.CorruptDataException {
        return new ChildIterator(this.category);
    }

    public long getDeepAllocations() throws com.ibm.dtfj.image.CorruptDataException {
        DeepAllocationVisitor deepAllocationVisitor = new DeepAllocationVisitor();
        try {
            OMRMemCategoryHelper.visitMemoryCategoryChildren(this.category, deepAllocationVisitor);
        }
        catch (Throwable throwable) {
            throw J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), throwable);
        }
        return deepAllocationVisitor.deepAllocations;
    }

    public long getDeepBytes() throws com.ibm.dtfj.image.CorruptDataException {
        DeepBytesVisitor deepBytesVisitor = new DeepBytesVisitor();
        try {
            OMRMemCategoryHelper.visitMemoryCategoryChildren(this.category, deepBytesVisitor);
        }
        catch (Throwable throwable) {
            throw J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), throwable);
        }
        return deepBytesVisitor.deepBytes;
    }

    public Iterator<?> getMemorySections(boolean bl) throws com.ibm.dtfj.image.CorruptDataException, DataUnavailable {
        return IteratorHelpers.filterIterator(this.runtime.getMemorySections(bl), new IteratorHelpers.IteratorFilter<Object>(){

            @Override
            public boolean accept(Object object) {
                if (object instanceof JavaRuntimeMemorySection) {
                    try {
                        if (DTFJJavaRuntimeMemoryCategory.this.equals(((JavaRuntimeMemorySection)object).getMemoryCategory())) {
                            return true;
                        }
                    }
                    catch (Throwable throwable) {
                        J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), throwable);
                    }
                    return false;
                }
                return true;
            }
        });
    }

    public String getName() throws com.ibm.dtfj.image.CorruptDataException {
        try {
            return this.category.name().getCStringAtOffset(0L);
        }
        catch (Throwable throwable) {
            throw J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), throwable);
        }
    }

    public long getShallowAllocations() throws com.ibm.dtfj.image.CorruptDataException {
        try {
            return this.category.liveAllocations().longValue();
        }
        catch (Throwable throwable) {
            throw J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), throwable);
        }
    }

    public long getShallowBytes() throws com.ibm.dtfj.image.CorruptDataException {
        try {
            return this.category.liveBytes().longValue();
        }
        catch (Throwable throwable) {
            throw J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), throwable);
        }
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.category == null ? 0 : this.category.hashCode());
        n = 31 * n + (this.runtime == null ? 0 : this.runtime.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof DTFJJavaRuntimeMemoryCategory)) {
            return false;
        }
        DTFJJavaRuntimeMemoryCategory dTFJJavaRuntimeMemoryCategory = (DTFJJavaRuntimeMemoryCategory)object;
        if (this.category == null ? dTFJJavaRuntimeMemoryCategory.category != null : !this.category.equals(dTFJJavaRuntimeMemoryCategory.category)) {
            return false;
        }
        return !(this.runtime == null ? dTFJJavaRuntimeMemoryCategory.runtime != null : !this.runtime.equals((Object)dTFJJavaRuntimeMemoryCategory.runtime));
    }

    private static class DeepBytesVisitor
    implements OMRMemCategoryHelper.IOMRMemCategoryVisitor {
        long deepBytes = 0L;

        private DeepBytesVisitor() {
        }

        @Override
        public void visit(OMRMemCategoryPointer oMRMemCategoryPointer) throws CorruptDataException {
            this.deepBytes += oMRMemCategoryPointer.liveBytes().longValue();
        }
    }

    private static class DeepAllocationVisitor
    implements OMRMemCategoryHelper.IOMRMemCategoryVisitor {
        long deepAllocations = 0L;

        private DeepAllocationVisitor() {
        }

        @Override
        public void visit(OMRMemCategoryPointer oMRMemCategoryPointer) throws CorruptDataException {
            this.deepAllocations += oMRMemCategoryPointer.liveAllocations().longValue();
        }
    }

    class ChildIterator
    implements Iterator<Object> {
        private final OMRMemCategoryPointer category;
        private Object next = null;
        private int index = 0;

        public ChildIterator(OMRMemCategoryPointer oMRMemCategoryPointer) {
            this.category = oMRMemCategoryPointer;
        }

        private Object internalNext() {
            int n = 0;
            try {
                n = this.category.numberOfChildren().intValue();
            }
            catch (CorruptDataException corruptDataException) {
                return null;
            }
            if (this.index >= n) {
                return null;
            }
            try {
                UDATA uDATA = this.category.children().at(this.index++);
                OMRMemCategoryPointer oMRMemCategoryPointer = OMRMemCategoryHelper.getMemoryCategory(uDATA);
                if (oMRMemCategoryPointer.categoryCode().eq(uDATA)) {
                    return new DTFJJavaRuntimeMemoryCategory(DTFJJavaRuntimeMemoryCategory.this.runtime, oMRMemCategoryPointer);
                }
                return J9DDRDTFJUtils.newCorruptData(DTFJContext.getProcess(), "Unknown child category code " + uDATA.getHexValue());
            }
            catch (Throwable throwable) {
                CorruptData corruptData = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), throwable);
                return corruptData;
            }
        }

        @Override
        public boolean hasNext() {
            if (this.next != null) {
                return true;
            }
            this.next = this.internalNext();
            return this.next != null;
        }

        @Override
        public Object next() {
            if (this.hasNext()) {
                Object object = this.next;
                this.next = null;
                return object;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

