/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.DataUnavailableException;
import com.ibm.j9ddr.NoSuchFieldException;
import com.ibm.j9ddr.StructureReader;
import com.ibm.j9ddr.corereaders.memory.IMemoryRange;
import com.ibm.j9ddr.corereaders.memory.IModule;
import com.ibm.j9ddr.corereaders.memory.IProcess;
import com.ibm.j9ddr.corereaders.memory.ISymbol;
import com.ibm.j9ddr.corereaders.memory.MemoryFault;
import com.ibm.j9ddr.corereaders.memory.SymbolUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DDRSymbolFinder {
    private static boolean addSymbols = true;
    private static List<String[][]> paths = new LinkedList<String[][]>();
    private static Set<String> ignoredSymbols = new HashSet<String>();

    public static void addSymbols(IProcess iProcess, long l, StructureReader structureReader) {
        String[][] stringArray2;
        long l2 = 0L;
        try {
            l2 = DDRSymbolFinder.followPointerFromStructure("J9RAS", l, "vm", structureReader, iProcess);
        }
        catch (MemoryFault memoryFault) {
            stringArray2 = Logger.getLogger("j9ddr.structure_reader");
            stringArray2.log(Level.FINE, null, memoryFault);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            stringArray2 = Logger.getLogger("j9ddr.structure_reader");
            stringArray2.log(Level.FINE, null, noSuchFieldException);
        }
        catch (Exception exception) {
            stringArray2 = Logger.getLogger("j9ddr.structure_reader");
            stringArray2.log(Level.FINE, null, exception);
        }
        if (l2 == 0L) {
            return;
        }
        for (String[][] stringArray2 : paths) {
            Logger logger;
            try {
                long l3 = l2;
                String string = "J9JavaVM";
                for (String[] stringArray3 : stringArray2) {
                    String string2 = stringArray3[0];
                    String string3 = stringArray3[1];
                    l3 = DDRSymbolFinder.followPointerFromStructure(string, l3, string3, structureReader, iProcess);
                    string = string2;
                }
                DDRSymbolFinder.addVoidPointersAsSymbols(string, l3, structureReader, iProcess);
            }
            catch (MemoryFault memoryFault) {
                logger = Logger.getLogger("j9ddr.structure_reader");
                logger.log(Level.FINE, null, memoryFault);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                logger = Logger.getLogger("j9ddr.structure_reader");
                logger.log(Level.FINE, null, noSuchFieldException);
            }
            catch (CorruptDataException corruptDataException) {
                logger = Logger.getLogger("j9ddr.structure_reader");
                logger.log(Level.FINE, null, corruptDataException);
            }
            catch (DataUnavailableException dataUnavailableException) {
                logger = Logger.getLogger("j9ddr.structure_reader");
                logger.log(Level.FINE, null, dataUnavailableException);
            }
            catch (Exception exception) {
                logger = Logger.getLogger("j9ddr.structure_reader");
                logger.log(Level.FINE, null, exception);
            }
        }
    }

    private static void addVoidPointersAsSymbols(String string, long l, StructureReader structureReader, IProcess iProcess) throws DataUnavailableException, CorruptDataException {
        if (l == 0L) {
            return;
        }
        List<String> list = DDRSymbolFinder.getVoidPointerFieldsFromStructure(structureReader, string);
        if (list == null) {
            return;
        }
        int n = iProcess.bytesPerPointer() * 2;
        String string2 = "[!%s 0x%0" + n + "X->%s]";
        for (String string3 : list) {
            IModule iModule;
            long l2;
            if (ignoredSymbols.contains(string + "." + string3) || (l2 = DDRSymbolFinder.followPointerFromStructure(string, l, string3, structureReader, iProcess)) == 0L) continue;
            String string4 = String.format(string2, string.toLowerCase(), l, string3);
            if (l2 == 0L || !addSymbols || (iModule = DDRSymbolFinder.getModuleForInstructionAddress(iProcess, l2)) == null) continue;
            boolean bl = false;
            for (ISymbol iSymbol : iModule.getSymbols()) {
                if (iSymbol.getAddress() != l2) continue;
                Logger logger = Logger.getLogger("j9ddr.structure_reader");
                logger.log(Level.FINER, "DDRSymbolFinder: Found exact match with " + iSymbol.toString() + " not adding.");
                bl = true;
                break;
            }
            if (bl) continue;
            Logger logger = Logger.getLogger("j9ddr.structure_reader");
            logger.log(Level.FINER, "DDRSymbolFinder: Adding new DDR symbol " + string4);
            SymbolUtil.addDDRSymbolToModule(iModule, "[" + string3 + "]", string4, l2);
        }
    }

    private static long followPointerFromStructure(String string, long l, String string2, StructureReader structureReader, IProcess iProcess) throws MemoryFault, NullPointerException {
        if (l == 0L) {
            throw new NullPointerException("Null " + string + " found.");
        }
        for (StructureReader.FieldDescriptor fieldDescriptor : structureReader.getFields(string)) {
            if (!fieldDescriptor.isPresent() || !fieldDescriptor.getDeclaredName().equals(string2)) continue;
            long l2 = fieldDescriptor.getOffset();
            long l3 = l + l2;
            long l4 = iProcess.getPointerAt(l3);
            return l4;
        }
        return 0L;
    }

    private static List<String> getVoidPointerFieldsFromStructure(StructureReader structureReader, String string) throws MemoryFault {
        LinkedList<String> linkedList = new LinkedList<String>();
        for (StructureReader.FieldDescriptor fieldDescriptor : structureReader.getFields(string)) {
            if (!fieldDescriptor.isPresent()) continue;
            String string2 = fieldDescriptor.getDeclaredName();
            String string3 = fieldDescriptor.getDeclaredType();
            if (!"void *".equals(string3)) continue;
            linkedList.add(string2);
        }
        return linkedList;
    }

    private static IModule getModuleForInstructionAddress(IProcess iProcess, long l) throws CorruptDataException {
        Collection<? extends IModule> collection = iProcess.getModules();
        IModule iModule = null;
        block0: for (IModule iModule2 : collection) {
            for (IMemoryRange iMemoryRange : iModule2.getMemoryRanges()) {
                if (!iMemoryRange.contains(l)) continue;
                iModule = iModule2;
                break block0;
            }
        }
        return iModule;
    }

    static {
        paths.add(new String[][]{{"J9PortLibrary", "portLibrary"}});
        ignoredSymbols.add("J9PortLibrary.portVersion");
        ignoredSymbols.add("J9PortLibrary.portGlobals");
        paths.add(new String[][]{{"J9InternalVMFunctions", "internalVMFunctions"}});
        ignoredSymbols.add("J9InternalVMFunctions.reserved0");
        ignoredSymbols.add("J9InternalVMFunctions.reserved1");
        ignoredSymbols.add("J9InternalVMFunctions.reserved2");
        paths.add(new String[][]{{"J9InternalVMLabels", "internalVMLabels"}});
        paths.add(new String[][]{{"J9MemoryManagerFunctions", "memoryManagerFunctions"}});
        paths.add(new String[][]{{"jniNativeInterface", "jniFunctionTable"}});
        ignoredSymbols.add("jniNativeInterface.reserved0");
        ignoredSymbols.add("jniNativeInterface.reserved1");
        ignoredSymbols.add("jniNativeInterface.reserved2");
        ignoredSymbols.add("jniNativeInterface.reserved3");
        paths.add(new String[][]{{"J9ReflectFunctionTable", "reflectFunctions"}});
        paths.add(new String[][]{{"RasGlobalStorage", "j9rasGlobalStorage"}, {"UtInterface", "utIntf"}, {"UtServerInterface", "server"}});
        ignoredSymbols.add("UtServerInterface.header");
        paths.add(new String[][]{{"RasGlobalStorage", "j9rasGlobalStorage"}, {"UtInterface", "utIntf"}, {"UtClientInterface", "client"}});
        ignoredSymbols.add("UtClientInterface.header");
        paths.add(new String[][]{{"RasGlobalStorage", "j9rasGlobalStorage"}, {"UtInterface", "utIntf"}, {"UtModuleInterface", "module"}});
        paths.add(new String[][]{{"J9RASdumpFunctions", "j9rasDumpFunctions"}});
        ignoredSymbols.add("J9RASdumpFunctions.reserved");
    }
}

