/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive.commands;

import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.CommandUtils;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.vm29.j9.ObjectAccessBarrier;
import com.ibm.j9ddr.vm29.pointer.VoidPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm29.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9ObjectHelper;
import java.io.PrintStream;

public class CompressedRefMappingCommand
extends Command {
    public CompressedRefMappingCommand() {
        this.addCommand("fj9object", "<address>", "Display the j9object given a compressed refs address.");
        this.addCommand("fj9objecttoj9object", "<address>", "Convert the compressed refs address to a j9object address.");
        this.addCommand("j9objecttofj9object", "<address>", "Convert the j9object address to a compressed refs address.");
    }

    private void printHelp(PrintStream printStream) {
        printStream.append("Usage: \n");
        printStream.append("  !fj9object <address>\n");
        printStream.append("  !fj9objecttoj9object <address>\n");
        printStream.append("  !j9objecttofj9object <address>\n");
    }

    @Override
    public void run(String string, String[] stringArray, Context context, PrintStream printStream) throws DDRInteractiveCommandException {
        if (stringArray.length == 0) {
            this.printHelp(printStream);
            return;
        }
        long l = CommandUtils.parsePointer(stringArray[0], J9BuildFlags.J9VM_ENV_DATA64);
        VoidPointer voidPointer = VoidPointer.cast(l);
        if (string.startsWith("!fj9object")) {
            J9ObjectPointer j9ObjectPointer = J9ObjectHelper.compressObjectReferences ? ObjectAccessBarrier.convertPointerFromToken(voidPointer.getAddress()) : J9ObjectPointer.cast(voidPointer);
            if (string.startsWith("!fj9objecttoj9object")) {
                printStream.println(String.format("!fj9object %s -> !j9object %s", voidPointer.getHexAddress(), j9ObjectPointer.getHexAddress()));
            } else {
                context.execute("!j9object", new String[]{j9ObjectPointer.getHexAddress()}, printStream);
            }
        } else {
            long l2 = J9ObjectHelper.compressObjectReferences ? ObjectAccessBarrier.convertTokenFromPointer(J9ObjectPointer.cast(voidPointer)) : voidPointer.getAddress();
            printStream.println(String.format("!j9object %s -> !fj9object 0x%s\n", voidPointer.getHexAddress(), Long.toHexString(l2)));
        }
    }
}

