/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.view.dtfj.java;

import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.java.JavaRuntime;
import com.ibm.dtfj.java.JavaRuntimeMemoryCategory;
import com.ibm.dtfj.java.JavaRuntimeMemorySection;
import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.view.dtfj.J9DDRDTFJUtils;
import com.ibm.j9ddr.vm29.pointer.generated.J9MemTagPointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9MemTagHelper;
import com.ibm.j9ddr.vm29.structure.J9PortLibrary;
import com.ibm.j9ddr.vm29.types.UDATA;
import com.ibm.j9ddr.vm29.view.dtfj.DTFJContext;
import com.ibm.j9ddr.vm29.view.dtfj.java.DTFJJavaRuntimeMemoryCategory;
import com.ibm.j9ddr.vm29.view.dtfj.java.DTFJJavaRuntimeMemorySectionBase;

public class DTFJMemoryTagRuntimeMemorySection
extends DTFJJavaRuntimeMemorySectionBase
implements JavaRuntimeMemorySection {
    private final J9MemTagPointer memoryTag;
    private final JavaRuntime runtime;

    public DTFJMemoryTagRuntimeMemorySection(JavaRuntime javaRuntime, J9MemTagPointer j9MemTagPointer) {
        this.memoryTag = j9MemTagPointer;
        this.runtime = javaRuntime;
    }

    public int getAllocationType() {
        try {
            UDATA uDATA = this.memoryTag.eyeCatcher();
            if (uDATA.eq(J9PortLibrary.J9MEMTAG_EYECATCHER_ALLOC_HEADER)) {
                return 1;
            }
            return 2;
        }
        catch (Exception exception2) {
            J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), exception2);
        }
        catch (NoSuchFieldError noSuchFieldError) {
            J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), noSuchFieldError);
        }
        return 1;
    }

    public String getAllocator() throws com.ibm.dtfj.image.CorruptDataException, DataUnavailable {
        try {
            return this.memoryTag.callSite().getCStringAtOffset(0L);
        }
        catch (Exception exception2) {
            throw J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), exception2);
        }
        catch (NoSuchFieldError noSuchFieldError) {
            throw J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), noSuchFieldError);
        }
    }

    public JavaRuntimeMemoryCategory getMemoryCategory() throws com.ibm.dtfj.image.CorruptDataException, DataUnavailable {
        try {
            return new DTFJJavaRuntimeMemoryCategory(this.runtime, this.memoryTag.category());
        }
        catch (Exception exception2) {
            throw J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), exception2);
        }
        catch (NoSuchFieldError noSuchFieldError) {
            throw J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), noSuchFieldError);
        }
    }

    public String getName() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("JVM malloc'd storage allocated by ");
        try {
            String string = this.memoryTag.callSite().getCStringAtOffset(0L);
            stringBuilder.append(string);
        }
        catch (CorruptDataException corruptDataException) {
            stringBuilder.append("unknown (callsite unreadable)");
        }
        return stringBuilder.toString();
    }

    public long getSize() {
        try {
            return this.memoryTag.allocSize().longValue();
        }
        catch (CorruptDataException corruptDataException) {
        }
        catch (Exception exception2) {
            J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), exception2);
        }
        catch (NoSuchFieldError noSuchFieldError) {
            J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), noSuchFieldError);
        }
        return 0L;
    }

    @Override
    protected long getBaseAddressAsLong() {
        return J9MemTagHelper.j9mem_get_memory_base(this.memoryTag).getAddress();
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.memoryTag == null ? 0 : this.memoryTag.hashCode());
        n = 31 * n + (this.runtime == null ? 0 : this.runtime.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof DTFJMemoryTagRuntimeMemorySection)) {
            return false;
        }
        DTFJMemoryTagRuntimeMemorySection dTFJMemoryTagRuntimeMemorySection = (DTFJMemoryTagRuntimeMemorySection)object;
        if (this.memoryTag == null ? dTFJMemoryTagRuntimeMemorySection.memoryTag != null : !this.memoryTag.equals(dTFJMemoryTagRuntimeMemorySection.memoryTag)) {
            return false;
        }
        return !(this.runtime == null ? dTFJMemoryTagRuntimeMemorySection.runtime != null : !this.runtime.equals((Object)dTFJMemoryTagRuntimeMemorySection.runtime));
    }
}

