/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview.commands;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.ImageAddressSpace;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.image.MemoryAccessException;
import com.ibm.java.diagnostics.utils.IContext;
import com.ibm.java.diagnostics.utils.commands.CommandException;
import com.ibm.java.diagnostics.utils.plugins.DTFJPlugin;
import com.ibm.jvm.dtfjview.commands.BaseJdmpviewCommand;
import com.ibm.jvm.dtfjview.commands.helpers.Utils;
import java.io.PrintStream;
import java.util.Arrays;

@DTFJPlugin(version="1.*", runtime=false)
public class HexdumpCommand
extends BaseJdmpviewCommand {
    public HexdumpCommand() {
        this.addCommand("hexdump", "<hex address> [<bytes_to_print>]", "outputs a section of memory in hexadecimal, ASCII and EBCDIC");
    }

    public void run(String string, String[] stringArray, IContext iContext, PrintStream printStream) throws CommandException {
        if (this.initCommand(string, stringArray, iContext, printStream)) {
            return;
        }
        this.doCommand(stringArray);
    }

    public void doCommand(String[] stringArray) {
        int n;
        int n2;
        ImageAddressSpace imageAddressSpace = this.ctx.getAddressSpace();
        if (null == imageAddressSpace) {
            this.out.println("Could not find an address space which contains a process in this core file");
            return;
        }
        if (stringArray.length == 0) {
            this.out.println("\"hexdump\" requires at least an address parameter");
            return;
        }
        Long l = Utils.longFromString(stringArray[0]);
        if (null == l) {
            this.out.println("Specified address is invalid: " + stringArray[0]);
            return;
        }
        long l2 = l;
        int n3 = 256;
        if (stringArray.length > 1) {
            try {
                n3 = Integer.decode(stringArray[1]);
            }
            catch (NumberFormatException numberFormatException) {
                this.out.println("Specified length is invalid: " + stringArray[1]);
                return;
            }
        }
        boolean bl = false;
        try {
            bl = this.ctx.getImage().getSystemType().toLowerCase().contains("z/os");
        }
        catch (CorruptDataException | DataUnavailable throwable) {
            // empty catch block
        }
        ImagePointer imagePointer = imageAddressSpace.getPointer(l2);
        StringBuilder stringBuilder = new StringBuilder();
        char[] cArray = new char[16];
        char[] cArray2 = new char[16];
        this.out.println();
        for (n2 = 0; n2 < n3; ++n2) {
            try {
                n = n2 % 16;
                if (0 == n) {
                    stringBuilder.append(Long.toHexString(l2 + (long)n2));
                    stringBuilder.append(':');
                }
                int n4 = imagePointer.getByteAt((long)n2) & 0xFF;
                if (0 == n % 4) {
                    stringBuilder.append(' ');
                }
                stringBuilder.append(String.format("%02x", n4));
                cArray[n] = "................................ !\"#$%&'()*+'-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~.................................................................................................................................".charAt(n4);
                if (bl) {
                    cArray2[n] = "................................................................ ...........<(+|&.........!$*);.-/.........,%_>?.........`:#@'=\".abcdefghi.......jklmnopqr.......~stuvwxyz......^..........[]...{ABCDEFGHI......}JKLMNOPQR......\\.STUVWXYZ......0123456789......".charAt(n4);
                }
                if (15 != n) continue;
                stringBuilder.append("  |");
                stringBuilder.append(cArray);
                stringBuilder.append('|');
                if (bl) {
                    stringBuilder.append(" |");
                    stringBuilder.append(cArray2);
                    stringBuilder.append('|');
                }
                this.out.println(stringBuilder.toString());
                stringBuilder.setLength(0);
                continue;
            }
            catch (CorruptDataException corruptDataException) {
                this.out.println("Dump data is corrupted");
                return;
            }
            catch (MemoryAccessException memoryAccessException) {
                this.out.println("Address not in memory - 0x" + Long.toHexString(l2 + (long)n2));
                return;
            }
        }
        n2 = n3 % 16;
        if (0 != n2) {
            for (n = n2; n < 16; ++n) {
                if (0 == n % 4) {
                    stringBuilder.append(' ');
                }
                stringBuilder.append("  ");
            }
            Arrays.fill(cArray, n2, 16, ' ');
            stringBuilder.append("  |");
            stringBuilder.append(cArray);
            stringBuilder.append('|');
            if (bl) {
                Arrays.fill(cArray2, n2, 16, ' ');
                stringBuilder.append(" |");
                stringBuilder.append(cArray2);
                stringBuilder.append('|');
            }
            this.out.println(stringBuilder.toString());
        }
        this.out.println();
        this.ctx.getProperties().put("currentMemPtrAddress", (Object)l2);
        this.ctx.getProperties().put("currentNumBytes", (Object)n3);
    }

    @Override
    public void printDetailedHelp(PrintStream printStream) {
        printStream.format("outputs a section of memory in hexadecimal, ASCII and EBCDIC%n%nparameters: <hex_address> [<bytes_to_print>]%n%noutputs <bytes_to_print> (default 256) bytes of memory contents starting from <hex_address>%nEBCDIC output is also provided for z/OS dumps%n", new Object[0]);
    }
}

