/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview.commands.setcommands;

import com.ibm.java.diagnostics.utils.IContext;
import com.ibm.java.diagnostics.utils.commands.CommandException;
import com.ibm.java.diagnostics.utils.plugins.DTFJPlugin;
import com.ibm.jvm.dtfjview.commands.BaseJdmpviewCommand;
import com.ibm.jvm.dtfjview.heapdump.HeapDumpSettings;
import java.io.PrintStream;

@DTFJPlugin(version="1.*")
public class SetHeapdumpCommand
extends BaseJdmpviewCommand {
    private static final String SHORT_DESCRIPTION = "configures heapdump format, filename and multiple heap support";
    private static final String COMMAND_NAME = "set heapdump";
    private static final String LONG_DESCRIPTION = "parameters: [phd|txt], [file <filename>], [multiplefiles on|off]\n\n[phd|txt] - the format for the heapdump. Default: phd.\n[file <filename>] - the file to write the heapdump to. Default: <core file name>.phd or <core file name>.txt.\n\n[multiplefiles on|off] - if set to on, multiple heaps are written to separate heapdumps. If set to off, multiple heaps are written to the same heapdump. Default: off.\n\nUse \"show heapdump\" to see current settings.\n";

    public SetHeapdumpCommand() {
        this.addCommand(COMMAND_NAME, "", SHORT_DESCRIPTION);
    }

    public void run(String string, String[] stringArray, IContext iContext, PrintStream printStream) throws CommandException {
        if (this.initCommand(string, stringArray, iContext, printStream)) {
            return;
        }
        if (stringArray.length == 0) {
            printStream.println("\"set heapdump\" requires at least one parameter\n");
            return;
        }
        String string2 = stringArray[0];
        if (string2.equalsIgnoreCase("phd")) {
            HeapDumpSettings.setPHDHeapDumps(this.ctx.getProperties());
            printStream.print("Heapdump format set to PHD\n");
        } else if (string2.equalsIgnoreCase("txt")) {
            HeapDumpSettings.setClassicHeapDumps(this.ctx.getProperties());
            printStream.print("Heapdump format set to classic (TXT)\n");
        } else if (string2.equalsIgnoreCase("file")) {
            if (stringArray.length == 1) {
                printStream.println("\"set heapdump file\" requires at least one parameter\n");
                return;
            }
            if (stringArray.length > 2) {
                printStream.println("\"set heapdump file\" accepts 1 parameter. You supplied " + (stringArray.length - 1) + ".\n");
                return;
            }
            String string3 = stringArray[1];
            String string4 = HeapDumpSettings.getFileName(this.ctx.getProperties());
            HeapDumpSettings.setFileName(string3, this.ctx.getProperties());
            printStream.print("Heapdump file changed from " + string4 + " to " + string3 + "\n");
        } else if (string2.equalsIgnoreCase("multiplefiles")) {
            if (stringArray.length == 1) {
                printStream.println("\"set heapdump multiplefiles\" requires one parameter: on or off\n");
                return;
            }
            if (stringArray.length > 2) {
                printStream.println("\"set heapdump multiplefiles\" requires one parameter: on or off. You suppled " + (stringArray.length - 1) + " parameters\n");
                return;
            }
            String string5 = stringArray[1];
            if (string5.equalsIgnoreCase("on")) {
                printStream.println("Multiple heaps will be dumped into multiple heapdumps");
                HeapDumpSettings.setMultipleHeapsMultipleFiles(this.ctx.getProperties());
            } else if (string5.equalsIgnoreCase("off")) {
                printStream.println("Multiple heaps will be dumped into a single heapdump");
                HeapDumpSettings.setMultipleHeapsSingleFile(this.ctx.getProperties());
            } else {
                printStream.println("Unrecognised setting: " + string5 + ". Valid options are \"on\" or \"off\"\n");
            }
        } else {
            printStream.println(string2 + " is not a valid parameter for the \"set heapdump\" command");
        }
    }

    @Override
    public void printDetailedHelp(PrintStream printStream) {
        printStream.println(LONG_DESCRIPTION);
    }
}

