/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dataaccess;

import com.ibm.dataaccess.ByteArrayMarshaller;
import com.ibm.dataaccess.ByteArrayUnmarshaller;
import com.ibm.dataaccess.CommonData;
import com.ibm.dataaccess.PackedDecimal;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;

public final class DecimalData {
    public static final int EBCDIC_SIGN_EMBEDDED_TRAILING = 1;
    public static final int EBCDIC_SIGN_EMBEDDED_LEADING = 2;
    public static final int EBCDIC_SIGN_SEPARATE_TRAILING = 3;
    public static final int EBCDIC_SIGN_SEPARATE_LEADING = 4;
    public static final int UNICODE_UNSIGNED = 5;
    public static final int UNICODE_SIGN_SEPARATE_LEADING = 6;
    public static final int UNICODE_SIGN_SEPARATE_TRAILING = 7;
    private static final byte EBCDIC_SIGN_POSITIVE = 78;
    private static final byte EBCDIC_SIGN_NEGATIVE = 96;
    private static final byte EXTERNAL_HIGH_MASK = -16;
    private static final byte UNICODE_HIGH_MASK = 48;
    static final int EXTERNAL_DECIMAL_MIN = 1;
    static final int EXTERNAL_DECIMAL_MAX = 4;
    private static final int EBCDIC_MIN = 1;
    private static final int EBCDIC_MAX = 4;
    private static final int UNICODE_MIN = 5;
    private static final int UNICODE_MAX = 7;
    private static byte[] PD2EDTranslationTable;
    private static byte[] ED2UDTranslationTable;
    private static char UNICODE_SIGN_MINUS;
    private static char UNICODE_SIGN_PLUS;
    private static char UNICODE_ZERO;
    private static final boolean JIT_INTRINSICS_ENABLED = false;
    private static final int PACKED_BYTES_LENGTH = 33;
    private static final byte[] PACKED_BYTES;

    private DecimalData() {
    }

    private static final boolean JITIntrinsicsEnabled() {
        return false;
    }

    private static int numDigits(int n) {
        int n2 = n = n == Integer.MIN_VALUE ? Integer.MAX_VALUE : Math.abs(n);
        return n >= 10000 ? (n >= 10000000 ? (n >= 100000000 ? (n >= 1000000000 ? 10 : 9) : 8) : (n >= 100000 ? (n >= 1000000 ? 7 : 6) : 5)) : (n >= 100 ? (n >= 1000 ? 4 : 3) : (n >= 10 ? 2 : 1));
    }

    private static int numDigits(long l) {
        long l2 = l = l == Long.MIN_VALUE ? Long.MAX_VALUE : Math.abs(l);
        return l >= 1000000000L ? (l >= 100000000000000L ? (l >= 10000000000000000L ? (l >= 100000000000000000L ? (l >= 1000000000000000000L ? 19 : 18) : 17) : (l >= 1000000000000000L ? 16 : 15)) : (l >= 100000000000L ? (l >= 1000000000000L ? (l >= 10000000000000L ? 14 : 13) : 12) : (l >= 10000000000L ? 11 : 10))) : (l >= 10000L ? (l >= 1000000L ? (l >= 10000000L ? (l >= 100000000L ? 9 : 8) : 7) : (l >= 100000L ? 6 : 5)) : (l >= 100L ? (l >= 1000L ? 4 : 3) : (l >= 10L ? 2 : 1)));
    }

    public static void convertIntegerToPackedDecimal(int n, byte[] byArray, int n2, int n3, boolean bl) {
        if (n2 + (n3 / 2 + 1) > byArray.length || n2 < 0) {
            throw new ArrayIndexOutOfBoundsException("Array access index out of bounds. convertIntegerToPackedDecimal is trying to access packedDecimal[" + n2 + "] to packedDecimal[" + (n2 + n3 / 2) + "],  but valid indices are from 0 to " + (byArray.length - 1) + ".");
        }
        DecimalData.convertIntegerToPackedDecimal_(n, byArray, n2, n3, bl);
    }

    private static void convertIntegerToPackedDecimal_(int n, byte[] byArray, int n2, int n3, boolean bl) {
        int n4;
        int n5;
        boolean bl2;
        int n6 = CommonData.getPackedByteCount(n3);
        int n7 = n2 + n6 - 1;
        boolean bl3 = bl2 = n3 % 2 == 0;
        if (bl) {
            if (n3 < 1) {
                throw new ArithmeticException("Decimal overflow - Packed Decimal precision lesser than 1");
            }
            if (DecimalData.numDigits(n) > n3) {
                throw new ArithmeticException("Decimal overflow - Packed Decimal precision insufficient");
            }
        }
        if (n < 0) {
            byArray[n7] = (byte)(Math.abs(n) % 10 << 4 | 0xD);
            n5 = Math.abs(n / 10);
        } else {
            n5 = n;
            byArray[n7] = (byte)(n5 % 10 << 4 | 0xC);
            n5 /= 10;
        }
        for (n4 = n7 - 1; n4 > n2 && n5 != 0; n5 /= 100, --n4) {
            byArray[n4] = CommonData.getBinaryToPackedValues(n5 % 100);
        }
        if (n4 == n2 && n5 != 0) {
            byArray[n4] = bl2 ? (byte)(CommonData.getBinaryToPackedValues(n5 % 100) & 0xF) : CommonData.getBinaryToPackedValues(n5 % 100);
            n5 /= 100;
            --n4;
        }
        if (bl && n5 != 0) {
            throw new ArithmeticException("Decimal overflow - Packed Decimal precision insufficient");
        }
        if (n4 >= n2) {
            for (int i = 0; i < n4 - n2 + 1; ++i) {
                byArray[i + n2] = 0;
            }
        }
    }

    public static void convertIntegerToExternalDecimal(int n, byte[] byArray, int n2, int n3, boolean bl, int n4) {
        if (n2 < 0 || n2 + CommonData.getExternalByteCounts(n3, n4) > byArray.length) {
            throw new ArrayIndexOutOfBoundsException("Array access index out of bounds. convertIntegerToExternalDecimal is trying to access externalDecimal[" + n2 + "] to externalDecimal[" + (n2 + CommonData.getExternalByteCounts(n3, n4) - 1) + "],  but valid indices are from 0 to " + (byArray.length - 1) + ".");
        }
        if (DecimalData.JITIntrinsicsEnabled()) {
            byte[] byArray2 = new byte[n3 / 2 + 1];
            DecimalData.convertIntegerToPackedDecimal_(n, byArray2, 0, n3, bl);
            DecimalData.convertPackedDecimalToExternalDecimal_(byArray2, 0, byArray, n2, n3, n4);
        } else {
            DecimalData.convertIntegerToExternalDecimal_(n, byArray, n2, n3, bl, n4);
        }
    }

    private static void convertIntegerToExternalDecimal_(int n, byte[] byArray, int n2, int n3, boolean bl, int n4) {
        int n5;
        int n6;
        int n7 = -16;
        int n8 = n2++;
        if (n4 == 4) {
            // empty if block
        }
        int n9 = n2 + n3 - 1;
        if (n4 < 1 || n4 > 4) {
            throw new IllegalArgumentException("invalid decimalType");
        }
        if (bl) {
            if (n3 < 1) {
                throw new ArithmeticException("Decimal overflow - External Decimal precision lesser than 1");
            }
            if (DecimalData.numDigits(n) > n3) {
                throw new ArithmeticException("Decimal overflow - External Decimal precision insufficient");
            }
        }
        byArray[n9] = (byte)(n7 | Math.abs(n % 10));
        int n10 = Math.abs(n / 10);
        for (n6 = n9 - 1; n6 >= n2 && n10 != 0; n10 /= 10, --n6) {
            byArray[n6] = (byte)(n7 | n10 % 10);
        }
        if (n6 >= n2) {
            for (n5 = n2; n5 <= n6; ++n5) {
                byArray[n5] = (byte)(n7 | 0);
            }
        }
        switch (n4) {
            case 1: 
            case 2: {
                if (n4 == 1) {
                    n8 += n3 - 1;
                }
                n5 = n >= 0 ? -64 : -48;
                byArray[n8] = (byte)(byArray[n8] & 0xF | n5);
                break;
            }
            case 3: 
            case 4: {
                if (n4 == 3) {
                    n8 += n3;
                }
                byArray[n8] = n >= 0 ? 78 : 96;
            }
        }
    }

    public static void convertIntegerToUnicodeDecimal(int n, char[] cArray, int n2, int n3, boolean bl, int n4) {
        int n5;
        int n6 = n5 = n4 == 5 ? n3 : n3 + 1;
        if (n2 + n5 > cArray.length || n2 < 0) {
            throw new ArrayIndexOutOfBoundsException("Array access index out of bounds. convertIntegerToUnicodeDecimal is trying to access unicodeDecimal[" + n2 + "] to unicodeDecimal[" + (n2 + n5 - 1) + "],  but valid indices are from 0 to " + (cArray.length - 1) + ".");
        }
        if (DecimalData.JITIntrinsicsEnabled()) {
            byte[] byArray = new byte[n3 / 2 + 1];
            DecimalData.convertIntegerToPackedDecimal_(n, byArray, 0, n3, bl);
            DecimalData.convertPackedDecimalToUnicodeDecimal_(byArray, 0, cArray, n2, n3, n4);
        } else {
            DecimalData.convertIntegerToUnicodeDecimal_(n, cArray, n2, n3, bl, n4);
        }
    }

    private static void convertIntegerToUnicodeDecimal_(int n, char[] cArray, int n2, int n3, boolean bl, int n4) {
        int n5;
        if (bl) {
            if (n3 < 1) {
                throw new ArithmeticException("Decimal overflow - Unicode Decimal precision lesser than 1");
            }
            if (n3 < DecimalData.numDigits(n)) {
                throw new ArithmeticException("Decimal overflow - Unicode Decimal precision insufficient");
            }
        }
        switch (n4) {
            case 5: {
                break;
            }
            case 6: {
                cArray[n2++] = n < 0 ? UNICODE_SIGN_MINUS : UNICODE_SIGN_PLUS;
                break;
            }
            case 7: {
                cArray[n2 + n3] = n < 0 ? UNICODE_SIGN_MINUS : UNICODE_SIGN_PLUS;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid decimalType");
            }
        }
        cArray[n2 + n3 - 1] = (char)(0x30 | Math.abs(n) % 10);
        n = Math.abs(n / 10);
        for (n5 = n2 + n3 - 2; n5 >= n2 && n != 0; n /= 10, --n5) {
            cArray[n5] = (char)(0x30 | n % 10);
        }
        if (bl && n != 0) {
            throw new ArithmeticException("Decimal overflow - Unicode Decimal precision insufficient");
        }
        while (n5 >= n2) {
            cArray[n5] = 48;
            --n5;
        }
    }

    public static void convertLongToPackedDecimal(long l, byte[] byArray, int n, int n2, boolean bl) {
        if (n + (n2 / 2 + 1) > byArray.length || n < 0) {
            throw new ArrayIndexOutOfBoundsException("Array access index out of bounds. convertLongToPackedDecimal is trying to access packedDecimal[" + n + "] to packedDecimal[" + (n + n2 / 2) + "],  but valid indices are from 0 to " + (byArray.length - 1) + ".");
        }
        DecimalData.convertLongToPackedDecimal_(l, byArray, n, n2, bl);
    }

    private static void convertLongToPackedDecimal_(long l, byte[] byArray, int n, int n2, boolean bl) {
        int n3;
        long l2;
        boolean bl2;
        int n4 = CommonData.getPackedByteCount(n2);
        int n5 = n + n4 - 1;
        boolean bl3 = bl2 = n2 % 2 == 0;
        if (bl) {
            if (n2 < 1) {
                throw new ArithmeticException("Decimal overflow - Packed Decimal precision lesser than 1");
            }
            if (DecimalData.numDigits(l) > n2) {
                throw new ArithmeticException("Decimal overflow - Packed Decimal precision insufficient");
            }
        }
        if (l < 0L) {
            byArray[n5] = (byte)(Math.abs(l) % 10L << 4 | 0xDL);
            l2 = Math.abs(l / 10L);
        } else {
            l2 = l;
            byArray[n5] = (byte)(l2 % 10L << 4 | 0xCL);
            l2 /= 10L;
        }
        for (n3 = n5 - 1; n3 > n && l2 != 0L; l2 /= 100L, --n3) {
            byArray[n3] = CommonData.getBinaryToPackedValues((int)(l2 % 100L));
        }
        if (n3 == n && l2 != 0L) {
            byArray[n3] = bl2 ? (byte)(CommonData.getBinaryToPackedValues((int)(l2 % 100L)) & 0xF) : CommonData.getBinaryToPackedValues((int)(l2 % 100L));
            l2 /= 100L;
            --n3;
        }
        if (bl && l2 != 0L) {
            throw new ArithmeticException("Decimal overflow - Packed Decimal precision insufficient");
        }
        if (n3 >= n) {
            for (int i = 0; i < n3 - n + 1; ++i) {
                byArray[i + n] = 0;
            }
        }
    }

    public static void convertLongToExternalDecimal(long l, byte[] byArray, int n, int n2, boolean bl, int n3) {
        if (n < 0 || n + CommonData.getExternalByteCounts(n2, n3) > byArray.length) {
            throw new ArrayIndexOutOfBoundsException("Array access index out of bounds. convertLongToExternalDecimal is trying to access externalDecimal[" + n + "] to externalDecimal[" + (n + CommonData.getExternalByteCounts(n2, n3) - 1) + "],  but valid indices are from 0 to " + (byArray.length - 1) + ".");
        }
        if (DecimalData.JITIntrinsicsEnabled()) {
            byte[] byArray2 = new byte[n2 / 2 + 1];
            DecimalData.convertLongToPackedDecimal_(l, byArray2, 0, n2, bl);
            DecimalData.convertPackedDecimalToExternalDecimal_(byArray2, 0, byArray, n, n2, n3);
        } else {
            DecimalData.convertLongToExternalDecimal_(l, byArray, n, n2, bl, n3);
        }
    }

    private static void convertLongToExternalDecimal_(long l, byte[] byArray, int n, int n2, boolean bl, int n3) {
        int n4;
        int n5;
        int n6 = -16;
        int n7 = n++;
        if (n3 == 4) {
            // empty if block
        }
        int n8 = n + n2 - 1;
        if (n3 < 1 || n3 > 4) {
            throw new IllegalArgumentException("invalid decimalType");
        }
        if (bl) {
            if (n2 < 1) {
                throw new ArithmeticException("Decimal overflow - External Decimal precision lesser than 1");
            }
            if (DecimalData.numDigits(l) > n2) {
                throw new ArithmeticException("Decimal overflow - External Decimal precision insufficient");
            }
        }
        byArray[n8] = (byte)((long)n6 | Math.abs(l % 10L));
        long l2 = Math.abs(l / 10L);
        for (n5 = n8 - 1; n5 >= n && l2 != 0L; l2 /= 10L, --n5) {
            byArray[n5] = (byte)((long)n6 | l2 % 10L);
        }
        if (n5 >= n) {
            for (n4 = n; n4 <= n5; ++n4) {
                byArray[n4] = (byte)(n6 | 0);
            }
        }
        switch (n3) {
            case 1: 
            case 2: {
                if (n3 == 1) {
                    n7 += n2 - 1;
                }
                n4 = l >= 0L ? -64 : -48;
                byArray[n7] = (byte)(byArray[n7] & 0xF | n4);
                break;
            }
            case 3: 
            case 4: {
                if (n3 == 3) {
                    n7 += n2;
                }
                byArray[n7] = l >= 0L ? 78 : 96;
            }
        }
    }

    public static void convertLongToUnicodeDecimal(long l, char[] cArray, int n, int n2, boolean bl, int n3) {
        int n4;
        int n5 = n4 = n3 == 5 ? n2 : n2 + 1;
        if (n + n4 > cArray.length || n < 0) {
            throw new ArrayIndexOutOfBoundsException("Array access index out of bounds. convertIntegerToUnicodeDecimal is trying to access unicodeDecimal[" + n + "] to unicodeDecimal[" + (n + n4 - 1) + "],  but valid indices are from 0 to " + (cArray.length - 1) + ".");
        }
        if (DecimalData.JITIntrinsicsEnabled()) {
            byte[] byArray = new byte[n2 / 2 + 1];
            DecimalData.convertLongToPackedDecimal_(l, byArray, 0, n2, bl);
            DecimalData.convertPackedDecimalToUnicodeDecimal_(byArray, 0, cArray, n, n2, n3);
        } else {
            DecimalData.convertLongToUnicodeDecimal_(l, cArray, n, n2, bl, n3);
        }
    }

    private static void convertLongToUnicodeDecimal_(long l, char[] cArray, int n, int n2, boolean bl, int n3) {
        int n4;
        if (bl) {
            if (n2 < 1) {
                throw new ArithmeticException("Decimal overflow - Unicode Decimal precision lesser than 1");
            }
            if (n2 < DecimalData.numDigits(l)) {
                throw new ArithmeticException("Decimal overflow - Unicode Decimal precision insufficient");
            }
        }
        switch (n3) {
            case 5: {
                break;
            }
            case 6: {
                cArray[n++] = l < 0L ? UNICODE_SIGN_MINUS : UNICODE_SIGN_PLUS;
                break;
            }
            case 7: {
                cArray[n + n2] = l < 0L ? UNICODE_SIGN_MINUS : UNICODE_SIGN_PLUS;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid decimalType");
            }
        }
        cArray[n + n2 - 1] = (char)(0x30L | Math.abs(l) % 10L);
        l = Math.abs(l / 10L);
        for (n4 = n + n2 - 2; n4 >= n && l != 0L; l /= 10L, --n4) {
            cArray[n4] = (char)(0x30L | l % 10L);
        }
        if (bl && l != 0L) {
            throw new ArithmeticException("Decimal overflow - Unicode Decimal precision insufficient");
        }
        while (n4 >= n) {
            cArray[n4] = 48;
            --n4;
        }
    }

    public static int convertPackedDecimalToInteger(byte[] byArray, int n, int n2, boolean bl) {
        if (n + (n2 / 2 + 1) > byArray.length || n < 0) {
            throw new ArrayIndexOutOfBoundsException("Array access index out of bounds. convertPackedDecimalToInteger is trying to access packedDecimal[" + n + "] to packedDecimal[" + (n + n2 / 2) + "],  but valid indices are from 0 to " + (byArray.length - 1) + ".");
        }
        return DecimalData.convertPackedDecimalToInteger_(byArray, n, n2, bl);
    }

    private static int convertPackedDecimalToInteger_(byte[] byArray, int n, int n2, boolean bl) {
        int n3 = CommonData.getPackedByteCount(n2);
        int n4 = n + n3 - 1;
        long l = 0L;
        byte by = CommonData.getSign((byte)(byArray[n4] & 0xF));
        if (n2 % 2 == 0 && (byArray[n] & 0xF) == 0) {
            --n2;
            ++n;
        }
        while (n < n4 && byArray[n] == 0) {
            n2 -= 2;
            ++n;
        }
        if (bl) {
            if (n2 % 2 == 1 && (byArray[n] & 0xF0) == 0) {
                --n2;
            }
            if (n2 > 10) {
                throw new ArithmeticException("Decimal overflow - Packed Decimal too large for an int");
            }
        }
        for (int i = n; i <= n4 - 1; ++i) {
            l = l * 100L + (long)CommonData.getPackedToBinaryValues(byArray[i]);
        }
        l = l * 10L + (long)((byArray[n4] & 0xF0) >> 4);
        if (by == 13) {
            l = -1L * l;
        }
        if (bl && (l > Integer.MAX_VALUE || l < Integer.MIN_VALUE)) {
            throw new ArithmeticException("Decimal overflow - Packed Decimal too large for a int");
        }
        return (int)l;
    }

    public static long convertPackedDecimalToLong(byte[] byArray, int n, int n2, boolean bl) {
        if (n + (n2 / 2 + 1) > byArray.length || n < 0) {
            throw new ArrayIndexOutOfBoundsException("Array access index out of bounds. convertPackedDecimalToLong is trying to access packedDecimal[" + n + "] to packedDecimal[" + (n + n2 / 2) + "],  but valid indices are from 0 to " + (byArray.length - 1) + ".");
        }
        return DecimalData.convertPackedDecimalToLong_(byArray, n, n2, bl);
    }

    private static long convertPackedDecimalToLong_(byte[] byArray, int n, int n2, boolean bl) {
        long l = 0L;
        int n3 = CommonData.getPackedByteCount(n2);
        int n4 = n + n3 - 1;
        int n5 = byArray[n4] & 0xFF;
        byte by = CommonData.getSign((byte)(n5 & 0xF));
        if (n2 % 2 == 0 && (byArray[n] & 0xF) == 0) {
            --n2;
            ++n;
        }
        while (n < n4 && byArray[n] == 0) {
            n2 -= 2;
            ++n;
        }
        if (bl) {
            if (n2 % 2 == 1 && (byArray[n] & 0xF0) == 0) {
                --n2;
            }
            if (n2 > 19) {
                throw new ArithmeticException("Decimal overflow - Packed Decimal too large for a long");
            }
        }
        for (int i = n; i <= n4 - 1; ++i) {
            l = l * 100L + (long)CommonData.getPackedToBinaryValues(byArray[i]);
        }
        l = l * 10L + (long)((n5 & 0xF0) >> 4);
        if (by == 13) {
            l = -l;
        }
        if (bl) {
            if (by == 12 && l < 0L) {
                throw new ArithmeticException("Decimal overflow - Packed Decimal too large for a long");
            }
            if (by == 13 && l > 0L) {
                throw new ArithmeticException("Decimal overflow - Packed Decimal too large for a long");
            }
        }
        return l;
    }

    public static void convertPackedDecimalToExternalDecimal(byte[] byArray, int n, byte[] byArray2, int n2, int n3, int n4) {
        if (n + (n3 / 2 + 1) > byArray.length || n < 0) {
            throw new ArrayIndexOutOfBoundsException("Array access index out of bounds. convertPackedDecimalToExternalDecimal is trying to access packedDecimal[" + n + "] to packedDecimal[" + (n + n3 / 2) + "],  but valid indices are from 0 to " + (byArray.length - 1) + ".");
        }
        if (n2 < 0 || n2 + CommonData.getExternalByteCounts(n3, n4) > byArray2.length) {
            throw new ArrayIndexOutOfBoundsException("Array access index out of bounds. convertPackedDecimalToExternalDecimal is trying to access externalDecimal[" + n2 + "] to externalDecimal[" + (n2 + CommonData.getExternalByteCounts(n3, n4) - 1) + "],  but valid indices are from 0 to " + (byArray2.length - 1) + ".");
        }
        DecimalData.convertPackedDecimalToExternalDecimal_(byArray, n, byArray2, n2, n3, n4);
    }

    private static void convertPackedDecimalToExternalDecimal_(byte[] byArray, int n, byte[] byArray2, int n2, int n3, int n4) {
        int n5;
        if (n4 < 1 || n4 > 4) {
            throw new IllegalArgumentException("invalid decimalType");
        }
        if (n3 <= 0) {
            throw new IllegalArgumentException("negative precision");
        }
        int n6 = n2++;
        if (n4 == 4) {
            // empty if block
        }
        int n7 = n + n3 / 2;
        int n8 = n2 + n3 - 1;
        int n9 = -16;
        if (n3 % 2 == 0) {
            byArray2[n2++] = (byte)(n9 | byArray[n++] & 0xF);
        }
        for (n5 = n; n5 < n7; ++n5) {
            byArray2[n2++] = (byte)(n9 | (byArray[n5] & 0xF0) >> 4 & 0xF);
            byArray2[n2++] = (byte)(n9 | byArray[n5] & 0xF);
        }
        byArray2[n8] = (byte)(n9 | (byArray[n7] & 0xF0) >> 4 & 0xF);
        n5 = (byte)(CommonData.getSign(byArray[n7] & 0xF) << 4);
        switch (n4) {
            case 4: {
                if (n5 == -64) {
                    byArray2[n6] = 78;
                    break;
                }
                byArray2[n6] = 96;
                break;
            }
            case 2: {
                byArray2[n6] = (byte)(byArray2[n6] & 0xF | n5);
                break;
            }
            case 1: {
                byArray2[n6 += n3 - 1] = (byte)(byArray2[n6] & 0xF | n5);
                break;
            }
            case 3: {
                n6 += n3;
                if (n5 == -64) {
                    byArray2[n6] = 78;
                    break;
                }
                byArray2[n6] = 96;
                break;
            }
        }
    }

    public static void convertPackedDecimalToUnicodeDecimal(byte[] byArray, int n, char[] cArray, int n2, int n3, int n4) {
        int n5;
        int n6 = n5 = n4 == 5 ? n3 : n3 + 1;
        if (n2 + n5 > cArray.length || n2 < 0) {
            throw new ArrayIndexOutOfBoundsException("Array access index out of bounds. convertPackedDecimalToUnicodeDecimal is trying to access unicodeDecimal[" + n2 + "] to unicodeDecimal[" + (n2 + n5 - 1) + "],  but valid indices are from 0 to " + (cArray.length - 1) + ".");
        }
        if (n < 0 || n + (n3 / 2 + 1) > byArray.length) {
            throw new ArrayIndexOutOfBoundsException("Array access index out of bounds. convertPackedDecimalToUnicodeDecimal is trying to access packedDecimal[" + n + "] to packedDecimal[" + (n + n3 / 2) + "],  but valid indices are from 0 to " + (byArray.length - 1) + ".");
        }
        DecimalData.convertPackedDecimalToUnicodeDecimal_(byArray, n, cArray, n2, n3, n4);
    }

    private static void convertPackedDecimalToUnicodeDecimal_(byte[] byArray, int n, char[] cArray, int n2, int n3, int n4) {
        if (n3 <= 0) {
            throw new IllegalArgumentException("negative precision");
        }
        int n5 = -1;
        switch (n4) {
            case 5: {
                break;
            }
            case 6: {
                n5 = n2++;
                break;
            }
            case 7: {
                n5 = n2 + n3;
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid decimalType");
            }
        }
        int n6 = 48;
        int n7 = n + n3 / 2;
        byte by = (byte)(byArray[n7] & 0xF);
        by = CommonData.getSign(by);
        if (n3 % 2 == 0) {
            cArray[n2] = (char)(n6 | byArray[n++] & 0xF);
            ++n2;
        }
        for (int i = n; i < n7; ++i) {
            cArray[n2] = (char)(n6 | (byArray[i] & 0xF0) >> 4 & 0xF);
            cArray[++n2] = (char)(n6 | byArray[i] & 0xF);
            ++n2;
        }
        cArray[n2] = (char)(n6 | (byArray[n7] & 0xF0) >> 4 & 0xF);
        if (n4 != 5) {
            cArray[n5] = by == 12 ? 43 : 45;
        }
    }

    public static BigInteger convertPackedDecimalToBigInteger(byte[] byArray, int n, int n2, boolean bl) {
        return DecimalData.convertPackedDecimalToBigDecimal(byArray, n, n2, 0, bl).toBigInteger();
    }

    public static BigDecimal convertPackedDecimalToBigDecimal(byte[] byArray, int n, int n2, int n3, boolean bl) {
        if (n2 <= 9) {
            return BigDecimal.valueOf(DecimalData.convertPackedDecimalToInteger(byArray, n, n2, bl), n3);
        }
        if (n2 <= 18) {
            return BigDecimal.valueOf(DecimalData.convertPackedDecimalToLong(byArray, n, n2, bl), n3);
        }
        return DecimalData.slowSignedPackedToBigDecimal(byArray, n, n2, n3, bl);
    }

    public static int convertExternalDecimalToInteger(byte[] byArray, int n, int n2, boolean bl, int n3) {
        if (n + CommonData.getExternalByteCounts(n2, n3) > byArray.length || n < 0) {
            throw new ArrayIndexOutOfBoundsException("Array access index out of bounds. convertExternalDecimalToInteger is trying to access externalDecimal[" + n + "] to externalDecimal[" + (n + CommonData.getExternalByteCounts(n2, n3) - 1) + "],  but valid indices are from 0 to " + (byArray.length - 1) + ".");
        }
        if (n2 <= 0) {
            throw new IllegalArgumentException("Precision can't be negative.");
        }
        if (DecimalData.JITIntrinsicsEnabled()) {
            byte[] byArray2 = new byte[n2 / 2 + 1];
            DecimalData.convertExternalDecimalToPackedDecimal_(byArray, n, byArray2, 0, n2, n3);
            return DecimalData.convertPackedDecimalToInteger_(byArray2, 0, n2, bl);
        }
        return DecimalData.convertExternalDecimalToInteger_(byArray, n, n2, bl, n3);
    }

    private static int convertExternalDecimalToInteger_(byte[] byArray, int n, int n2, boolean bl, int n3) {
        int n4 = n + CommonData.getExternalByteCounts(n2, n3) - 1;
        boolean bl2 = DecimalData.isExternalDecimalSignNegative(byArray, n, n2, n3);
        if (n3 == 3) {
            --n4;
        } else if (n3 == 4) {
            ++n;
        }
        int n5 = 0;
        if (bl2) {
            if (n2 < 10 || !bl) {
                for (int i = n; i <= n4; ++i) {
                    n5 = n5 * 10 - (byArray[i] & 0xF);
                }
            } else {
                int n6;
                int n7;
                int n8;
                for (n8 = n7 = n > (n6 = n4 - 9) ? n : n6; n8 <= n4; ++n8) {
                    n5 = n5 * 10 - (byArray[n8] & 0xF);
                }
                if (n5 > 0 || n6 >= n && (byArray[n6] & 0xF) > 2) {
                    throw new ArithmeticException("Decimal overflow - External Decimal too small for an int");
                }
                for (n8 = n; n8 < n7; ++n8) {
                    if ((byArray[n8] & 0xF) <= 0) continue;
                    throw new ArithmeticException("Decimal overflow - External Decimal too small for an int");
                }
            }
        } else if (n2 < 10 || !bl) {
            for (int i = n; i <= n4; ++i) {
                n5 = n5 * 10 + (byArray[i] & 0xF);
            }
        } else {
            int n9;
            int n10;
            int n11;
            for (n11 = n10 = n > (n9 = n4 - 9) ? n : n9; n11 <= n4; ++n11) {
                n5 = n5 * 10 + (byArray[n11] & 0xF);
            }
            if (n5 < 0 || n9 >= n && (byArray[n9] & 0xF) > 2) {
                throw new ArithmeticException("Decimal overflow - External Decimal too large for an int");
            }
            for (n11 = n; n11 < n10; ++n11) {
                if ((byArray[n11] & 0xF) <= 0) continue;
                throw new ArithmeticException("Decimal overflow - External Decimal too large for an int");
            }
        }
        return n5;
    }

    public static long convertExternalDecimalToLong(byte[] byArray, int n, int n2, boolean bl, int n3) {
        if (n + CommonData.getExternalByteCounts(n2, n3) > byArray.length || n < 0) {
            throw new ArrayIndexOutOfBoundsException("Array access index out of bounds. convertExternalDecimalToLong is trying to access externalDecimal[" + n + "] to externalDecimal[" + (n + CommonData.getExternalByteCounts(n2, n3) - 1) + "],  but valid indices are from 0 to " + (byArray.length - 1) + ".");
        }
        if (n2 <= 0) {
            throw new IllegalArgumentException("Precision can't be negative.");
        }
        if (DecimalData.JITIntrinsicsEnabled()) {
            byte[] byArray2 = new byte[n2 / 2 + 1];
            DecimalData.convertExternalDecimalToPackedDecimal_(byArray, n, byArray2, 0, n2, n3);
            return DecimalData.convertPackedDecimalToLong_(byArray2, 0, n2, bl);
        }
        return DecimalData.convertExternalDecimalToLong_(byArray, n, n2, bl, n3);
    }

    private static long convertExternalDecimalToLong_(byte[] byArray, int n, int n2, boolean bl, int n3) {
        int n4 = n + CommonData.getExternalByteCounts(n2, n3) - 1;
        boolean bl2 = DecimalData.isExternalDecimalSignNegative(byArray, n, n2, n3);
        if (n3 == 3) {
            --n4;
        } else if (n3 == 4) {
            ++n;
        }
        long l = 0L;
        if (bl2) {
            if (n2 < 19 || !bl) {
                for (int i = n; i <= n4; ++i) {
                    l = l * 10L - (long)(byArray[i] & 0xF);
                }
            } else {
                int n5;
                int n6;
                for (n6 = n5 = n > n4 - 18 ? n : n4 - 18; n6 <= n4; ++n6) {
                    l = l * 10L - (long)(byArray[n6] & 0xF);
                }
                if (l > 0L) {
                    throw new ArithmeticException("Decimal overflow - External Decimal too small for a long");
                }
                for (n6 = n; n6 < n5; ++n6) {
                    if ((byArray[n6] & 0xF) <= 0) continue;
                    throw new ArithmeticException("Decimal overflow - External Decimal too small for a long");
                }
            }
        } else if (n2 < 19 || !bl) {
            for (int i = n; i <= n4; ++i) {
                l = l * 10L + (long)(byArray[i] & 0xF);
            }
        } else {
            int n7;
            int n8;
            for (n8 = n7 = n > n4 - 18 ? n : n4 - 18; n8 <= n4; ++n8) {
                l = l * 10L + (long)(byArray[n8] & 0xF);
            }
            if (l < 0L) {
                throw new ArithmeticException("Decimal overflow - External Decimal too large for a long");
            }
            for (n8 = n; n8 < n7; ++n8) {
                if ((byArray[n8] & 0xF) <= 0) continue;
                throw new ArithmeticException("Decimal overflow - External Decimal too large for a long");
            }
        }
        return l;
    }

    public static void convertExternalDecimalToPackedDecimal(byte[] byArray, int n, byte[] byArray2, int n2, int n3, int n4) {
        if (n + CommonData.getExternalByteCounts(n3, n4) > byArray.length || n < 0) {
            throw new ArrayIndexOutOfBoundsException("Array access index out of bounds. convertExternalDecimalToPackedDecimal is trying to access externalDecimal[" + n + "] to externalDecimal[" + (n + CommonData.getExternalByteCounts(n3, n4) - 1) + "],  but valid indices are from 0 to " + (byArray.length - 1) + ".");
        }
        if (n2 < 0 || n2 + (n3 / 2 + 1) > byArray2.length) {
            throw new ArrayIndexOutOfBoundsException("Array access index out of bounds. convertExternalDecimalToPackedDecimal is trying to access packedDecimal[" + n2 + "] to packedDecimal[" + (n2 + n3 / 2) + "],  but valid indices are from 0 to " + (byArray2.length - 1) + ".");
        }
        DecimalData.convertExternalDecimalToPackedDecimal_(byArray, n, byArray2, n2, n3, n4);
    }

    private static void convertExternalDecimalToPackedDecimal_(byte[] byArray, int n, byte[] byArray2, int n2, int n3, int n4) {
        boolean bl = DecimalData.isExternalDecimalSignNegative(byArray, n, n3, n4);
        if (n4 < 1 || n4 > 4) {
            throw new IllegalArgumentException("invalid decimalType");
        }
        if (n3 <= 0) {
            throw new IllegalArgumentException("negative precision");
        }
        int n5 = n2 + n3 / 2;
        if (n4 == 4) {
            ++n;
        }
        if (n3 % 2 == 0) {
            byArray2[n2++] = (byte)(byArray[n++] & 0xF);
        }
        for (int i = n2; i < n5; ++i) {
            byte by = (byte)((byArray[n++] & 0xF) << 4);
            byte by2 = (byte)(byArray[n++] & 0xF);
            byArray2[i] = (byte)(by | by2);
        }
        byArray2[n5] = (byte)((byArray[n] & 0xF) << 4);
        if (bl) {
            int n6 = n5;
            byArray2[n6] = (byte)(byArray2[n6] | 0xD);
        } else {
            int n7 = n5;
            byArray2[n7] = (byte)(byArray2[n7] | 0xC);
        }
    }

    public static BigInteger convertExternalDecimalToBigInteger(byte[] byArray, int n, int n2, boolean bl, int n3) {
        byte[] byArray2 = new byte[n2 / 2 + 1];
        DecimalData.convertExternalDecimalToPackedDecimal(byArray, n, byArray2, 0, n2, n3);
        int n4 = PackedDecimal.checkPackedDecimal(byArray2, 0, n2, true, true);
        if (n4 != 0) {
            throw new IllegalArgumentException("The input External Decimal is not valid.");
        }
        return DecimalData.convertPackedDecimalToBigDecimal(byArray2, 0, n2, 0, bl).toBigInteger();
    }

    public static BigDecimal convertExternalDecimalToBigDecimal(byte[] byArray, int n, int n2, int n3, boolean bl, int n4) {
        if (n2 <= 9) {
            return BigDecimal.valueOf(DecimalData.convertExternalDecimalToInteger(byArray, n, n2, bl, n4), n3);
        }
        if (n2 <= 18) {
            return BigDecimal.valueOf(DecimalData.convertExternalDecimalToLong(byArray, n, n2, bl, n4), n3);
        }
        byte[] byArray2 = new byte[n2 / 2 + 1];
        DecimalData.convertExternalDecimalToPackedDecimal(byArray, n, byArray2, 0, n2, n4);
        int n5 = PackedDecimal.checkPackedDecimal(byArray2, 0, n2, true, true);
        if (n5 != 0) {
            throw new IllegalArgumentException("The input External Decimal is not valid.");
        }
        return DecimalData.convertPackedDecimalToBigDecimal(byArray2, 0, n2, n3, bl);
    }

    private static boolean isExternalDecimalSignNegative(byte[] byArray, int n, int n2, int n3) {
        byte by = 0;
        switch (n3) {
            case 2: {
                by = (byte)(byArray[n] & 0xFFFFFFF0);
                if (by != -48 && by != -80) break;
                return true;
            }
            case 1: {
                by = (byte)(byArray[n + n2 - 1] & 0xFFFFFFF0);
                if (by != -48 && by != -80) break;
                return true;
            }
            case 4: {
                by = byArray[n];
                if (by != 96) break;
                return true;
            }
            case 3: {
                by = byArray[n + n2];
                if (by != 96) break;
                return true;
            }
            default: {
                throw new IllegalArgumentException("Invalid decimal sign type.");
            }
        }
        return false;
    }

    public static int convertUnicodeDecimalToInteger(char[] cArray, int n, int n2, boolean bl, int n3) {
        int n4;
        int n5 = n4 = n3 == 5 ? n2 : n2 + 1;
        if (n + n4 > cArray.length || n < 0) {
            throw new ArrayIndexOutOfBoundsException("Array access index out of bounds. convertUnicodeDecimalToInteger is trying to access unicodeDecimal[" + n + "] to unicodeDecimal[" + (n + n4 - 1) + "],  but valid indices are from 0 to " + (cArray.length - 1) + ".");
        }
        if (DecimalData.JITIntrinsicsEnabled()) {
            byte[] byArray = new byte[n2 / 2 + 1];
            DecimalData.convertUnicodeDecimalToPackedDecimal_(cArray, n, byArray, 0, n2, n3);
            int n6 = PackedDecimal.checkPackedDecimal(byArray, 0, n2, true, true);
            if (n6 != 0) {
                throw new IllegalArgumentException("The input Unicode is not valid");
            }
            return DecimalData.convertPackedDecimalToInteger_(byArray, 0, n2, bl);
        }
        return DecimalData.convertUnicodeDecimalToInteger_(cArray, n, n2, bl, n3);
    }

    private static int convertUnicodeDecimalToInteger_(char[] cArray, int n, int n2, boolean bl, int n3) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("invalid precision");
        }
        boolean bl2 = true;
        switch (n3) {
            case 5: {
                break;
            }
            case 6: {
                bl2 = cArray[n++] == UNICODE_SIGN_PLUS;
                break;
            }
            case 7: {
                bl2 = cArray[n + n2] == UNICODE_SIGN_PLUS;
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid decimalType");
            }
        }
        int n4 = n + n2;
        long l = 0L;
        while (n < n4 && cArray[n] == UNICODE_ZERO) {
            --n2;
            ++n;
        }
        if (bl && n2 > 10) {
            throw new ArithmeticException("Decimal overflow - Unicode Decimal too large for an int");
        }
        while (n < n4) {
            l *= 10L;
            l -= (long)(cArray[n] & 0xF);
            ++n;
        }
        long l2 = l = bl2 ? -l : l;
        if (bl && (l > Integer.MAX_VALUE || l < Integer.MIN_VALUE)) {
            throw new ArithmeticException("Decimal overflow - Unicode Decimal too large for a int");
        }
        return (int)l;
    }

    public static long convertUnicodeDecimalToLong(char[] cArray, int n, int n2, boolean bl, int n3) {
        int n4;
        int n5 = n4 = n3 == 5 ? n2 : n2 + 1;
        if (n + n4 > cArray.length || n < 0) {
            throw new ArrayIndexOutOfBoundsException("Array access index out of bounds. convertUnicodeDecimalToLong is trying to access unicodeDecimal[" + n + "] to unicodeDecimal[" + (n + n4 - 1) + "],  but valid indices are from 0 to " + (cArray.length - 1) + ".");
        }
        if (DecimalData.JITIntrinsicsEnabled()) {
            byte[] byArray = new byte[n2 / 2 + 1];
            DecimalData.convertUnicodeDecimalToPackedDecimal_(cArray, n, byArray, 0, n2, n3);
            int n6 = PackedDecimal.checkPackedDecimal(byArray, 0, n2, true, true);
            if (n6 != 0) {
                throw new IllegalArgumentException("The input Unicode is not valid");
            }
            return DecimalData.convertPackedDecimalToLong_(byArray, 0, n2, bl);
        }
        return DecimalData.convertUnicodeDecimalToLong_(cArray, n, n2, bl, n3);
    }

    private static long convertUnicodeDecimalToLong_(char[] cArray, int n, int n2, boolean bl, int n3) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("invalid precision");
        }
        boolean bl2 = true;
        switch (n3) {
            case 5: {
                break;
            }
            case 6: {
                bl2 = cArray[n++] == UNICODE_SIGN_PLUS;
                break;
            }
            case 7: {
                bl2 = cArray[n + n2] == UNICODE_SIGN_PLUS;
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid decimalType");
            }
        }
        int n4 = n + n2;
        long l = 0L;
        while (n < n4 && cArray[n] == UNICODE_ZERO) {
            --n2;
            ++n;
        }
        if (bl && n2 > 19) {
            throw new ArithmeticException("Decimal overflow - Unicode Decimal too large for a long");
        }
        while (n < n4) {
            l *= 10L;
            l -= (long)(cArray[n] & 0xF);
            ++n;
        }
        long l2 = l = bl2 ? -l : l;
        if (bl) {
            if (bl2 && l < 0L) {
                throw new ArithmeticException("Decimal overflow - Unicode Decimal too large for a long");
            }
            if (!bl2 && l > 0L) {
                throw new ArithmeticException("Decimal overflow - Unicode Decimal too small for a long");
            }
        }
        return l;
    }

    public static void convertUnicodeDecimalToPackedDecimal(char[] cArray, int n, byte[] byArray, int n2, int n3, int n4) {
        int n5;
        int n6 = n5 = n4 == 5 ? n3 : n3 + 1;
        if (n + n5 > cArray.length || n < 0) {
            throw new ArrayIndexOutOfBoundsException("Array access index out of bounds. convertUnicodeDecimalToPackedDecimal is trying to access unicodeDecimal[" + n + "] to unicodeDecimal[" + (n + n5 - 1) + "],  but valid indices are from 0 to " + (cArray.length - 1) + ".");
        }
        if (n2 < 0 || n2 + (n3 / 2 + 1) > byArray.length) {
            throw new ArrayIndexOutOfBoundsException("Array access index out of bounds. convertUnicodeDecimalToPackedDecimal is trying to access packedDecimal[" + n2 + "] to packedDecimal[" + (n2 + n3 / 2) + "],  but valid indices are from 0 to " + (byArray.length - 1) + ".");
        }
        DecimalData.convertUnicodeDecimalToPackedDecimal_(cArray, n, byArray, n2, n3, n4);
    }

    private static void convertUnicodeDecimalToPackedDecimal_(char[] cArray, int n, byte[] byArray, int n2, int n3, int n4) {
        if (n3 <= 0) {
            throw new IllegalArgumentException("invalid precision");
        }
        int n5 = n2 + n3 / 2;
        int n6 = n++;
        if (n4 == 6) {
            // empty if block
        }
        if (n3 % 2 == 0) {
            byArray[n2++] = (byte)(cArray[n++] & 0xF);
        }
        for (int i = n2; i < n5; ++i) {
            byte by = (byte)((cArray[n++] & 0xF) << 4);
            byte by2 = (byte)(cArray[n++] & 0xF);
            byArray[i] = (byte)(by | by2);
        }
        byArray[n5] = (byte)((cArray[n++] & 0xF) << 4);
        switch (n4) {
            case 6: {
                if (cArray[n6] == '-') {
                    int n7 = n5;
                    byArray[n7] = (byte)(byArray[n7] | 0xD);
                    break;
                }
                int n8 = n5;
                byArray[n8] = (byte)(byArray[n8] | 0xC);
                break;
            }
            case 7: {
                if (cArray[n] == '-') {
                    int n9 = n5;
                    byArray[n9] = (byte)(byArray[n9] | 0xD);
                    break;
                }
                int n10 = n5;
                byArray[n10] = (byte)(byArray[n10] | 0xC);
                break;
            }
            case 5: {
                int n11 = n5;
                byArray[n11] = (byte)(byArray[n11] | 0xC);
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid decimalType");
            }
        }
    }

    public static BigInteger convertUnicodeDecimalToBigInteger(char[] cArray, int n, int n2, boolean bl, int n3) {
        byte[] byArray = new byte[n2 / 2 + 1];
        DecimalData.convertUnicodeDecimalToPackedDecimal(cArray, n, byArray, 0, n2, n3);
        int n4 = PackedDecimal.checkPackedDecimal(byArray, 0, n2, true, true);
        if (n4 != 0) {
            throw new IllegalArgumentException("The input Unicode is not valid");
        }
        return DecimalData.convertPackedDecimalToBigDecimal(byArray, 0, n2, 0, bl).toBigInteger();
    }

    public static BigDecimal convertUnicodeDecimalToBigDecimal(char[] cArray, int n, int n2, int n3, boolean bl, int n4) {
        byte[] byArray = new byte[n2 / 2 + 1];
        DecimalData.convertUnicodeDecimalToPackedDecimal(cArray, n, byArray, 0, n2, n4);
        int n5 = PackedDecimal.checkPackedDecimal(byArray, 0, n2, true, true);
        if (n5 != 0) {
            throw new IllegalArgumentException("The input Unicode is not valid");
        }
        return DecimalData.convertPackedDecimalToBigDecimal(byArray, 0, n2, n3, bl);
    }

    public static void convertBigIntegerToPackedDecimal(BigInteger bigInteger, byte[] byArray, int n, int n2, boolean bl) {
        DecimalData.convertBigDecimalToPackedDecimal(new BigDecimal(bigInteger), byArray, n, n2, bl);
    }

    public static void convertBigIntegerToExternalDecimal(BigInteger bigInteger, byte[] byArray, int n, int n2, boolean bl, int n3) {
        byte[] byArray2 = new byte[n2 / 2 + 1];
        DecimalData.convertBigDecimalToPackedDecimal(new BigDecimal(bigInteger), byArray2, 0, n2, bl);
        DecimalData.convertPackedDecimalToExternalDecimal(byArray2, 0, byArray, n, n2, n3);
    }

    public static void convertBigIntegerToUnicodeDecimal(BigInteger bigInteger, char[] cArray, int n, int n2, boolean bl, int n3) {
        byte[] byArray = new byte[n2 / 2 + 1];
        DecimalData.convertBigDecimalToPackedDecimal(new BigDecimal(bigInteger), byArray, 0, n2, bl);
        DecimalData.convertPackedDecimalToUnicodeDecimal(byArray, 0, cArray, n, n2, n3);
    }

    public static void convertBigDecimalToPackedDecimal(BigDecimal bigDecimal, byte[] byArray, int n, int n2, boolean bl) {
        int n3 = bigDecimal.precision();
        if (n3 <= 9) {
            DecimalData.convertIntegerToPackedDecimal((int)bigDecimal.unscaledValue().longValue(), byArray, n, n2, bl);
            return;
        }
        if (n3 <= 18) {
            DecimalData.convertLongToPackedDecimal(bigDecimal.unscaledValue().longValue(), byArray, n, n2, bl);
            return;
        }
        DecimalData.slowBigDecimalToSignedPacked(bigDecimal, byArray, n, n2, bl);
    }

    public static void convertBigDecimalToExternalDecimal(BigDecimal bigDecimal, byte[] byArray, int n, int n2, boolean bl, int n3) {
        int n4 = bigDecimal.precision();
        if (n4 <= 9) {
            DecimalData.convertIntegerToExternalDecimal((int)bigDecimal.unscaledValue().longValue(), byArray, n, n2, bl, n3);
            return;
        }
        if (n4 <= 18) {
            DecimalData.convertLongToExternalDecimal(bigDecimal.unscaledValue().longValue(), byArray, n, n2, bl, n3);
            return;
        }
        byte[] byArray2 = new byte[n2 / 2 + 1];
        DecimalData.convertBigDecimalToPackedDecimal(bigDecimal, byArray2, 0, n2, bl);
        DecimalData.convertPackedDecimalToExternalDecimal(byArray2, 0, byArray, n, n2, n3);
    }

    public static void convertBigDecimalToUnicodeDecimal(BigDecimal bigDecimal, char[] cArray, int n, int n2, boolean bl, int n3) {
        byte[] byArray = new byte[n2 / 2 + 1];
        DecimalData.convertBigDecimalToPackedDecimal(bigDecimal, byArray, 0, n2, bl);
        DecimalData.convertPackedDecimalToUnicodeDecimal(byArray, 0, cArray, n, n2, n3);
    }

    private static boolean DFPFacilityAvailable() {
        return false;
    }

    private static boolean DFPUseDFP() {
        return false;
    }

    private static BigDecimal createZeroBigDecimal() {
        return new BigDecimal(0);
    }

    private static boolean DFPConvertPackedToDFP(BigDecimal bigDecimal, long l, int n, boolean bl) {
        return false;
    }

    private static long DFPConvertDFPToPacked(long l, boolean bl) {
        return Long.MAX_VALUE;
    }

    private static final int getflags() {
        return 3;
    }

    private static final long getlaside(BigDecimal bigDecimal) {
        return Long.MIN_VALUE;
    }

    private static BigDecimal slowSignedPackedToBigDecimal(byte[] byArray, int n, int n2, int n3, boolean bl) {
        int n4 = (n2 + 2) / 2;
        int n5 = byArray[n + n4 - 1] & 0xF;
        char[] cArray = new char[n4 * 2];
        cArray[0] = n5 == 13 || n5 == 11 ? 45 : 48;
        for (int i = 0; i < n4 - 1; ++i) {
            cArray[2 * i + 1] = (char)(48 + (byArray[i + n] >>> 4 & 0xF));
            cArray[2 * i + 2] = (char)(48 + (byArray[i + n] & 0xF));
        }
        cArray[n4 * 2 - 1] = (char)(48 + (byArray[n + n4 - 1] >>> 4 & 0xF));
        return new BigDecimal(new BigInteger(new String(cArray)), n3);
    }

    private static void slowBigDecimalToSignedPacked(BigDecimal bigDecimal, byte[] byArray, int n, int n2, boolean bl) {
        if (bl && n2 < bigDecimal.precision()) {
            throw new ArithmeticException("Decimal overflow - precision of result Packed Decimal lesser than BigDecimal precision");
        }
        BigInteger bigInteger = bigDecimal.unscaledValue();
        char[] cArray = bigInteger.abs().toString().toCharArray();
        int n3 = cArray.length - 1;
        int n4 = n3 % 2;
        int n5 = (n2 + 2) / 2;
        int n6 = n5 - 2;
        byArray[n + n5 - 1] = (byte)(cArray[n3] - 48 << 4);
        int n7 = n + n5 - 1;
        byArray[n7] = (byte)(byArray[n7] | (byte)(bigInteger.signum() == -1 ? 13 : 12));
        int n8 = n3 - 1;
        while (n8 >= n4 && n + n6 >= 0) {
            byArray[n + n6] = (byte)(cArray[n8] - 48);
            int n9 = n + n6;
            byArray[n9] = (byte)(byArray[n9] | (byte)(cArray[n8 - 1] - 48 << 4));
            n8 -= 2;
            --n6;
        }
        if (n4 > 0 && n + n6 >= 0) {
            byArray[n + n6] = (byte)(cArray[0] - 48);
        }
    }

    private static long convertPackedToLong(byte[] byArray, int n, int n2) {
        if (n2 == 8) {
            return ByteArrayUnmarshaller.readLong(byArray, n, true);
        }
        if (n2 == 4) {
            return (long)ByteArrayUnmarshaller.readInt(byArray, n, true) & 0xFFFFFFFFL;
        }
        long l = 0L;
        for (int i = 0; i < n2; ++i) {
            l <<= 8;
            l += (long)(byArray[n + i] & 0xFF);
        }
        return l;
    }

    private static void convertLongToPacked(long l, byte[] byArray, int n, int n2) {
        if (n2 == 8) {
            ByteArrayMarshaller.writeLong(l, byArray, n, true);
        } else if (n2 == 4) {
            ByteArrayMarshaller.writeInt((int)l, byArray, n, true);
        } else {
            for (int i = n2 - 1; i <= 0; --i) {
                byArray[n + i] = (byte)(l & 0xFFL);
                l >>= 8;
            }
        }
    }

    static {
        int n;
        int n2;
        int n3;
        int n4;
        UNICODE_SIGN_MINUS = (char)45;
        UNICODE_SIGN_PLUS = (char)43;
        UNICODE_ZERO = (char)48;
        PD2EDTranslationTable = new byte[512];
        ED2UDTranslationTable = new byte[256];
        Arrays.fill(PD2EDTranslationTable, (byte)0);
        Arrays.fill(ED2UDTranslationTable, (byte)0);
        for (n4 = 0; n4 < 10; ++n4) {
            for (n3 = 0; n3 < 10; ++n3) {
                n2 = n4 * 16 + n3;
                DecimalData.PD2EDTranslationTable[n2 * 2] = (byte)(0xF0 | n4);
                DecimalData.PD2EDTranslationTable[n2 * 2 + 1] = (byte)(0xF0 | n3);
            }
        }
        for (n4 = 0; n4 < 10; ++n4) {
            n3 = 0xF0 | n4;
            DecimalData.ED2UDTranslationTable[n3 + 1] = (byte)(0x30 | n4);
        }
        BigDecimal bigDecimal = new BigDecimal("0");
        PACKED_BYTES = new byte[200];
        int n5 = 100;
        n3 = 0;
        while (n3 < 100) {
            n2 = n5 % 10;
            n = n5 / 10 % 10;
            DecimalData.PACKED_BYTES[n3] = (byte)((n << 4) + n2);
            ++n3;
            --n5;
        }
        n5 = 0;
        n3 = 100;
        while (n3 < 200) {
            n2 = n5 % 10;
            n = n5 / 10 % 10;
            DecimalData.PACKED_BYTES[n3] = (byte)((n << 4) + n2);
            ++n3;
            ++n5;
        }
    }
}

