/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.shared;

import com.ibm.oti.shared.SharedClassCacheInfo;
import com.ibm.oti.shared.SharedClassesNamedPermission;
import com.ibm.oti.util.Msg;
import java.util.ArrayList;
import java.util.List;

public class SharedClassUtilities {
    public static final int NO_FLAGS = 0;
    public static final int PERSISTENCE_DEFAULT = 0;
    public static final int PERSISTENT = 1;
    public static final int NONPERSISTENT = 2;
    public static final int SNAPSHOT = 5;
    public static final int DESTROYED_ALL_CACHE = 0;
    public static final int DESTROYED_NONE = -1;
    public static final int DESTROY_FAILED_CURRENT_GEN_CACHE = -2;
    public static final int DESTROY_FAILED_OLDER_GEN_CACHE = -3;
    private static final int SHARED_CLASSES_UTILITIES_DISABLED = -255;

    private static native void init();

    private static native int getSharedCacheInfoImpl(String var0, int var1, boolean var2, List<SharedClassCacheInfo> var3);

    private static native int destroySharedCacheImpl(String var0, int var1, String var2, boolean var3);

    public static List<SharedClassCacheInfo> getSharedCacheInfo(String string, int n, boolean bl) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(SharedClassesNamedPermission.SharedPermissions.getSharedCacheInfo);
        }
        if (n != 0) {
            throw new IllegalArgumentException(Msg.getString("K0553", "\"flags\""));
        }
        ArrayList<SharedClassCacheInfo> arrayList = new ArrayList<SharedClassCacheInfo>();
        int n2 = SharedClassUtilities.getSharedCacheInfoImpl(string, n, bl, arrayList);
        if (-1 == n2) {
            return null;
        }
        if (-255 == n2) {
            throw new IllegalStateException(Msg.getString("K0557"));
        }
        return arrayList;
    }

    public static int destroySharedCache(String string, int n, String string2, boolean bl) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(SharedClassesNamedPermission.SharedPermissions.destroySharedCache);
        }
        if (!bl && 0 != n && 1 != n && 2 != n && 5 != n) {
            throw new IllegalArgumentException(Msg.getString("K0553", "\"cacheType\""));
        }
        int n2 = SharedClassUtilities.destroySharedCacheImpl(string, n, string2, bl);
        if (-255 == n2) {
            throw new IllegalStateException(Msg.getString("K0557"));
        }
        return n2;
    }

    @Deprecated
    public SharedClassUtilities() {
    }

    static {
        SharedClassUtilities.init();
    }
}

