/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import com.ibm.oti.util.Msg;
import com.ibm.oti.util.RuntimePermissions;
import java.lang.reflect.Method;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import jdk.internal.misc.TerminatingThreadLocal;
import sun.nio.ch.Interruptible;
import sun.reflect.CallerSensitive;
import sun.security.util.SecurityConstants;

public class Thread
implements Runnable {
    public static final int MAX_PRIORITY = 10;
    public static final int MIN_PRIORITY = 1;
    public static final int NORM_PRIORITY = 5;
    private static int createCount;
    private static Object tidLock;
    private static long tidCount;
    private static final int NANOS_MAX = 999999;
    private static final int INITIAL_LOCAL_STORAGE_CAPACITY = 5;
    static final long NO_REF = 0L;
    private volatile long threadRef;
    long stackSize = 0L;
    private volatile boolean started;
    private String name;
    private int priority = 5;
    private boolean isDaemon;
    private volatile int threadStatus;
    ThreadGroup group;
    private Runnable runnable;
    private boolean stopCalled = false;
    private ClassLoader contextClassLoader;
    ThreadLocal.ThreadLocalMap threadLocals;
    private AccessControlContext inheritedAccessControlContext;
    private Object lock = new ThreadLock();
    ThreadLocal.ThreadLocalMap inheritableThreadLocals;
    private volatile Interruptible blockOn;
    int threadLocalsIndex;
    int inheritableThreadLocalsIndex;
    private volatile UncaughtExceptionHandler exceptionHandler;
    private long tid;
    volatile Object parkBlocker;
    private static ThreadGroup systemThreadGroup;
    private static ThreadGroup mainGroup;
    private static volatile UncaughtExceptionHandler defaultExceptionHandler;
    long threadLocalRandomSeed;
    int threadLocalRandomProbe;
    int threadLocalRandomSecondarySeed;
    private static final StackTraceElement[] EMPTY_STACK_TRACE;

    public Thread() {
        this(null, null, Thread.newName(), null, true);
    }

    private Thread(String string, Object object, int n, boolean bl) {
        String string2 = string == null ? Thread.newName() : string;
        this.setNameImpl(this.threadRef, string2);
        this.name = string2;
        this.isDaemon = bl;
        this.priority = n;
        ThreadGroup threadGroup = null;
        boolean bl2 = false;
        if (mainGroup == null) {
            bl2 = true;
            mainGroup = new ThreadGroup(systemThreadGroup);
        }
        threadGroup = object == null ? mainGroup : (ThreadGroup)object;
        this.initialize(bl2, threadGroup, null, null, true);
        this.group.add(this);
        if (bl2) {
            System.completeInitialization();
        }
    }

    public Thread(Runnable runnable) {
        this(null, runnable, Thread.newName(), null, true);
    }

    Thread(Runnable runnable, AccessControlContext accessControlContext) {
        this(null, runnable, Thread.newName(), accessControlContext, false);
    }

    public Thread(Runnable runnable, String string) {
        this(null, runnable, string, null, true);
    }

    public Thread(String string) {
        this(null, null, string, null, true);
    }

    public Thread(ThreadGroup threadGroup, Runnable runnable) {
        this(threadGroup, runnable, Thread.newName(), null, true);
    }

    public Thread(ThreadGroup threadGroup, Runnable runnable, String string, long l) {
        this(threadGroup, runnable, string, null, true);
        this.stackSize = l;
    }

    public Thread(ThreadGroup threadGroup, Runnable runnable, String string) {
        this(threadGroup, runnable, string, null, true);
    }

    Thread(Runnable runnable, String string, boolean bl, boolean bl2, boolean bl3, ClassLoader classLoader) {
        this(bl ? systemThreadGroup : null, runnable, string, null, bl2);
        this.isDaemon = bl3;
        this.contextClassLoader = classLoader;
    }

    private Thread(ThreadGroup threadGroup, Runnable runnable, String string, AccessControlContext accessControlContext, boolean bl) {
        SecurityManager securityManager;
        if (string == null) {
            throw new NullPointerException();
        }
        this.name = string;
        this.runnable = runnable;
        Thread thread = Thread.currentThread();
        this.isDaemon = thread.isDaemon();
        if (threadGroup == null && (securityManager = System.getSecurityManager()) != null) {
            threadGroup = securityManager.getThreadGroup();
        }
        if (threadGroup == null) {
            threadGroup = thread.getThreadGroup();
        }
        this.initialize(false, threadGroup, thread, accessControlContext, bl);
        this.setPriority(thread.getPriority());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize(boolean bl, ThreadGroup threadGroup, Thread thread, AccessControlContext accessControlContext, boolean bl2) {
        Object object = tidLock;
        synchronized (object) {
            this.tid = tidCount++;
        }
        this.group = threadGroup;
        if (bl) {
            System.afterClinitInitialization();
        }
        if (thread != null) {
            boolean bl3;
            if (bl2 && null != thread.inheritableThreadLocals) {
                this.inheritableThreadLocals = ThreadLocal.createInheritedMap(thread.inheritableThreadLocals);
            }
            object = System.getSecurityManager();
            final Class<? extends Object> clazz = this.getClass();
            final Class<Thread> clazz2 = Thread.class;
            if (object != null && clazz != clazz2 && (bl3 = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    Method method;
                    try {
                        method = clazz.getMethod("getContextClassLoader", new Class[0]);
                        if (method.getDeclaringClass() != clazz2) {
                            return Boolean.TRUE;
                        }
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                    try {
                        method = clazz.getDeclaredMethod("setContextClassLoader", ClassLoader.class);
                        if (method.getDeclaringClass() != clazz2) {
                            return Boolean.TRUE;
                        }
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                    return Boolean.FALSE;
                }
            }).booleanValue())) {
                ((SecurityManager)object).checkPermission(RuntimePermissions.permissionEnableContextClassLoaderOverride);
            }
            this.contextClassLoader = thread.getContextClassLoader();
        } else {
            if (bl) {
                try {
                    Class.forName("com.ibm.jit.JITHelpers");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                ClassLoader.initializeClassLoaders();
            }
            this.contextClassLoader = ClassLoader.getSystemClassLoader();
        }
        threadGroup.checkAccess();
        threadGroup.checkNewThread(this);
        this.inheritedAccessControlContext = accessControlContext == null ? AccessController.getContext() : accessControlContext;
    }

    public Thread(ThreadGroup threadGroup, String string) {
        this(threadGroup, null, string, null, true);
    }

    public static int activeCount() {
        return Thread.currentThread().getThreadGroup().activeCount();
    }

    public final void checkAccess() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkAccess(this);
        }
    }

    @Deprecated
    public int countStackFrames() {
        return 0;
    }

    public static native Thread currentThread();

    @Deprecated
    public void destroy() {
        throw new NoSuchMethodError();
    }

    public static void dumpStack() {
        new Throwable().printStackTrace();
    }

    public static int enumerate(Thread[] threadArray) {
        return Thread.currentThread().getThreadGroup().enumerate(threadArray, true);
    }

    @CallerSensitive
    public ClassLoader getContextClassLoader() {
        ClassLoader classLoader;
        if (this.contextClassLoader == null) {
            return null;
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null && ClassLoader.needsClassLoaderPermissionCheck(classLoader = ClassLoader.callerClassLoader(), this.contextClassLoader)) {
            securityManager.checkPermission(SecurityConstants.GET_CLASSLOADER_PERMISSION);
        }
        return this.contextClassLoader;
    }

    public final String getName() {
        return this.name;
    }

    public final int getPriority() {
        return this.priority;
    }

    public final ThreadGroup getThreadGroup() {
        return this.group;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interrupt() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null && Thread.currentThread() != this) {
            securityManager.checkAccess(this);
        }
        Object object = this.lock;
        synchronized (object) {
            this.interruptImpl();
            Interruptible interruptible = this.blockOn;
            if (interruptible != null) {
                interruptible.interrupt(this);
            }
        }
    }

    public static boolean interrupted() {
        return Thread.interruptedImpl();
    }

    private static native boolean interruptedImpl();

    private native void interruptImpl();

    public final boolean isAlive() {
        return this.threadRef != 0L;
    }

    private boolean isDead() {
        return this.started && this.threadRef == 0L;
    }

    public final boolean isDaemon() {
        return this.isDaemon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInterrupted() {
        Object object = this.lock;
        synchronized (object) {
            return this.isInterruptedImpl();
        }
    }

    private native boolean isInterruptedImpl();

    public final synchronized void join() throws InterruptedException {
        this.join(0L, 0);
    }

    public final void join(long l) throws InterruptedException {
        this.join(l, 0);
    }

    public final synchronized void join(long l, int n) throws InterruptedException {
        if (l < 0L || n < 0 || n > 999999) {
            throw new IllegalArgumentException();
        }
        if (!this.started || this.isDead()) {
            return;
        }
        if (l == 0L && n == 0) {
            while (!this.isDead()) {
                this.wait(0L);
            }
            return;
        }
        long l2 = TimeUnit.MILLISECONDS.toNanos(l);
        l2 = Long.MAX_VALUE - l2 >= (long)n ? (l2 += (long)n) : Long.MAX_VALUE;
        while (!this.isDead()) {
            long l3 = System.nanoTime();
            TimeUnit.NANOSECONDS.timedWait(this, l2);
            long l4 = System.nanoTime() - l3;
            if (l4 >= l2) break;
            l2 -= l4;
        }
    }

    private static synchronized String newName() {
        return "Thread-" + createCount++;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public final void resume() {
        this.checkAccess();
        Object object = this.lock;
        synchronized (object) {
            this.resumeImpl();
        }
    }

    private native void resumeImpl();

    @Override
    public void run() {
        if (this.runnable != null) {
            this.runnable.run();
        }
    }

    public void setContextClassLoader(ClassLoader classLoader) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(RuntimePermissions.permissionSetContextClassLoader);
        }
        this.contextClassLoader = classLoader;
    }

    void internalSetContextClassLoader(ClassLoader classLoader) {
        this.contextClassLoader = classLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setDaemon(boolean bl) {
        this.checkAccess();
        Object object = this.lock;
        synchronized (object) {
            if (!this.started) {
                this.isDaemon = bl;
            } else if (this.isAlive()) {
                throw new IllegalThreadStateException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setName(String string) {
        this.checkAccess();
        if (string == null) {
            throw new NullPointerException();
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.started && this.threadRef != 0L) {
                this.setNameImpl(this.threadRef, string);
            }
            this.name = string;
        }
    }

    private native void setNameImpl(long var1, String var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setPriority(int n) {
        this.checkAccess();
        if (1 <= n && n <= 10) {
            ThreadGroup threadGroup = this.getThreadGroup();
            if (null != threadGroup) {
                int n2 = n;
                int n3 = threadGroup.getMaxPriority();
                if (n3 < n) {
                    n2 = n3;
                }
                this.priority = n2;
                Object object = this.lock;
                synchronized (object) {
                    if (this.started && 0L != this.threadRef) {
                        this.setPriorityNoVMAccessImpl(this.threadRef, n2);
                    }
                }
            }
            return;
        }
        throw new IllegalArgumentException();
    }

    private native void setPriorityNoVMAccessImpl(long var1, int var3);

    public static void sleep(long l) throws InterruptedException {
        Thread.sleep(l, 0);
    }

    public static void sleep(long l, int n) throws InterruptedException {
        Thread.sleepImpl(l, n);
    }

    private static native void sleepImpl(long var0, int var2) throws InterruptedException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void start() {
        boolean bl = false;
        if (this.started) {
            throw new IllegalThreadStateException(Msg.getString("K0341"));
        }
        this.group.add(this);
        try {
            Object object = this.lock;
            synchronized (object) {
                this.startImpl();
                bl = true;
            }
        }
        finally {
            if (!bl) {
                this.group.remove(this);
            }
        }
    }

    private native void startImpl();

    @Deprecated
    public final void stop() {
        if (!this.isDead()) {
            this.stopWithThrowable(new ThreadDeath());
        }
    }

    @Deprecated
    public final void stop(Throwable throwable) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final synchronized void stopWithThrowable(Throwable throwable) {
        Object object;
        this.checkAccess();
        if (!(Thread.currentThread() == this && throwable instanceof ThreadDeath || (object = System.getSecurityManager()) == null)) {
            ((SecurityManager)object).checkPermission(SecurityConstants.STOP_THREAD_PERMISSION);
        }
        object = this.lock;
        synchronized (object) {
            if (throwable != null) {
                if (!this.started) {
                    this.stopCalled = true;
                } else {
                    this.stopImpl(throwable);
                }
            } else {
                throw new NullPointerException();
            }
        }
    }

    private native void stopImpl(Throwable var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public final void suspend() {
        this.checkAccess();
        if (Thread.currentThread() == this) {
            this.suspendImpl();
        } else {
            Object object = this.lock;
            synchronized (object) {
                this.suspendImpl();
            }
        }
    }

    private native void suspendImpl();

    public String toString() {
        ThreadGroup threadGroup = this.getThreadGroup();
        return "Thread[" + this.getName() + "," + this.getPriority() + "," + (null == threadGroup ? "" : threadGroup.getName()) + "]";
    }

    public static native void yield();

    public static native boolean holdsLock(Object var0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void blockedOn(Interruptible interruptible) {
        Thread thread = this;
        Object object = thread.lock;
        synchronized (object) {
            thread.blockOn = interruptible;
        }
    }

    private native Throwable getStackTraceImpl();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StackTraceElement[] getStackTrace() {
        Object object;
        if (Thread.currentThread() != this && (object = System.getSecurityManager()) != null) {
            ((SecurityManager)object).checkPermission(SecurityConstants.GET_STACK_TRACE_PERMISSION);
        }
        Object object2 = this.lock;
        synchronized (object2) {
            if (!this.isAlive()) {
                return EMPTY_STACK_TRACE;
            }
            object = this.getStackTraceImpl();
        }
        return J9VMInternals.getStackTrace((Throwable)object, false);
    }

    public static Map<Thread, StackTraceElement[]> getAllStackTraces() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(SecurityConstants.GET_STACK_TRACE_PERMISSION);
            securityManager.checkPermission(SecurityConstants.MODIFY_THREADGROUP_PERMISSION);
        }
        int n = systemThreadGroup.activeCount() + 20;
        Thread[] threadArray = new Thread[n];
        n = systemThreadGroup.enumerate(threadArray);
        HashMap<Thread, StackTraceElement[]> hashMap = new HashMap<Thread, StackTraceElement[]>(n * 4 / 3);
        for (int i = 0; i < n; ++i) {
            hashMap.put(threadArray[i], threadArray[i].getStackTrace());
        }
        return hashMap;
    }

    public long getId() {
        return this.tid;
    }

    public UncaughtExceptionHandler getUncaughtExceptionHandler() {
        if (this.exceptionHandler == null) {
            return this.getThreadGroup();
        }
        return this.exceptionHandler;
    }

    public void setUncaughtExceptionHandler(UncaughtExceptionHandler uncaughtExceptionHandler) {
        this.exceptionHandler = uncaughtExceptionHandler;
    }

    public static UncaughtExceptionHandler getDefaultUncaughtExceptionHandler() {
        return defaultExceptionHandler;
    }

    public static void setDefaultUncaughtExceptionHandler(UncaughtExceptionHandler uncaughtExceptionHandler) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(RuntimePermissions.permissionSetDefaultUncaughtExceptionHandler);
        }
        defaultExceptionHandler = uncaughtExceptionHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private State translateJ9VMThreadStateToThreadState(int n) {
        switch (n) {
            case 1: {
                return State.RUNNABLE;
            }
            case 2: {
                return State.BLOCKED;
            }
            case 4: 
            case 128: {
                return State.WAITING;
            }
            case 8: 
            case 64: 
            case 256: {
                return State.TIMED_WAITING;
            }
            case 32: {
                return State.TERMINATED;
            }
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.threadRef == 0L) {
                return State.TERMINATED;
            }
            return State.values()[this.getStateImpl(this.threadRef)];
        }
    }

    public State getState() {
        if (this.started) {
            if (this.threadRef == 0L) {
                return State.TERMINATED;
            }
            return this.translateJ9VMThreadStateToThreadState(this.threadStatus);
        }
        return State.NEW;
    }

    private native int getStateImpl(long var1);

    void uncaughtException(Throwable throwable) {
        UncaughtExceptionHandler uncaughtExceptionHandler = this.getUncaughtExceptionHandler();
        if (uncaughtExceptionHandler != null) {
            uncaughtExceptionHandler.uncaughtException(this, throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void exit() {
        try {
            if (this.threadLocals != null && TerminatingThreadLocal.REGISTRY.isPresent()) {
                TerminatingThreadLocal.threadTerminated();
            }
            this.group = null;
            this.runnable = null;
            this.inheritedAccessControlContext = null;
            this.threadLocals = null;
            this.inheritableThreadLocals = null;
        }
        finally {
            Object object = this.lock;
            synchronized (object) {
                this.threadRef = 0L;
            }
        }
    }

    protected Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    static {
        tidLock = new TidLock();
        tidCount = 1L;
        EMPTY_STACK_TRACE = new StackTraceElement[0];
    }

    public static enum State {
        NEW,
        RUNNABLE,
        BLOCKED,
        WAITING,
        TIMED_WAITING,
        TERMINATED;

    }

    @FunctionalInterface
    public static interface UncaughtExceptionHandler {
        public void uncaughtException(Thread var1, Throwable var2);
    }

    private static final class ThreadLock {
        private ThreadLock() {
        }
    }

    private static final class TidLock {
        TidLock() {
        }
    }
}

