/*
 * Decompiled with CFR 0.152.
 */
package java.lang.ref;

import java.lang.ref.Reference;
import java.util.function.Consumer;
import sun.misc.Cleaner;

public class ReferenceQueue<T> {
    private Reference[] references;
    private int head = 0;
    private int tail = 0;
    private boolean empty = true;
    private static final int DEFAULT_QUEUE_SIZE = 128;
    private static final Class reflectRefClass;
    private static final Class classNameLockRefClass;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Reference<? extends T> poll() {
        Reference reference;
        if (this.empty) {
            return null;
        }
        ReferenceQueue referenceQueue = this;
        synchronized (referenceQueue) {
            if (this.empty) {
                return null;
            }
            reference = this.references[this.head];
            this.references[this.head++] = null;
            reference.dequeue();
            if (this.head == this.references.length) {
                this.head = 0;
            }
            if (this.head == this.tail) {
                this.empty = true;
            }
        }
        return reference;
    }

    public Reference<? extends T> remove() throws InterruptedException {
        return this.remove(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Reference<? extends T> remove(long l) throws IllegalArgumentException, InterruptedException {
        Reference reference;
        if (l < 0L) {
            throw new IllegalArgumentException();
        }
        ReferenceQueue referenceQueue = this;
        synchronized (referenceQueue) {
            if (this.empty) {
                this.wait(l);
                if (this.empty) {
                    return null;
                }
            }
            reference = this.references[this.head];
            this.references[this.head++] = null;
            reference.dequeue();
            if (this.head == this.references.length) {
                this.head = 0;
            }
            if (this.head == this.tail) {
                this.empty = true;
            } else {
                this.notifyAll();
            }
        }
        return reference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void enqueue(Reference<? extends T> reference) {
        if (reference instanceof Cleaner) {
            reference.dequeue();
            ((Cleaner)reference).clean();
            return;
        }
        Class<? extends Object> clazz = reference.getClass();
        if (clazz == reflectRefClass || clazz == classNameLockRefClass) {
            reference.dequeue();
            ((Runnable)((Object)reference)).run();
            return;
        }
        ReferenceQueue referenceQueue = this;
        synchronized (referenceQueue) {
            if (this.references == null) {
                this.references = new Reference[128];
            } else if (!this.empty && this.head == this.tail) {
                int n = (int)((double)this.references.length * 1.1);
                Reference[] referenceArray = new Reference[n];
                System.arraycopy((Object)this.references, this.head, (Object)referenceArray, 0, this.references.length - this.head);
                if (this.tail > 0) {
                    System.arraycopy((Object)this.references, 0, (Object)referenceArray, this.references.length - this.head, this.tail);
                }
                this.head = 0;
                this.tail = this.references.length;
                this.references = referenceArray;
            }
            this.references[this.tail++] = reference;
            if (this.tail == this.references.length) {
                this.tail = 0;
            }
            this.empty = false;
            reference.setEnqueued();
            this.notifyAll();
        }
    }

    void forEach(Consumer<? super Reference<? extends T>> consumer) {
    }

    static {
        Class<Cleaner> clazz = Cleaner.class;
        Class<?> clazz2 = null;
        try {
            clazz2 = Class.forName("java.lang.Class$ReflectRef");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        reflectRefClass = clazz2;
        Class<?> clazz3 = null;
        try {
            clazz3 = Class.forName("java.lang.ClassLoader$ClassNameLockRef");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        classNameLockRefClass = clazz3;
    }
}

