/*
 * Decompiled with CFR 0.152.
 */
package jdk.crypto.jniprovider;

import com.ibm.oti.vm.VM;
import java.security.AccessController;
import sun.misc.Cleaner;
import sun.reflect.CallerSensitive;
import sun.reflect.Reflection;
import sun.security.action.GetPropertyAction;

public class NativeCrypto {
    public static final int MD5 = 0;
    public static final int SHA1_160 = 1;
    public static final int SHA2_224 = 2;
    public static final int SHA2_256 = 3;
    public static final int SHA5_384 = 4;
    public static final int SHA5_512 = 5;
    public static final int SHA5_512_224 = 6;
    public static final int SHA5_512_256 = 7;
    public static final int ECField_Fp = 0;
    public static final int ECField_F2m = 1;
    public static final long OPENSSL_VERSION_1_0_0 = 0x10000000L;
    public static final long OPENSSL_VERSION_1_1_0 = 0x10100000L;
    public static final long OPENSSL_VERSION_1_1_1 = 0x10101000L;
    public static final long OPENSSL_VERSION_3_0_0 = 0x30000000L;
    private static final boolean useNativeCrypto = Boolean.parseBoolean(GetPropertyAction.privilegedGetProperty("jdk.nativeCrypto", "true"));
    private static final boolean traceEnabled = Boolean.parseBoolean(GetPropertyAction.privilegedGetProperty("jdk.nativeCryptoTrace", "false"));
    private final long ossl_ver = AccessController.doPrivileged(() -> NativeCrypto.loadCryptoLibraries());
    private final boolean isOpenSSLFIPS = this.ossl_ver != -1L ? NativeCrypto.isOpenSSLFIPS() : false;

    private static long loadCryptoLibraries() {
        long l;
        try {
            System.loadLibrary("jncrypto");
            boolean bl = Boolean.parseBoolean(GetPropertyAction.privilegedGetProperty("jdk.native.openssl.skipBundled"));
            String string = GetPropertyAction.privilegedGetProperty("jdk.native.openssl.lib");
            if (bl && string != null) {
                throw new RuntimeException("Conflicting properties jdk.native.openssl.skipBundled and jdk.native.openssl.lib");
            }
            String string2 = System.getProperty("java.home");
            l = NativeCrypto.loadCrypto(traceEnabled, bl, string, string2);
            if (l != -1L) {
                if (traceEnabled) {
                    System.err.println("Native crypto library load succeeded - using native crypto library.");
                }
            } else if (string != null && !string.isEmpty()) {
                throw new RuntimeException(string + " is not available, crypto libraries are not loaded");
            }
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            if (traceEnabled) {
                System.err.println("UnsatisfiedLinkError: Failure attempting to load jncrypto JNI library");
                System.err.println("Warning: Native crypto library load failed. Using Java crypto implementation.");
            }
            l = -1L;
        }
        return l;
    }

    private NativeCrypto() {
    }

    public static final boolean isAllowedAndLoaded() {
        return NativeCrypto.getVersionIfAvailable() >= 0L;
    }

    public static final long getVersionIfAvailable() {
        return InstanceHolder.instance.ossl_ver;
    }

    public static final boolean isAlgorithmEnabled(String string, String string2) {
        return NativeCrypto.isAlgorithmEnabled(string, string2, true, null);
    }

    public static final boolean isAlgorithmEnabled(String string, String string2, boolean bl, String string3) {
        boolean bl2 = false;
        if (useNativeCrypto) {
            bl2 = Boolean.parseBoolean(GetPropertyAction.privilegedGetProperty(string, "true"));
        }
        if (bl2) {
            if (NativeCrypto.isAllowedAndLoaded()) {
                if (bl) {
                    if (traceEnabled) {
                        System.err.println(string2 + " - using native crypto library.");
                    }
                } else {
                    bl2 = false;
                    if (traceEnabled) {
                        System.err.println("Warning: " + string2 + " native requirements not satisfied. " + string3 + " Using Java crypto implementation.");
                    }
                }
            } else {
                bl2 = false;
                if (traceEnabled) {
                    System.err.println("Warning: Native crypto library load failed. Using Java crypto implementation.");
                }
            }
        } else if (traceEnabled) {
            System.err.println(string2 + " native crypto implementation disabled. Using Java crypto implementation.");
        }
        return bl2;
    }

    public static final boolean isEnabled() {
        return useNativeCrypto;
    }

    public static final boolean isTraceEnabled() {
        return traceEnabled;
    }

    public static final boolean isOpenSSLFIPSVersion() {
        return InstanceHolder.instance.isOpenSSLFIPS;
    }

    public static final boolean isAlgorithmAvailable(String string) {
        boolean bl = false;
        if (NativeCrypto.isAllowedAndLoaded()) {
            if (NativeCrypto.isOpenSSLFIPSVersion()) {
                switch (string) {
                    case "MD5": {
                        break;
                    }
                    default: {
                        bl = true;
                        break;
                    }
                }
            } else {
                switch (string) {
                    case "MD5": {
                        bl = NativeCrypto.isMD5Available();
                        break;
                    }
                    default: {
                        bl = true;
                    }
                }
            }
        }
        if (traceEnabled) {
            if (bl) {
                System.err.println(string + " native crypto implementation is available.");
            } else {
                System.err.println(string + " native crypto implementation is not available.");
            }
        }
        return bl;
    }

    @CallerSensitive
    public static NativeCrypto getNativeCrypto() {
        ClassLoader classLoader = Reflection.getCallerClass().getClassLoader();
        if (classLoader == null || classLoader == VM.getVMLangAccess().getExtClassLoader()) {
            return InstanceHolder.instance;
        }
        throw new SecurityException("NativeCrypto");
    }

    public void createECKeyCleaner(Object object, final long l) {
        Cleaner.create(object, new Runnable(){

            @Override
            public void run() {
                NativeCrypto.this.ECDestroyKey(l);
            }
        });
    }

    private static final native long loadCrypto(boolean var0, boolean var1, String var2, String var3);

    public static final native boolean isMD5Available();

    private static final native boolean isOpenSSLFIPS();

    public final native long DigestCreateContext(long var1, int var3);

    public final native int DigestDestroyContext(long var1);

    public final native int DigestUpdate(long var1, byte[] var3, int var4, int var5);

    public final native int DigestComputeAndReset(long var1, byte[] var3, int var4, int var5, byte[] var6, int var7, int var8);

    public final native int DigestReset(long var1);

    public final native long CreateContext();

    public final native int DestroyContext(long var1);

    public final native int CBCInit(long var1, int var3, byte[] var4, int var5, byte[] var6, int var7, boolean var8);

    public final native int CBCUpdate(long var1, byte[] var3, int var4, int var5, byte[] var6, int var7);

    public final native int CBCFinalEncrypt(long var1, byte[] var3, int var4, int var5, byte[] var6, int var7);

    public final native int GCMEncrypt(long var1, byte[] var3, int var4, byte[] var5, int var6, byte[] var7, int var8, int var9, byte[] var10, int var11, byte[] var12, int var13, int var14, boolean var15, boolean var16);

    public final native int GCMDecrypt(long var1, byte[] var3, int var4, byte[] var5, int var6, byte[] var7, int var8, int var9, byte[] var10, int var11, byte[] var12, int var13, int var14, boolean var15, boolean var16);

    public final native long createRSAPublicKey(byte[] var1, int var2, byte[] var3, int var4);

    public final native long createRSAPrivateCrtKey(byte[] var1, int var2, byte[] var3, int var4, byte[] var5, int var6, byte[] var7, int var8, byte[] var9, int var10, byte[] var11, int var12, byte[] var13, int var14, byte[] var15, int var16);

    public final native void destroyRSAKey(long var1);

    public final native int RSADP(byte[] var1, int var2, byte[] var3, int var4, long var5);

    public final native int RSAEP(byte[] var1, int var2, byte[] var3, long var4);

    public final native int ECGenerateKeyPair(long var1, byte[] var3, int var4, byte[] var5, int var6, byte[] var7, int var8, int var9);

    public final native int ECCreatePublicKey(long var1, byte[] var3, int var4, byte[] var5, int var6, int var7);

    public final native int ECCreatePrivateKey(long var1, byte[] var3, int var4);

    public final native long ECEncodeGF(int var1, byte[] var2, int var3, byte[] var4, int var5, byte[] var6, int var7, byte[] var8, int var9, byte[] var10, int var11, byte[] var12, int var13, byte[] var14, int var15);

    public final native int ECDestroyKey(long var1);

    public final native int ECDeriveKey(long var1, long var3, byte[] var5, int var6, int var7);

    public final native boolean ECNativeGF2m();

    public final native int PBEDerive(byte[] var1, int var2, byte[] var3, int var4, byte[] var5, int var6, int var7, int var8, int var9);

    public final native int ECDSASign(long var1, byte[] var3, int var4, byte[] var5, int var6);

    public final native int ECDSAVerify(long var1, byte[] var3, int var4, byte[] var5, int var6);

    public final native byte[] PBKDF2Derive(byte[] var1, byte[] var2, int var3, int var4, int var5);

    private static final class InstanceHolder {
        static final NativeCrypto instance = new NativeCrypto();

        private InstanceHolder() {
        }
    }
}

