/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.utils;

import com.sun.org.apache.xml.internal.security.utils.UnsyncByteArrayOutputStream;
import com.sun.org.slf4j.internal.Logger;
import com.sun.org.slf4j.internal.LoggerFactory;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.SecurityPermission;

public final class JavaUtils {
    private static final Logger LOG = LoggerFactory.getLogger(JavaUtils.class);
    private static final SecurityPermission REGISTER_PERMISSION = new SecurityPermission("com.sun.org.apache.xml.internal.security.register");

    private JavaUtils() {
    }

    public static byte[] getBytesFromFile(String string) throws FileNotFoundException, IOException {
        byte[] byArray = null;
        try (InputStream inputStream = Files.newInputStream(Paths.get(string, new String[0]), new OpenOption[0]);
             UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();){
            int n;
            byte[] byArray2 = new byte[1024];
            while ((n = inputStream.read(byArray2)) > 0) {
                unsyncByteArrayOutputStream.write(byArray2, 0, n);
            }
            byArray = unsyncByteArrayOutputStream.toByteArray();
        }
        return byArray;
    }

    public static void writeBytesToFilename(String string, byte[] byArray) {
        if (string != null && byArray != null) {
            try (OutputStream outputStream = Files.newOutputStream(Paths.get(string, new String[0]), new OpenOption[0]);){
                outputStream.write(byArray);
            }
            catch (IOException iOException) {
                LOG.debug(iOException.getMessage(), iOException);
            }
        } else {
            LOG.debug("writeBytesToFilename got null byte[] pointed");
        }
    }

    public static byte[] getBytesFromStream(InputStream inputStream) throws IOException {
        try (UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();){
            int n;
            byte[] byArray = new byte[4096];
            while ((n = inputStream.read(byArray)) > 0) {
                unsyncByteArrayOutputStream.write(byArray, 0, n);
            }
            byte[] byArray2 = unsyncByteArrayOutputStream.toByteArray();
            return byArray2;
        }
    }

    public static byte[] convertDsaASN1toXMLDSIG(byte[] byArray, int n) throws IOException {
        int n2;
        int n3;
        int n4;
        int n5;
        if (byArray[0] != 48 || byArray[1] != byArray.length - 2 || byArray[2] != 2) {
            throw new IOException("Invalid ASN.1 format of DSA signature");
        }
        for (n5 = n4 = byArray[3]; n5 > 0 && byArray[4 + n4 - n5] == 0; --n5) {
        }
        for (n3 = n2 = byArray[5 + n4]; n3 > 0 && byArray[6 + n4 + n2 - n3] == 0; --n3) {
        }
        if (n5 > n || byArray[4 + n4] != 2 || n3 > n) {
            throw new IOException("Invalid ASN.1 format of DSA signature");
        }
        byte[] byArray2 = new byte[n * 2];
        System.arraycopy((Object)byArray, 4 + n4 - n5, (Object)byArray2, n - n5, n5);
        System.arraycopy((Object)byArray, 6 + n4 + n2 - n3, (Object)byArray2, n * 2 - n3, n3);
        return byArray2;
    }

    public static byte[] convertDsaXMLDSIGtoASN1(byte[] byArray, int n) throws IOException {
        int n2;
        int n3;
        int n4 = n * 2;
        if (byArray.length != n4) {
            throw new IOException("Invalid XMLDSIG format of DSA signature");
        }
        for (n3 = n; n3 > 0 && byArray[n - n3] == 0; --n3) {
        }
        int n5 = n3;
        if (byArray[n - n3] < 0) {
            ++n5;
        }
        for (n2 = n; n2 > 0 && byArray[n4 - n2] == 0; --n2) {
        }
        int n6 = n2;
        if (byArray[n4 - n2] < 0) {
            ++n6;
        }
        byte[] byArray2 = new byte[6 + n5 + n6];
        byArray2[0] = 48;
        byArray2[1] = (byte)(4 + n5 + n6);
        byArray2[2] = 2;
        byArray2[3] = (byte)n5;
        System.arraycopy((Object)byArray, n - n3, (Object)byArray2, 4 + n5 - n3, n3);
        byArray2[4 + n5] = 2;
        byArray2[5 + n5] = (byte)n6;
        System.arraycopy((Object)byArray, n4 - n2, (Object)byArray2, 6 + n5 + n6 - n2, n2);
        return byArray2;
    }

    public static void checkRegisterPermission() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(REGISTER_PERMISSION);
        }
    }
}

