/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview.tools.impl;

import com.ibm.jvm.dtfjview.tools.CommandException;
import com.ibm.jvm.dtfjview.tools.Tool;
import com.ibm.jvm.dtfjview.tools.ToolsRegistry;
import java.io.PrintStream;
import java.util.LinkedList;

public class HistoryTool
extends Tool {
    public static final String COMMAND = "history";
    public static final String COMMAND_SHORT = "his";
    public static final int DEFAULT_DISPLAY_N = 20;
    public static final String ARGUMENT_DESCRIPTION = "[-r] [N]";
    public static final String HELP_DESCRIPTION = "     If option -r is used, the Nth history command (default to the last one) will be run;\n     otherwise, at most N (default 20) history commands will be displayed.";
    public static final String USAGE = "history|his\t[-r] [N]\n     If option -r is used, the Nth history command (default to the last one) will be run;\n     otherwise, at most N (default 20) history commands will be displayed.";
    private LinkedList<String> history = new LinkedList();
    private int defaultExecutingIndex = -1;

    public void record(String string) {
        this.history.add(string);
        this.defaultExecutingIndex = this.history.size() - 1;
    }

    @Override
    public void process(String string, String[] stringArray, PrintStream printStream) throws CommandException {
        int n = 20;
        boolean bl = false;
        if (stringArray.length == 0) {
            this.showHistoryCommands(20, printStream);
            return;
        }
        if (stringArray.length > 0) {
            if (stringArray[0].startsWith("-r")) {
                bl = true;
                n = this.defaultExecutingIndex;
                if (stringArray[0].length() > 2) {
                    try {
                        n = Integer.parseInt(stringArray[0].substring(2));
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.printDetailedHelp(printStream);
                        return;
                    }
                } else if (stringArray.length > 1) {
                    try {
                        n = Integer.parseInt(stringArray[1]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.printDetailedHelp(printStream);
                        return;
                    }
                }
            } else {
                try {
                    n = Integer.parseInt(stringArray[0]);
                }
                catch (NumberFormatException numberFormatException) {
                    this.printDetailedHelp(printStream);
                    return;
                }
            }
        }
        if (bl) {
            this.defaultExecutingIndex = n - 1;
            this.executeHistoryCommand(n, printStream);
        } else {
            this.showHistoryCommands(n, printStream);
        }
    }

    @Override
    public boolean accept(String string, String[] stringArray) {
        return string.equalsIgnoreCase(COMMAND_SHORT) || string.equalsIgnoreCase(COMMAND);
    }

    @Override
    public void printDetailedHelp(PrintStream printStream) {
        printStream.println(USAGE);
    }

    @Override
    public String getCommandName() {
        return COMMAND;
    }

    @Override
    public String getArgumentDescription() {
        return ARGUMENT_DESCRIPTION;
    }

    @Override
    public String getHelpDescription() {
        return HELP_DESCRIPTION;
    }

    private void executeHistoryCommand(int n, PrintStream printStream) throws CommandException {
        if (this.history.size() == 0) {
            printStream.println("The history repository is empty.");
            return;
        }
        if (n < 0 || n > this.history.size() - 1) {
            printStream.println("The number " + n + " is not a valid sequence number in history repository.");
            return;
        }
        ToolsRegistry.process(this.history.get(n), printStream);
    }

    private void showHistoryCommands(int n, PrintStream printStream) {
        if (n <= 0) {
            printStream.println("The number " + n + " is not a valid counter.");
            return;
        }
        if (this.history.size() == 0) {
            printStream.println("The history repository is empty.");
            return;
        }
        n = Math.min(n, this.history.size());
        for (int i = this.history.size() - n; i < this.history.size(); ++i) {
            printStream.println(i + " : " + this.history.get(i));
        }
    }
}

