/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.GeneratedFieldAccessor;
import com.ibm.j9ddr.GeneratedPointerClass;
import com.ibm.j9ddr.vm29.pointer.AbstractPointer;
import com.ibm.j9ddr.vm29.pointer.StructurePointer;
import com.ibm.j9ddr.vm29.pointer.UDATAPointer;
import com.ibm.j9ddr.vm29.structure.J9Heap;
import com.ibm.j9ddr.vm29.types.Scalar;
import com.ibm.j9ddr.vm29.types.U32;
import com.ibm.j9ddr.vm29.types.UDATA;

@GeneratedPointerClass(structureClass=J9Heap.class)
public class J9HeapPointer
extends StructurePointer {
    public static final J9HeapPointer NULL = new J9HeapPointer(0L);

    protected J9HeapPointer(long l) {
        super(l);
    }

    public static J9HeapPointer cast(AbstractPointer abstractPointer) {
        return J9HeapPointer.cast(abstractPointer.getAddress());
    }

    public static J9HeapPointer cast(UDATA uDATA) {
        return J9HeapPointer.cast(uDATA.longValue());
    }

    public static J9HeapPointer cast(long l) {
        if (l == 0L) {
            return NULL;
        }
        return new J9HeapPointer(l);
    }

    @Override
    public J9HeapPointer add(long l) {
        return J9HeapPointer.cast(this.address + J9Heap.SIZEOF * l);
    }

    @Override
    public J9HeapPointer add(Scalar scalar) {
        return this.add(scalar.longValue());
    }

    @Override
    public J9HeapPointer addOffset(long l) {
        return J9HeapPointer.cast(this.address + l);
    }

    @Override
    public J9HeapPointer addOffset(Scalar scalar) {
        return this.addOffset(scalar.longValue());
    }

    @Override
    public J9HeapPointer sub(long l) {
        return J9HeapPointer.cast(this.address - J9Heap.SIZEOF * l);
    }

    @Override
    public J9HeapPointer sub(Scalar scalar) {
        return this.sub(scalar.longValue());
    }

    @Override
    public J9HeapPointer subOffset(long l) {
        return J9HeapPointer.cast(this.address - l);
    }

    @Override
    public J9HeapPointer subOffset(Scalar scalar) {
        return this.subOffset(scalar.longValue());
    }

    @Override
    public J9HeapPointer untag(long l) {
        return J9HeapPointer.cast(this.address & (l ^ 0xFFFFFFFFFFFFFFFFL));
    }

    @Override
    public J9HeapPointer untag() {
        return this.untag(UDATA.SIZEOF - 1);
    }

    @Override
    protected long sizeOfBaseType() {
        return J9Heap.SIZEOF;
    }

    @GeneratedFieldAccessor(offsetFieldName="_firstFreeBlockOffset_", declaredType="U32")
    public UDATA firstFreeBlock() throws CorruptDataException {
        return new U32(this.getIntAtOffset(J9Heap._firstFreeBlockOffset_));
    }

    public UDATAPointer firstFreeBlockEA() throws CorruptDataException {
        return UDATAPointer.cast(this.nonNullFieldEA(J9Heap._firstFreeBlockOffset_));
    }

    @GeneratedFieldAccessor(offsetFieldName="_heapSizeOffset_", declaredType="U32")
    public UDATA heapSize() throws CorruptDataException {
        return new U32(this.getIntAtOffset(J9Heap._heapSizeOffset_));
    }

    public UDATAPointer heapSizeEA() throws CorruptDataException {
        return UDATAPointer.cast(this.nonNullFieldEA(J9Heap._heapSizeOffset_));
    }

    @GeneratedFieldAccessor(offsetFieldName="_largestAllocSizeVisitedOffset_", declaredType="U32")
    public UDATA largestAllocSizeVisited() throws CorruptDataException {
        return new U32(this.getIntAtOffset(J9Heap._largestAllocSizeVisitedOffset_));
    }

    public UDATAPointer largestAllocSizeVisitedEA() throws CorruptDataException {
        return UDATAPointer.cast(this.nonNullFieldEA(J9Heap._largestAllocSizeVisitedOffset_));
    }

    @GeneratedFieldAccessor(offsetFieldName="_lastAllocSlotOffset_", declaredType="U32")
    public UDATA lastAllocSlot() throws CorruptDataException {
        return new U32(this.getIntAtOffset(J9Heap._lastAllocSlotOffset_));
    }

    public UDATAPointer lastAllocSlotEA() throws CorruptDataException {
        return UDATAPointer.cast(this.nonNullFieldEA(J9Heap._lastAllocSlotOffset_));
    }
}

