/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.memory;

import com.ibm.j9ddr.corereaders.memory.Addresses;
import com.ibm.j9ddr.corereaders.memory.IMemory;
import com.ibm.j9ddr.corereaders.memory.IMemoryRange;
import com.ibm.j9ddr.corereaders.memory.MemoryFault;
import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class SearchableMemory
implements IMemory {
    static final Logger logger = Logger.getLogger("j9ddr.core_readers");
    static final int BUFFER_MAX = 4096;
    static final int MINIMUM_PAGE_SIZE = 4096;
    protected long[][] rangeTable = null;
    private int mergedRanges = -1;

    private static int match(byte[] byArray, int n, byte[] byArray2, int n2) {
        int n3 = n;
        for (int i = n2; i < byArray2.length && n3 < byArray.length; ++i, ++n3) {
            if (byArray2[i] == byArray[n3]) continue;
            return 0;
        }
        return n3;
    }

    @Override
    public long findPattern(byte[] byArray, int n, long l) {
        int n2 = 0 == n ? 1 : n;
        logger.logp(Level.FINE, "AbstractMemory", "findPattern", "called with {0}, alignment {1}, startFrom, {2}", new Object[]{byArray, n, Long.toHexString(l)});
        int n3 = 4096;
        if (n3 < n2) {
            n3 = n2;
        } else if (0 != n3 % n2) {
            n3 -= n3 % n2;
        }
        long l2 = -1L;
        if (this.rangeTable == null) {
            this.rangeTable = this.buildRangeTable();
            logger.logp(Level.FINER, "AbstractMemory", "findPattern", "rangeTable contains {0} elements", this.rangeTable.length);
            this.mergedRanges = this.mergeRangeTable(this.rangeTable);
            logger.logp(Level.FINER, "AbstractMemory", "findPattern", "mergedRanges contains {0} elements", this.mergedRanges);
        }
        for (int i = 0; i < this.mergedRanges; ++i) {
            long l3 = this.rangeTable[i][0];
            long l4 = this.rangeTable[i][1];
            long l5 = l3 + l4 - 1L;
            if (l5 <= l || -1L == (l2 = this.findPatternInRange(byArray, n2, l, l3, l4, n3))) continue;
            logger.logp(Level.FINE, null, null, "Pattern matched at {0}", Long.toHexString(l2));
            break;
        }
        if (-1L == l2) {
            logger.logp(Level.FINE, null, null, "Pattern didn't match");
        }
        return l2;
    }

    protected int mergeRangeTable(long[][] lArray) {
        int n = 0;
        if (lArray.length == 0) {
            return 0;
        }
        for (int i = 1; i < lArray.length; ++i) {
            if (lArray[i][0] == lArray[n][0] + lArray[n][1]) {
                long[] lArray2 = lArray[n];
                lArray2[1] = lArray2[1] + lArray[i][1];
                continue;
            }
            lArray[++n][0] = lArray[i][0];
            lArray[n][1] = lArray[i][1];
        }
        return n + 1;
    }

    protected long[][] buildRangeTable() {
        ArrayList<? extends IMemoryRange> arrayList = new ArrayList<IMemoryRange>(this.getMemoryRanges());
        Collections.sort(arrayList);
        long[][] lArray = new long[arrayList.size()][2];
        int n = 0;
        for (IMemoryRange iMemoryRange : arrayList) {
            if (!iMemoryRange.isBacked()) continue;
            lArray[n][0] = iMemoryRange.getBaseAddress();
            lArray[n][1] = iMemoryRange.getSize();
            ++n;
        }
        return lArray;
    }

    private long findPatternInRange(byte[] byArray, int n, long l, long l2, long l3, int n2) {
        long l4 = l;
        if (l4 < l2) {
            l4 = l2;
        }
        if (0L != l4 % (long)n) {
            l4 += (long)n - l4 % (long)n;
        }
        long l5 = l2 + l3;
        int n3 = 0;
        long l6 = -1L;
        while (l4 < l5) {
            long l7 = l5 - l4;
            long l8 = (long)n2 < l7 ? (long)n2 : l7;
            byte[] byArray2 = new byte[(int)l8];
            try {
                this.getBytesAt(l4, byArray2);
            }
            catch (MemoryFault memoryFault) {
                if (Addresses.greaterThan(memoryFault.getAddress(), l4)) {
                    l8 = memoryFault.getAddress() - l4;
                    byArray2 = new byte[(int)l8];
                    try {
                        this.getBytesAt(l4, byArray2);
                    }
                    catch (MemoryFault memoryFault2) {
                        logger.log(Level.WARNING, "J9DDR findPattern algorithm broken. Double memory fault in findPatternInRange. addr={0}, count={1}", new Object[]{l4, l8});
                        l4 += l8;
                        continue;
                    }
                }
                l4 = this.findNextGoodAddress(l4, l5);
                continue;
            }
            if (null != byArray2) {
                if (0 != n3) {
                    n3 = SearchableMemory.match(byArray, n3, byArray2, 0);
                }
                for (int i = 0; i < byArray2.length && 0 == n3; i += n) {
                    l6 = l4 + (long)i;
                    n3 = SearchableMemory.match(byArray, 0, byArray2, i);
                }
                if (byArray.length == n3) {
                    return l6;
                }
            }
            l4 += l8;
        }
        return -1L;
    }

    private long findNextGoodAddress(long l, long l2) {
        long l3 = l - l % 4096L;
        for (long i = l3 + 4096L; i < l2; i += 4096L) {
            try {
                this.getByteAt(i);
                return i;
            }
            catch (MemoryFault memoryFault) {
                continue;
            }
        }
        return l2;
    }
}

