/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.ldap;

import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.StringTokenizer;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.naming.spi.NamingManager;

class ServiceLocator {
    private static final String SRV_RR = "SRV";
    private static final String[] SRV_RR_ATTR = new String[]{"SRV"};
    private static final Random random = new Random();

    private ServiceLocator() {
    }

    static String mapDnToDomainName(String string) throws InvalidNameException {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        LdapName ldapName = new LdapName(string);
        List<Rdn> list = ldapName.getRdns();
        for (int i = list.size() - 1; i >= 0; --i) {
            Rdn rdn = list.get(i);
            if (rdn.size() == 1 && "dc".equalsIgnoreCase(rdn.getType())) {
                Object object = rdn.getValue();
                if (object instanceof String) {
                    if (object.equals(".") || stringBuffer.length() == 1 && stringBuffer.charAt(0) == '.') {
                        stringBuffer.setLength(0);
                    }
                    if (stringBuffer.length() > 0) {
                        stringBuffer.append('.');
                    }
                    stringBuffer.append(object);
                    continue;
                }
                stringBuffer.setLength(0);
                continue;
            }
            stringBuffer.setLength(0);
        }
        return stringBuffer.length() != 0 ? stringBuffer.toString() : null;
    }

    static String[] getLdapService(String string, Map<?, ?> map) {
        if (map instanceof Hashtable) {
            return ServiceLocator.getLdapService(string, (Hashtable)map);
        }
        return ServiceLocator.getLdapService(string, new Hashtable(map));
    }

    static String[] getLdapService(String string, Hashtable<?, ?> hashtable) {
        if (string == null || string.length() == 0) {
            return null;
        }
        String string2 = "dns:///_ldap._tcp." + string;
        String[] stringArray = null;
        try {
            Attribute attribute;
            Context context = NamingManager.getURLContext("dns", hashtable);
            if (!(context instanceof DirContext)) {
                return null;
            }
            Attributes attributes = ((DirContext)context).getAttributes(string2, SRV_RR_ATTR);
            if (attributes != null && (attribute = attributes.get(SRV_RR)) != null) {
                int n = attribute.size();
                int n2 = 0;
                Object[] objectArray = new SrvRecord[n];
                int n3 = 0;
                for (int i = 0; i < n; ++i) {
                    try {
                        objectArray[n3] = new SrvRecord((String)attribute.get(i));
                        ++n3;
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                n2 = n3;
                if (n2 < n) {
                    SrvRecord[] srvRecordArray = new SrvRecord[n2];
                    System.arraycopy((Object)objectArray, 0, (Object)srvRecordArray, 0, n2);
                    objectArray = srvRecordArray;
                }
                if (n2 > 1) {
                    Arrays.sort(objectArray);
                }
                stringArray = ServiceLocator.extractHostports((SrvRecord[])objectArray);
            }
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        return stringArray;
    }

    private static String[] extractHostports(SrvRecord[] srvRecordArray) {
        String[] stringArray = null;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < srvRecordArray.length; ++i) {
            if (stringArray == null) {
                stringArray = new String[srvRecordArray.length];
            }
            n = i;
            while (i < srvRecordArray.length - 1 && srvRecordArray[i].priority == srvRecordArray[i + 1].priority) {
                ++i;
            }
            n2 = i;
            n3 = n2 - n + 1;
            for (int j = 0; j < n3; ++j) {
                stringArray[n4++] = ServiceLocator.selectHostport(srvRecordArray, n, n2);
            }
        }
        return stringArray;
    }

    private static String selectHostport(SrvRecord[] srvRecordArray, int n, int n2) {
        if (n == n2) {
            return srvRecordArray[n].hostport;
        }
        int n3 = 0;
        for (int i = n; i <= n2; ++i) {
            if (srvRecordArray[i] == null) continue;
            srvRecordArray[i].sum = n3 += srvRecordArray[i].weight;
        }
        String string = null;
        int n4 = n3 == 0 ? 0 : random.nextInt(n3 + 1);
        for (int i = n; i <= n2; ++i) {
            if (srvRecordArray[i] == null || srvRecordArray[i].sum < n4) continue;
            string = srvRecordArray[i].hostport;
            srvRecordArray[i] = null;
            break;
        }
        return string;
    }

    static class SrvRecord
    implements Comparable<SrvRecord> {
        int priority;
        int weight;
        int sum;
        String hostport;

        SrvRecord(String string) throws Exception {
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
            if (stringTokenizer.countTokens() != 4) {
                throw new IllegalArgumentException();
            }
            this.priority = Integer.parseInt(stringTokenizer.nextToken());
            this.weight = Integer.parseInt(stringTokenizer.nextToken());
            String string2 = stringTokenizer.nextToken();
            this.hostport = stringTokenizer.nextToken() + ":" + string2;
        }

        @Override
        public int compareTo(SrvRecord srvRecord) {
            if (this.priority > srvRecord.priority) {
                return 1;
            }
            if (this.priority < srvRecord.priority) {
                return -1;
            }
            if (this.weight == 0 && srvRecord.weight != 0) {
                return -1;
            }
            if (this.weight != 0 && srvRecord.weight == 0) {
                return 1;
            }
            return 0;
        }
    }
}

