/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import com.ibm.oti.util.Msg;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Member;

public interface MethodHandleInfo {
    public static final int REF_getField = 1;
    public static final int REF_getStatic = 2;
    public static final int REF_putField = 3;
    public static final int REF_putStatic = 4;
    public static final int REF_invokeVirtual = 5;
    public static final int REF_invokeStatic = 6;
    public static final int REF_invokeSpecial = 7;
    public static final int REF_newInvokeSpecial = 8;
    public static final int REF_invokeInterface = 9;

    public Class<?> getDeclaringClass();

    public String getName();

    public MethodType getMethodType();

    public int getModifiers();

    public int getReferenceKind();

    default public boolean isVarArgs() {
        if (this.getReferenceKind() >= 5) {
            return (this.getModifiers() & 0x80) != 0;
        }
        return false;
    }

    public <T extends Member> T reflectAs(Class<T> var1, MethodHandles.Lookup var2);

    public static String referenceKindToString(int n) throws IllegalArgumentException {
        switch (n) {
            case 1: {
                return "getField";
            }
            case 2: {
                return "getStatic";
            }
            case 3: {
                return "putField";
            }
            case 4: {
                return "putStatic";
            }
            case 5: {
                return "invokeVirtual";
            }
            case 6: {
                return "invokeStatic";
            }
            case 7: {
                return "invokeSpecial";
            }
            case 8: {
                return "newInvokeSpecial";
            }
            case 9: {
                return "invokeInterface";
            }
        }
        throw new IllegalArgumentException(Msg.getString("K0582", n));
    }

    public static String toString(int n, Class<?> clazz, String string, MethodType methodType) {
        return MethodHandleInfo.referenceKindToString(n) + " " + clazz.getName() + "." + string + ":" + methodType;
    }
}

