/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.util;

import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.RandomAccess;

public class IdentityArrayList<E>
extends AbstractList<E>
implements List<E>,
RandomAccess {
    private transient Object[] elementData;
    private int size;

    public IdentityArrayList(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + n);
        }
        this.elementData = new Object[n];
    }

    public IdentityArrayList() {
        this(10);
    }

    public IdentityArrayList(Collection<? extends E> collection) {
        this.elementData = collection.toArray();
        this.size = this.elementData.length;
        if (this.elementData.getClass() != Object[].class) {
            this.elementData = Arrays.copyOf(this.elementData, this.size, Object[].class);
        }
    }

    public void trimToSize() {
        ++this.modCount;
        int n = this.elementData.length;
        if (this.size < n) {
            this.elementData = Arrays.copyOf(this.elementData, this.size);
        }
    }

    public void ensureCapacity(int n) {
        ++this.modCount;
        int n2 = this.elementData.length;
        if (n > n2) {
            Object[] objectArray = this.elementData;
            int n3 = n2 * 3 / 2 + 1;
            if (n3 < n) {
                n3 = n;
            }
            this.elementData = Arrays.copyOf(this.elementData, n3);
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean contains(Object object) {
        return this.indexOf(object) >= 0;
    }

    @Override
    public int indexOf(Object object) {
        for (int i = 0; i < this.size; ++i) {
            if (object != this.elementData[i]) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object object) {
        for (int i = this.size - 1; i >= 0; --i) {
            if (object != this.elementData[i]) continue;
            return i;
        }
        return -1;
    }

    @Override
    public Object[] toArray() {
        return Arrays.copyOf(this.elementData, this.size);
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        if (TArray.length < this.size) {
            return Arrays.copyOf(this.elementData, this.size, TArray.getClass());
        }
        System.arraycopy((Object)this.elementData, 0, TArray, 0, this.size);
        if (TArray.length > this.size) {
            TArray[this.size] = null;
        }
        return TArray;
    }

    @Override
    public E get(int n) {
        this.rangeCheck(n);
        return (E)this.elementData[n];
    }

    @Override
    public E set(int n, E e) {
        this.rangeCheck(n);
        Object object = this.elementData[n];
        this.elementData[n] = e;
        return (E)object;
    }

    @Override
    public boolean add(E e) {
        this.ensureCapacity(this.size + 1);
        this.elementData[this.size++] = e;
        return true;
    }

    @Override
    public void add(int n, E e) {
        this.rangeCheckForAdd(n);
        this.ensureCapacity(this.size + 1);
        System.arraycopy((Object)this.elementData, n, (Object)this.elementData, n + 1, this.size - n);
        this.elementData[n] = e;
        ++this.size;
    }

    @Override
    public E remove(int n) {
        this.rangeCheck(n);
        ++this.modCount;
        Object object = this.elementData[n];
        int n2 = this.size - n - 1;
        if (n2 > 0) {
            System.arraycopy((Object)this.elementData, n + 1, (Object)this.elementData, n, n2);
        }
        this.elementData[--this.size] = null;
        return (E)object;
    }

    @Override
    public boolean remove(Object object) {
        for (int i = 0; i < this.size; ++i) {
            if (object != this.elementData[i]) continue;
            this.fastRemove(i);
            return true;
        }
        return false;
    }

    private void fastRemove(int n) {
        ++this.modCount;
        int n2 = this.size - n - 1;
        if (n2 > 0) {
            System.arraycopy((Object)this.elementData, n + 1, (Object)this.elementData, n, n2);
        }
        this.elementData[--this.size] = null;
    }

    @Override
    public void clear() {
        ++this.modCount;
        for (int i = 0; i < this.size; ++i) {
            this.elementData[i] = null;
        }
        this.size = 0;
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        Object[] objectArray = collection.toArray();
        int n = objectArray.length;
        this.ensureCapacity(this.size + n);
        System.arraycopy((Object)objectArray, 0, (Object)this.elementData, this.size, n);
        this.size += n;
        return n != 0;
    }

    @Override
    public boolean addAll(int n, Collection<? extends E> collection) {
        this.rangeCheckForAdd(n);
        Object[] objectArray = collection.toArray();
        int n2 = objectArray.length;
        this.ensureCapacity(this.size + n2);
        int n3 = this.size - n;
        if (n3 > 0) {
            System.arraycopy((Object)this.elementData, n, (Object)this.elementData, n + n2, n3);
        }
        System.arraycopy((Object)objectArray, 0, (Object)this.elementData, n, n2);
        this.size += n2;
        return n2 != 0;
    }

    @Override
    protected void removeRange(int n, int n2) {
        ++this.modCount;
        int n3 = this.size - n2;
        System.arraycopy((Object)this.elementData, n2, (Object)this.elementData, n, n3);
        int n4 = this.size - (n2 - n);
        while (this.size != n4) {
            this.elementData[--this.size] = null;
        }
    }

    private void rangeCheck(int n) {
        if (n >= this.size) {
            throw new IndexOutOfBoundsException(this.outOfBoundsMsg(n));
        }
    }

    private void rangeCheckForAdd(int n) {
        if (n > this.size || n < 0) {
            throw new IndexOutOfBoundsException(this.outOfBoundsMsg(n));
        }
    }

    private String outOfBoundsMsg(int n) {
        return "Index: " + n + ", Size: " + this.size;
    }
}

