/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.trace.format.api;

import com.ibm.jvm.trace.format.api.DataHeader;
import com.ibm.jvm.trace.format.api.TraceContext;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;

public class ServiceSection {
    TraceContext context;
    String serviceString;
    String textSummary;

    public ServiceSection(TraceContext traceContext, ByteBuffer byteBuffer) throws IllegalArgumentException {
        this.context = traceContext;
        DataHeader dataHeader = new DataHeader(traceContext, byteBuffer, "UTSS");
        byte[] byArray = new byte[dataHeader.length - 16];
        byteBuffer.get(byArray);
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] != 0) continue;
            try {
                this.serviceString = new String(byArray, 0, i, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                this.serviceString = new String(byArray, 0, i);
            }
            break;
        }
        if (traceContext.debugStream != null) {
            traceContext.debug(this, 1, this.summary());
        }
    }

    public String toString() {
        return "Service level";
    }

    public String summary() {
        if (this.textSummary == null) {
            StringBuilder stringBuilder = new StringBuilder(this.toString() + ":" + System.getProperty("line.separator"));
            stringBuilder.append("        ");
            stringBuilder.append(this.serviceString).append(System.getProperty("line.separator"));
            this.textSummary = stringBuilder.toString();
        }
        return this.textSummary;
    }
}

