/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr;

import jdk.internal.org.objectweb.asm.MethodVisitor;
import jdk.internal.org.objectweb.asm.Opcodes;

abstract class HelperBase
implements Opcodes {
    static final String byteFromLong = "(J)B";
    static final String doubleFromLong = "(J)D";
    static final String doubleFromVoid = "()D";
    static final String floatFromLong = "(J)F";
    static final String floatFromVoid = "()F";
    static final String intFromLong = "(J)I";
    static final String longFromLong = "(J)J";
    static final String longFromVoid = "()J";
    static final String shortFromLong = "(J)S";
    static final String voidFromLong = "(J)V";
    static final String voidMethod = "()V";

    HelperBase() {
    }

    static final void addLong(MethodVisitor methodVisitor, long l) {
        if (l != 0L) {
            HelperBase.loadLong(methodVisitor, l);
            methodVisitor.visitInsn(97);
        }
    }

    static final void loadInt(MethodVisitor methodVisitor, int n) {
        switch (n) {
            case -1: {
                methodVisitor.visitInsn(2);
                break;
            }
            case 0: {
                methodVisitor.visitInsn(3);
                break;
            }
            case 1: {
                methodVisitor.visitInsn(4);
                break;
            }
            case 2: {
                methodVisitor.visitInsn(5);
                break;
            }
            case 3: {
                methodVisitor.visitInsn(6);
                break;
            }
            case 4: {
                methodVisitor.visitInsn(7);
                break;
            }
            case 5: {
                methodVisitor.visitInsn(8);
                break;
            }
            default: {
                if (-128 <= n && n <= 127) {
                    methodVisitor.visitIntInsn(16, n);
                    break;
                }
                if (Short.MIN_VALUE <= n && n <= Short.MAX_VALUE) {
                    methodVisitor.visitIntInsn(17, n);
                    break;
                }
                methodVisitor.visitLdcInsn(n);
            }
        }
    }

    static final void loadLong(MethodVisitor methodVisitor, long l) {
        if (l == 0L) {
            methodVisitor.visitInsn(9);
        } else if (l == 1L) {
            methodVisitor.visitInsn(10);
        } else {
            methodVisitor.visitLdcInsn(l);
        }
    }
}

