/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.elf.unwind;

import com.ibm.j9ddr.corereaders.elf.unwind.Unwind;
import com.ibm.j9ddr.corereaders.elf.unwind.UnwindTable;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.ByteOrder;
import javax.imageio.stream.ImageInputStream;

class CIE {
    private final Unwind unwind;
    protected String augmentationStr;
    protected byte[] augmentationData;
    private byte personalityRoutinePointerEncoding;
    private long personalityRoutinePointer;
    private byte lsdaPointerEncoding;
    byte fdePointerEncoding = 0;
    private byte[] initialInstructions;
    private long startPos;
    private long length;
    private byte cieVersion;
    long codeAlignmentFactor;
    long dataAlignmentFactor;
    public final long returnAddressRegister;
    final ByteOrder byteOrder;
    final int wordSize;
    private boolean signalHandlerFrame;

    public CIE(Unwind unwind, ImageInputStream imageInputStream, long l, long l2) throws IOException {
        int n;
        long l3;
        this.unwind = unwind;
        this.startPos = l - 4L;
        this.length = l2;
        this.byteOrder = this.unwind.process.getByteOrder();
        this.wordSize = this.unwind.process.bytesPerPointer();
        this.cieVersion = imageInputStream.readByte();
        if (this.cieVersion != 1 && this.cieVersion != 3) {
            throw new IOException(String.format("Invalid CIE version %d", this.cieVersion));
        }
        byte[] byArray = new byte[5];
        int n2 = 0;
        byArray[0] = imageInputStream.readByte();
        while (byArray[n2++] != 0) {
            byArray[n2] = imageInputStream.readByte();
        }
        this.augmentationStr = new String(byArray, "ASCII");
        if ("eh".equals(this.augmentationStr)) {
            l3 = this.unwind.process.bytesPerPointer() == 8 ? imageInputStream.readLong() : (long)imageInputStream.readInt();
        }
        this.codeAlignmentFactor = Unwind.readUnsignedLEB128(imageInputStream);
        this.dataAlignmentFactor = Unwind.readSignedLEB128(imageInputStream);
        this.returnAddressRegister = this.cieVersion == 1 ? (long)imageInputStream.readByte() : Unwind.readUnsignedLEB128(imageInputStream);
        if (this.augmentationStr.startsWith("z")) {
            l3 = Unwind.readUnsignedLEB128(imageInputStream);
            this.parseAugmentationData(imageInputStream, this.augmentationStr);
        }
        if ((n = (int)(l2 - (imageInputStream.getStreamPosition() - l))) < 0) {
            throw new IOException(String.format("Negative size %d for initial instructions in CIE", n));
        }
        this.initialInstructions = new byte[n];
        imageInputStream.read(this.initialInstructions, 0, this.initialInstructions.length);
        int n3 = (int)(imageInputStream.getStreamPosition() % (long)this.unwind.process.bytesPerPointer());
        imageInputStream.read(new byte[n3], 0, n3);
    }

    private void parseAugmentationData(ImageInputStream imageInputStream, String string) throws IOException {
        for (int i = 0; i < string.length(); ++i) {
            if ('z' == string.charAt(i)) continue;
            if ('P' == string.charAt(i)) {
                this.personalityRoutinePointerEncoding = imageInputStream.readByte();
                this.personalityRoutinePointer = this.unwind.readEncodedPC(imageInputStream, this.personalityRoutinePointerEncoding);
            }
            if ('L' == string.charAt(i)) {
                this.lsdaPointerEncoding = imageInputStream.readByte();
            }
            if ('R' == string.charAt(i)) {
                this.fdePointerEncoding = imageInputStream.readByte();
            }
            if ('S' != string.charAt(i)) continue;
            this.signalHandlerFrame = true;
        }
    }

    public void dump(PrintStream printStream) throws IOException {
        printStream.printf("Position 0x%x, length 0x%x, CIE ptr 0x%x\n", this.startPos, this.length, 0);
        printStream.printf("\tVersion %d\n", this.cieVersion);
        printStream.printf("\tAugmentation String: %s\n", this.augmentationStr);
        printStream.printf("\tCode Alignment: %d\n", this.codeAlignmentFactor);
        printStream.printf("\tData Alignment: %d\n", this.dataAlignmentFactor);
        printStream.printf("\tReturn Addr Reg: %d\n", this.returnAddressRegister);
        UnwindTable.dumpInstructions(printStream, this.initialInstructions, this);
        printStream.println();
    }

    public byte[] getInitialInstructions() {
        return this.initialInstructions;
    }
}

